/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankPayService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankBindBankAccountReqBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankBindBankAccountRspBO;
import com.tydic.fsc.common.busi.api.FscBindBankAccountBusiService;
import com.tydic.fsc.common.busi.bo.FscBindBankAccountBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscBindBankAccountBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscLegalCompanyPO;
import com.tydic.umc.general.ability.api.UmcQryMemLegalOrgInfoAbilityService;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceReqBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceRspBO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class FscBindBankAccountBusiServiceImpl
implements FscBindBankAccountBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBindBankAccountBusiServiceImpl.class);
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscBToBPingAnBankPayService fscBToBPingAnBankPayService;
    @Autowired
    private UmcQryMemLegalOrgInfoAbilityService umcQryMemLegalOrgInfoAbilityService;

    @Override
    public FscBindBankAccountBusiRspBO bindBankAccount(FscBindBankAccountBusiReqBO reqBO) {
        String accountNo = reqBO.getAccountNo();
        FscAccountPO accountPO = new FscAccountPO();
        accountPO.setAccountNo(accountNo);
        FscAccountPO returnAccountPO = this.fscAccountMapper.getModelBy(accountPO);
        log.debug("\u5f00\u59cb\u8c03\u53d6\u94f6\u884c\u63a5\u53e3\u6267\u884c\u8d26\u6237\u7ed1\u5b9a!");
        FscBToBPingAnBankBindBankAccountReqBO fscBToBPingAnBankBindBankAccountReqBO = (FscBToBPingAnBankBindBankAccountReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), FscBToBPingAnBankBindBankAccountReqBO.class);
        fscBToBPingAnBankBindBankAccountReqBO.setSubAcctNo(reqBO.getSubAccountNo());
        fscBToBPingAnBankBindBankAccountReqBO.setTranNetMemberCode(reqBO.getLegalOrgId());
        fscBToBPingAnBankBindBankAccountReqBO.setMemberName(reqBO.getLegalOrgName());
        fscBToBPingAnBankBindBankAccountReqBO.setMemberGlobalType("73");
        fscBToBPingAnBankBindBankAccountReqBO.setMemberGlobalId(reqBO.getLegalCertNumber());
        fscBToBPingAnBankBindBankAccountReqBO.setMemberAcctNo(reqBO.getAccountNo());
        if (1 == reqBO.getIsPabc()) {
            fscBToBPingAnBankBindBankAccountReqBO.setBankType("1");
        } else {
            fscBToBPingAnBankBindBankAccountReqBO.setBankType("2");
        }
        fscBToBPingAnBankBindBankAccountReqBO.setAcctOpenBranchName(reqBO.getDepositBankName());
        fscBToBPingAnBankBindBankAccountReqBO.setCnapsBranchId(reqBO.getSizeLineNumber());
        fscBToBPingAnBankBindBankAccountReqBO.setEiconBankBranchId(reqBO.getSuperLineNumber());
        fscBToBPingAnBankBindBankAccountReqBO.setMobile(reqBO.getPhone());
        fscBToBPingAnBankBindBankAccountReqBO.setIndivBusinessFlag("2");
        if (reqBO.getOrgId() != null) {
            fscBToBPingAnBankBindBankAccountReqBO.setShopId(reqBO.getOrgId().toString());
        }
        fscBToBPingAnBankBindBankAccountReqBO.setShopName(reqBO.getOrgName());
        if (reqBO.getIsTransactor() != null) {
            fscBToBPingAnBankBindBankAccountReqBO.setAgencyClientFlag(reqBO.getIsTransactor().toString());
        }
        fscBToBPingAnBankBindBankAccountReqBO.setAgencyClientName(reqBO.getTransactorName());
        if (reqBO.getTransactorCertType() != null) {
            fscBToBPingAnBankBindBankAccountReqBO.setAgencyClientGlobalType(reqBO.getTransactorCertType().toString());
        }
        fscBToBPingAnBankBindBankAccountReqBO.setAgencyClientGlobalId(reqBO.getTransactorCertNo());
        fscBToBPingAnBankBindBankAccountReqBO.setAgencyClientMobile(reqBO.getTransactorPhone());
        if (reqBO.getIsLegalPerson() != null) {
            fscBToBPingAnBankBindBankAccountReqBO.setRepFlag(reqBO.getIsLegalPerson().toString());
        }
        fscBToBPingAnBankBindBankAccountReqBO.setReprName(reqBO.getLegalPersonName());
        if (reqBO.getLegalPersonCertType() != null) {
            fscBToBPingAnBankBindBankAccountReqBO.setReprGlobalType(reqBO.getLegalPersonCertType().toString());
        }
        fscBToBPingAnBankBindBankAccountReqBO.setReprGlobalId(reqBO.getLegalPersonCertNo());
        log.debug("\u8c03\u53d6\u94f6\u884c\u7ed1\u5b9a\u63a5\u53e3\u5165\u53c2:{}", (Object)fscBToBPingAnBankBindBankAccountReqBO);
        FscBToBPingAnBankBindBankAccountRspBO fscBToBPingAnBankBindBankAccountRspBO = this.fscBToBPingAnBankPayService.bindAccount(fscBToBPingAnBankBindBankAccountReqBO);
        log.debug("\u8c03\u53d6\u94f6\u884c\u7ed1\u5b9a\u63a5\u53e3\u51fa\u53c2:{}", (Object)fscBToBPingAnBankBindBankAccountRspBO);
        if (!"0000".equals(fscBToBPingAnBankBindBankAccountRspBO.getRespCode())) {
            log.error("\u94f6\u884c\u63a5\u53e3\u8c03\u7528\u5f02\u5e38!");
            throw new FscBusinessException("198888", fscBToBPingAnBankBindBankAccountRspBO.getRespDesc());
        }
        UmcQryMemLegalOrgInfoAbilityServiceReqBO umcReqBO = new UmcQryMemLegalOrgInfoAbilityServiceReqBO();
        umcReqBO.setMemId(reqBO.getUserId());
        umcReqBO.setCorporationId(Long.valueOf(Long.parseLong(reqBO.getLegalOrgId())));
        log.debug("\u4f1a\u5458\u4fe1\u606f\u67e5\u8be2\u5165\u53c2:{}", (Object)umcReqBO);
        UmcQryMemLegalOrgInfoAbilityServiceRspBO umcRspBO = this.umcQryMemLegalOrgInfoAbilityService.qryMemLegalOrgInfo(umcReqBO);
        log.debug("\u4f1a\u5458\u4fe1\u606f\u67e5\u8be2\u51fa\u53c2:{}", (Object)umcRspBO);
        if (umcRspBO == null || umcRspBO.getMemInformation() == null || umcRspBO.getLegalOrgInfo() == null) {
            throw new FscBusinessException("198888", "\u4f1a\u5458\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38!");
        }
        log.debug("\u65b0\u589e\u8d26\u6237\u6570\u636e\u5165\u53c2[reqBO]:{}", (Object)reqBO);
        FscAccountPO insertAccountPO = (FscAccountPO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}), FscAccountPO.class);
        log.debug("\u65b0\u589e\u8d26\u6237\u6570\u636e\u63d2\u5165\u6570\u636e\u5e93\u5165\u53c2[insertAccountPO]:{}", (Object)insertAccountPO);
        insertAccountPO.setCreateTime(new Date());
        if (!StringUtils.isEmpty((Object)reqBO.getLegalOrgId())) {
            insertAccountPO.setOrgId(Long.valueOf(Long.parseLong(reqBO.getLegalOrgId())));
        }
        insertAccountPO.setCreateMethod(Integer.valueOf(2));
        insertAccountPO.setCreateOperId(reqBO.getUserId() + "");
        try {
            insertAccountPO.setAccountCategory(Integer.valueOf(reqBO.getIsprofess()));
        }
        catch (NumberFormatException e) {
            throw new FscBusinessException("198888", "\u8d26\u6237\u7c7b\u522b\u683c\u5f0f\u8f6c\u6362\u9519\u8bef:" + e.getMessage());
        }
        insertAccountPO.setB2bStatus(Integer.valueOf(1));
        if (fscBToBPingAnBankBindBankAccountRspBO.getFrontSeqNo() != null) {
            insertAccountPO.setFrontSeqNo(fscBToBPingAnBankBindBankAccountRspBO.getFrontSeqNo());
        }
        log.info("\u83b7\u53d6\u94f6\u884c\u524d\u7f6e\u6d41\u6c34\u53f7:{}", (Object)fscBToBPingAnBankBindBankAccountRspBO.getFrontSeqNo());
        insertAccountPO.setLegalCertNo(reqBO.getLegalPersonCertNo());
        insertAccountPO.setLegalCertType(reqBO.getLegalPersonCertType());
        insertAccountPO.setLegalName(reqBO.getLegalPersonName());
        insertAccountPO.setStatus(FscConstants.AccountStatus.AUTHING);
        insertAccountPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        log.debug("\u65b0\u589e\u8d26\u6237\u4fe1\u606f\u5165\u53c2:{}", (Object)insertAccountPO);
        if (null == returnAccountPO) {
            int e = this.fscAccountMapper.insert(insertAccountPO);
        } else {
            insertAccountPO.setId(returnAccountPO.getId());
            this.fscAccountMapper.updateById(insertAccountPO);
        }
        Long orgId = insertAccountPO.getOrgId();
        FscLegalCompanyPO existPO = this.fscLegalCompanyMapper.getById(orgId);
        if (existPO == null) {
            FscLegalCompanyPO fscLegalCompanyPO = new FscLegalCompanyPO();
            fscLegalCompanyPO.setOrgId(orgId).setOrgName(reqBO.getOrgName()).setSubAccountNo(reqBO.getSubAccountNo()).setDepositBankName("\u5e73\u5b89\u94f6\u884c").setOrgCertificateCode(reqBO.getLegalCertNumber()).setCreateOperId(reqBO.getUserId() + "").setCreateOperName(reqBO.getUserName()).setCreateTime(new Date()).setStatus(Integer.valueOf(3));
            if ("2".equals(umcRspBO.getLegalOrgInfo().getTradeCapacity())) {
                fscLegalCompanyPO.setMemberType("SH");
            } else {
                fscLegalCompanyPO.setMemberType("00");
            }
            int insertRows = this.fscLegalCompanyMapper.insert(fscLegalCompanyPO);
            if (insertRows != 1) {
                log.warn("\u6cd5\u4eba\u516c\u53f8\u4fe1\u606f\u6dfb\u52a0\u5931\u8d25!");
            }
        }
        FscBindBankAccountBusiRspBO rspBO = new FscBindBankAccountBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u7ed1\u5b9a\u6210\u529f!");
        return rspBO;
    }
}

