/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.base.FscRspBaseBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.busibase.config.FscEsConfig;
import com.tydic.fsc.common.busi.api.FscComInvoiceListSyncEsBusiService;
import com.tydic.fsc.common.busi.api.FscEsSyncComInvoiceBusiService;
import com.tydic.fsc.common.busi.bo.FscComInvoiceListEsSyncRspBO;
import com.tydic.fsc.common.busi.bo.FscComInvoiceListQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComInvoiceListSyncRspBO;
import com.tydic.fsc.common.consumer.bo.FscInvoiceDeleteSyncReqBO;
import com.tydic.fsc.common.consumer.bo.FscInvoiceSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.utils.FscElasticsearchUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscInvoiceEsSyncServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscInvoiceEsSyncServiceConsumer.class);
    @Autowired
    private FscEsSyncComInvoiceBusiService fscEsSyncComInvoiceBusiService;
    @Autowired
    private FscComInvoiceListSyncEsBusiService fscComInvoiceListSyncEsBusiService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscEsConfig fscEsConfig;
    @Autowired
    private FscElasticsearchUtil fscElasticsearchUtil;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        try {
            FscComInvoiceListSyncRspBO fscComInvoiceListSyncRspBO;
            log.debug("---------------\u5f00\u7968\u4e3b\u5355\u53d1\u7968ES\u540c\u6b65\u5f00\u59cb---------------");
            FscInvoiceSyncReqBO fscInvoiceSyncReqBO = (FscInvoiceSyncReqBO)JSON.parseObject((String)proxyMessage.getContent(), (TypeReference)new TypeReference<FscInvoiceSyncReqBO>(){}, (Feature[])new Feature[0]);
            log.debug("ES\u5f00\u7968\u4e3b\u5355\u53d1\u7968\u7d22\u5f15\u540c\u6b65\u8f6c\u6362\u540e\u5f97\u5230\u7684\u6d88\u8d39\u8005\u5165\u53c2\u53c2\u6570\u4e3a{}", (Object)JSON.toJSONString((Object)fscInvoiceSyncReqBO));
            if (fscInvoiceSyncReqBO.getFscOrderId() == null) {
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            if (fscInvoiceSyncReqBO.getFscOrderId() == 0L) {
                log.error("ES\u5f00\u7968\u4e3b\u5355\u53d1\u7968\u7d22\u5f15\u540c\u6b65\u5931\u8d25\uff01fscOrderId\u4e3a\u96f6,\u53c2\u6570\u4e3a\uff1a{}", (Object)fscInvoiceSyncReqBO.getFscOrderId());
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            try {
                FscComInvoiceListQueryBusiReqBO fscComInvoiceListQueryBusiReqBO = (FscComInvoiceListQueryBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)fscInvoiceSyncReqBO), FscComInvoiceListQueryBusiReqBO.class));
                fscComInvoiceListSyncRspBO = this.fscComInvoiceListSyncEsBusiService.dealBillInvoiceListSyncEs(fscComInvoiceListQueryBusiReqBO);
            }
            catch (Exception e) {
                log.error("ES\u540c\u6b65\u67e5\u8be2\u5931\u8d25\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscInvoiceSyncReqBO));
                this.writeFailLog(fscInvoiceSyncReqBO.getFscOrderId(), null);
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            if ("0000".equals(fscComInvoiceListSyncRspBO.getRespCode())) {
                FscComInvoiceListEsSyncRspBO fscComInvoiceListEsSyncRspBO;
                FscInvoiceDeleteSyncReqBO fscInvoiceDeleteSyncReqBO = (FscInvoiceDeleteSyncReqBO)JSON.parseObject((String)proxyMessage.getContent(), (TypeReference)new TypeReference<FscInvoiceDeleteSyncReqBO>(){}, (Feature[])new Feature[0]);
                String endPoint = "/" + this.fscEsConfig.getInvoiceIndexName() + "/_delete_by_query";
                JSONObject deleteConditionJson = new JSONObject();
                deleteConditionJson.put("fscOrderId", (Object)fscInvoiceDeleteSyncReqBO.getFscOrderId());
                JSONObject termJson = new JSONObject();
                termJson.put("term", (Object)deleteConditionJson);
                JSONObject qryJson = new JSONObject();
                qryJson.put("query", (Object)termJson);
                log.info("\u5220\u9664\u53d1\u7968\u4fe1\u606f\u5730\u5740:{},\u5165\u53c2:{}", (Object)endPoint, (Object)qryJson);
                Boolean aBoolean = this.fscElasticsearchUtil.deleteDataByCondition(endPoint, qryJson);
                if (!aBoolean.booleanValue()) {
                    log.debug("---------------\u5220\u9664\u5931\u8d25---------------");
                }
                if (!"0000".equals((fscComInvoiceListEsSyncRspBO = this.fscEsSyncComInvoiceBusiService.esSyncBillInvoiceList(fscComInvoiceListSyncRspBO.getFscOrderInvoiceEsSyncReqBOList())).getRespCode())) {
                    log.error("ES\u540c\u6b65\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)fscComInvoiceListEsSyncRspBO.getRespDesc());
                    this.writeFailLog(fscInvoiceSyncReqBO.getFscOrderId(), fscComInvoiceListEsSyncRspBO);
                    return ProxyConsumerStatus.RECONSUME_LATER;
                }
                log.debug("---------------ES\u540c\u6b65\u7d22\u5f15\u6d88\u8d39\u8005\u7ed3\u675f---------------");
                return ProxyConsumerStatus.CONSUME_SUCCESS;
            }
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }

    private void writeFailLog(Long fscOrderId, FscRspBaseBO rspBO) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(fscOrderId);
        if (null != rspBO) {
            fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(rspBO.getRespDesc());
        }
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ES);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

