/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.atom.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.atom.api.FscQryMsgFromInterService;
import com.tydic.fsc.common.atom.bo.FscBusiQryMsgReqBO;
import com.tydic.fsc.common.atom.bo.FscBusiQryMsgRspBO;
import com.tydic.fsc.common.atom.bo.ResultVO;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.utils.EsbParamUtil;
import com.tydic.fsc.utils.SSLClient;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="fscQryMsgFromInterService")
public class FscQryMsgFromInterServiceImpl
implements FscQryMsgFromInterService {
    private static final Logger log = LoggerFactory.getLogger(FscQryMsgFromInterServiceImpl.class);
    @Autowired
    private Environment prop;
    @Value(value="${FSC_GET_MSG_ECOM_URL:}")
    private String FSC_GET_MSG_ECOM_URL;

    @Override
    public FscBusiQryMsgRspBO qryMsg(FscBusiQryMsgReqBO reqBo) {
        FscBusiQryMsgRspBO busiQryMsgRspBO = new FscBusiQryMsgRspBO();
        try {
            String reqStr = this.initReq(reqBo);
            String rspJson = SSLClient.doPost((String)this.FSC_GET_MSG_ECOM_URL, (String)reqStr);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)rspJson)) {
                throw new FscBusinessException("194315", "\u8c03\u7528\u5916\u90e8\u7535\u5546\u83b7\u53d6\u6d88\u606f\u6570\u636e\u8fd4\u56de\u7a7a");
            }
            FscBusiQryMsgRspBO resolveRsp = this.resolveRsp(rspJson, reqBo.getType());
            if (null == resolveRsp.getResult()) {
                return busiQryMsgRspBO;
            }
            if (resolveRsp != null) {
                log.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + (Object)((Object)resolveRsp));
            }
            resolveRsp.setRespCode("0000");
            resolveRsp.setRespDesc("\u6210\u529f");
            return resolveRsp;
        }
        catch (Exception var9) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u8c03\u7528\u5931\u8d25" + var9);
            busiQryMsgRspBO.setRespCode("8888");
            busiQryMsgRspBO.setRespDesc("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u4e1a\u52a1\u5931\u8d25");
            return busiQryMsgRspBO;
        }
    }

    private String initReq(FscBusiQryMsgReqBO reqBO) {
        String hsn = this.prop.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        return EsbParamUtil.getEsbReqStr((String)JSON.toJSONString((Object)reqBO), (String)hsn, (String)"BUSINESS_PAY");
    }

    private FscBusiQryMsgRspBO resolveRsp(String returnString, Integer type) {
        FscBusiQryMsgRspBO busiQryMsgRspBO = new FscBusiQryMsgRspBO();
        ArrayList<ResultVO> list = new ArrayList<ResultVO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            busiQryMsgRspBO.setSuccess(rspJsonObject.getBoolean("success"));
            busiQryMsgRspBO.setResultCode(rspJsonObject.getString("resultCode"));
            busiQryMsgRspBO.setResultMessage(rspJsonObject.getString("resultMessage"));
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                for (int i = 0; i < object.size(); ++i) {
                    JSONObject obj = (JSONObject)object.get(i);
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    Object result = null;
                    if (!StringUtils.isEmpty((Object)jsonStr)) {
                        // empty if block
                    }
                    ResultVO jsonStringToJavaBean = null;
                    if (type != 11) continue;
                    jsonStringToJavaBean = (ResultVO)JSON.parseObject((String)jsonStr, ResultVO.class);
                    list.add(jsonStringToJavaBean);
                }
                busiQryMsgRspBO.setResult(list);
            }
            return busiQryMsgRspBO;
        }
        catch (Exception var10) {
            log.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

