/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.FscComOrderInvoiceListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderInvoiceListBO;
import com.tydic.fsc.common.ability.bo.FscComOrderInvoiceListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderInvoiceListQueryAbilityRspBO;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderInvoiceListQueryAbilityService"})
public class FscComOrderInvoiceListQueryAbilityServiceImpl
implements FscComOrderInvoiceListQueryAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @BigDecimalConvert
    @PostMapping(value={"qryOrderInvoiceList"})
    public FscComOrderInvoiceListQueryAbilityRspBO qryOrderInvoiceList(@RequestBody FscComOrderInvoiceListQueryAbilityReqBO reqBO) {
        FscOrderPO fscOrderPo = (FscOrderPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderPO.class);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            if (ObjectUtil.isNotEmpty((Object)reqBO.getBillTimeBegin())) {
                fscOrderPo.setBillTime(simpleDateFormat.parse(reqBO.getBillTimeBegin()));
            }
            if (ObjectUtil.isNotEmpty((Object)reqBO.getBillTimeEnd())) {
                fscOrderPo.setBillTimeEnd(simpleDateFormat.parse(reqBO.getBillTimeEnd()));
            }
        }
        catch (ParseException e) {
            throw new FscBusinessException("\u5931\u8d25", e.getMessage());
        }
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        List fscOrderPOS = this.fscOrderMapper.getFscOrderJoinInvoiceListPage(fscOrderPo, page);
        if (CollectionUtils.isEmpty((Collection)fscOrderPOS)) {
            return new FscComOrderInvoiceListQueryAbilityRspBO();
        }
        List fscComOrderListBOS = JSON.parseArray((String)JSON.toJSONString((Object)fscOrderPOS), FscComOrderInvoiceListBO.class);
        FscComOrderInvoiceListQueryAbilityRspBO rspBO = new FscComOrderInvoiceListQueryAbilityRspBO();
        rspBO.setRows(fscComOrderListBOS);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalCount()));
        return rspBO;
    }
}

