/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.busi.api.FscOrderStatusFlowBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderStatusFlowBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscOrderStatusFlowBusiRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscAutoWriteOffBusiService;
import com.tydic.fsc.common.busi.bo.FscAutoWriteOffBusiServiceReqBO;
import com.tydic.fsc.common.busi.bo.FscAutoWriteOffBusiServiceRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import com.tydic.fsc.util.DateUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FscAutoWriteOffBusiServiceImpl
implements FscAutoWriteOffBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAutoWriteOffBusiServiceImpl.class);
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscWriteOffItemMapper fscWriteOffItemMapper;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscOrderStatusFlowBusiService fscOrderStatusFlowBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @Override
    public FscAutoWriteOffBusiServiceRspBO autoWriteOffOrder(FscAutoWriteOffBusiServiceReqBO reqBO) {
        List<FscOrderPO> fscOrderPOList = reqBO.getFscOrderPOList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<FscWriteOffItemPO> fscWriteOffItemPOList = new ArrayList<FscWriteOffItemPO>();
        ArrayList<FscBalancePO> fscBalancePOList = new ArrayList<FscBalancePO>();
        ArrayList<Long> dealStatusOrderIds = new ArrayList<Long>();
        Calendar now = Calendar.getInstance();
        now.add(5, Math.negateExact(reqBO.getOverdueDay()));
        List fscOrderIds = fscOrderPOList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList());
        FscWriteOffItemPO record = new FscWriteOffItemPO();
        record.setFscOrderIds(fscOrderIds);
        List writeOffItemPOS = this.fscWriteOffItemMapper.getListByFscOrderId(record);
        ArrayList writeOffFscOrderIds = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)writeOffItemPOS)) {
            writeOffFscOrderIds.addAll(writeOffItemPOS.stream().map(FscWriteOffItemPO::getFscOrderId).collect(Collectors.toList()));
        }
        for (FscOrderPO fscOrderPO : fscOrderPOList) {
            Date syncDate = fscOrderPO.getSyncTime();
            Date configDate = DateUtil.strToDate((String)sdf.format(now.getTime()), (String)"yyyy-MM-dd");
            Date payOrderDate = DateUtil.strToDate((String)sdf.format(syncDate.getTime()), (String)"yyyy-MM-dd");
            log.info("\u6838\u9500\u65f6\u95f4\uff1a{}----{}", (Object)configDate, (Object)payOrderDate);
            if (payOrderDate.after(configDate)) {
                log.info("\u4ed8\u6b3e\u5355:{}\u72b6\u6001\u672a\u4fee\u6539\u65f6\u95f4\u4e0e\u914d\u7f6e\u4e0d\u4e00\u81f4", (Object)fscOrderPO.getFscOrderId());
                continue;
            }
            if (writeOffFscOrderIds.contains(fscOrderPO.getFscOrderId())) {
                log.info("\u4ed8\u6b3e\u5355:{}\u5df2\u6838\u9500,\u8bf7\u52ff\u91cd\u590d\u6838\u9500", (Object)fscOrderPO.getFscOrderId());
                continue;
            }
            Long payerId = fscOrderPO.getPayerId();
            Long payeeId = fscOrderPO.getPayeeId();
            String payeeAccountNo = fscOrderPO.getPayeeBankAccount();
            BigDecimal payAmount = fscOrderPO.getTotalCharge();
            FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
            fscBankCheckFileItemPO.setPayerId(payerId);
            fscBankCheckFileItemPO.setPayeeId(payeeId);
            fscBankCheckFileItemPO.setPayeeAccountNo(payeeAccountNo);
            fscBankCheckFileItemPO.setTradeAmt(payAmount);
            fscBankCheckFileItemPO.setTradeDate(sdf.format(syncDate));
            fscBankCheckFileItemPO.setWriteOffFlag("0");
            List fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.autoWriteOffPayOrder(fscBankCheckFileItemPO);
            if (ObjectUtils.isEmpty((Object)fscBankCheckFileItemPOList)) {
                log.info("\u672a\u67e5\u8be2\u5230\u94f6\u884c\u6d41\u6c34\u6587\u4ef6");
                continue;
            }
            FscBankCheckFileItemPO unWriteOffBankFileItem = (FscBankCheckFileItemPO)fscBankCheckFileItemPOList.get(0);
            FscOrderPO updatePayOrder = new FscOrderPO();
            updatePayOrder.setFscOrderId(fscOrderPO.getFscOrderId());
            if (null != reqBO.getUserId()) {
                fscOrderPO.setPayOperId(reqBO.getUserId().toString());
            }
            updatePayOrder.setPayOperName("\u7cfb\u7edf\u81ea\u52a8\u6838\u9500");
            updatePayOrder.setPayTime(new Date());
            updatePayOrder.setPayState(FscConstants.PayOrderPayStatus.PAIED);
            updatePayOrder.setActualAmount(fscOrderPO.getTotalCharge());
            int row = this.fscOrderMapper.updateById(fscOrderPO);
            if (row < 1) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            unWriteOffBankFileItem.setWriteOffFlag("1");
            unWriteOffBankFileItem.setStatus(FscConstants.BANK_CHECK_STATUS.YES);
            int rows = this.fscBankCheckFileItemMapper.updateByBankCheckId(unWriteOffBankFileItem);
            if (rows < 1) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u6838\u9500\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
            fscWriteOffItemPO.setMemo("\u62a5\u8d26\u7cfb\u7edf\u4ed8\u6b3e\u6210\u529f");
            fscWriteOffItemPO.setFscOrderId(fscOrderPO.getFscOrderId());
            fscWriteOffItemPO.setBankCheckId(unWriteOffBankFileItem.getBankCheckId());
            fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
            fscWriteOffItemPOList.add(fscWriteOffItemPO);
            FscBalancePO fscBalancePO = new FscBalancePO();
            fscBalancePO.setBalanceId(Long.valueOf(Sequence.getInstance().nextId()));
            fscBalancePO.setBankCheckId(unWriteOffBankFileItem.getBankCheckId());
            fscBalancePO.setOrgId(fscOrderPOList.get(0).getPayeeId());
            fscBalancePO.setOrgCode("");
            fscBalancePO.setOrgName(fscOrderPOList.get(0).getPayeeName());
            fscBalancePO.setSubAccountNo(fscOrderPOList.get(0).getPayeeBankAccount());
            fscBalancePO.setPayerOrgId(fscOrderPOList.get(0).getPayerId());
            fscBalancePO.setPayerOrgName(fscOrderPOList.get(0).getPayerName());
            fscBalancePO.setPayerOrgCode(null);
            fscBalancePO.setPayerSubAccountNo(null);
            fscBalancePO.setFrozenEndTime(this.getConfiguration(fscOrderPOList.get(0).getPayeeId().toString()));
            fscBalancePO.setPayAmount(unWriteOffBankFileItem.getTradeAmt());
            if (fscBalancePO.getFrozenEndTime().compareTo(new Date()) <= 0) {
                fscBalancePO.setFrozenAmount(new BigDecimal(0));
                fscBalancePO.setUsableAmount(unWriteOffBankFileItem.getTradeAmt());
                fscBalancePO.setThawOperTime(new Date());
            } else {
                fscBalancePO.setFrozenAmount(unWriteOffBankFileItem.getTradeAmt());
                fscBalancePO.setUsableAmount(new BigDecimal(0));
            }
            fscBalancePO.setUsedAmount(new BigDecimal(0));
            fscBalancePO.setCreateTime(new Date());
            fscBalancePOList.add(fscBalancePO);
            dealStatusOrderIds.add(fscOrderPO.getFscOrderId());
        }
        if (!CollectionUtils.isEmpty(fscWriteOffItemPOList)) {
            this.fscWriteOffItemMapper.insertBatch(fscWriteOffItemPOList);
        }
        if (!CollectionUtils.isEmpty(fscBalancePOList)) {
            this.fscBalanceMapper.insertBatch(fscBalancePOList);
        }
        if (!CollectionUtils.isEmpty(dealStatusOrderIds)) {
            FscOrderStatusFlowBusiReqBO fscOrderStatusFlowBusiReqBO = new FscOrderStatusFlowBusiReqBO();
            fscOrderStatusFlowBusiReqBO.setOrderIds(dealStatusOrderIds);
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("confirmFlag", 0);
            fscOrderStatusFlowBusiReqBO.setParamMap(paramMap);
            fscOrderStatusFlowBusiReqBO.setCurStatus(FscConstants.FscPayOrderState.TO_PAY);
            FscOrderStatusFlowBusiRspBO busiflowRspBO = this.fscOrderStatusFlowBusiService.dealStatusFlow(fscOrderStatusFlowBusiReqBO);
            if (!"0000".equals(busiflowRspBO.getRespCode())) {
                throw new FscBusinessException(busiflowRspBO.getRespCode(), busiflowRspBO.getRespDesc());
            }
            for (Long id : dealStatusOrderIds) {
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(id);
                this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            }
        }
        return new FscAutoWriteOffBusiServiceRspBO();
    }

    private Date getConfiguration(String relId) {
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(new Date());
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("cash_withdrawal");
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(relId);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        Integer advanceUnfreezeDays = 0;
        Integer paymentDays = 0;
        Integer advanceWarningDays = 0;
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays())) {
            advanceUnfreezeDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays())) {
            paymentDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays())) {
            advanceWarningDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays());
        }
        curDate.add(5, paymentDays - advanceUnfreezeDays);
        return curDate.getTime();
    }
}

