/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.FscBatchSyncOrderAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscBatchSyncOrderAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscBatchSyncOrderAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscOrderPO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscBatchSyncOrderAbilityService"})
public class FscBatchSyncOrderAbilityServiceImpl
implements FscBatchSyncOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBatchSyncOrderAbilityServiceImpl.class);
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @PostMapping(value={"batchSyncOrder"})
    public FscBatchSyncOrderAbilityRspBO batchSyncOrder(@RequestBody FscBatchSyncOrderAbilityReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getFscOrderIds())) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            if (reqBO.getAllDate().equals(0)) {
                switch (reqBO.getType()) {
                    case 10: {
                        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE_APPROVAL);
                        break;
                    }
                    case 0: {
                        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
                        break;
                    }
                    case 1: {
                        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
                        break;
                    }
                    case 2: {
                        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.MONTH_SERVICE_FEE);
                        break;
                    }
                }
            }
            int pageSize = 1000;
            int pageNo = 1;
            while (pageSize >= 1000) {
                Page page = new Page();
                page.setPageSize(1000);
                page.setPageNo(pageNo);
                List fscOrderPOList = this.fscOrderMapper.getListPage(fscOrderPO, page);
                log.info("\u9875\u7801\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)page));
                pageSize = ObjectUtil.isEmpty((Object)fscOrderPOList) ? 0 : fscOrderPOList.size();
                ++pageNo;
                for (FscOrderPO fscOrder : fscOrderPOList) {
                    this.syncOrder(fscOrder.getFscOrderId());
                }
            }
        } else {
            for (Long fscOrderId : reqBO.getFscOrderIds()) {
                this.syncOrder(fscOrderId);
            }
        }
        return null;
    }

    private void syncOrder(Long fscOrderId) {
        try {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

