/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.bo.FscServiceFeePdfQryListBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocFeeServiceInspectionDetailsListPageQueryReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocFeeServicePdfInspectionDetailsListPageQueryRspBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocFeeServicePdfInspectionDetailsListPageQueryService;
import com.tydic.fsc.common.ability.api.FscCancelOrderAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscCancelOrderAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCancelOrderAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscCancelOrderBusiService;
import com.tydic.fsc.common.busi.bo.FscCancelOrderBO;
import com.tydic.fsc.common.busi.bo.FscCancelOrderBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscCancelOrderBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderCancelMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.po.FscOrderCancelPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscCancelOrderAbilityService"})
public class FscCancelOrderAbilityServiceImpl
implements FscCancelOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscCancelOrderAbilityServiceImpl.class);
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscCancelOrderBusiService fscCancelOrderBusiService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderCancelMapper fscOrderCancelMapper;
    @Autowired
    private FscUocFeeServicePdfInspectionDetailsListPageQueryService fscUocFeeServicePdfInspectionDetailsListPageQueryService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @PostMapping(value={"cancelOrder"})
    public FscCancelOrderAbilityRspBO cancelOrder(@RequestBody FscCancelOrderAbilityReqBO reqBO) {
        FscCancelOrderAbilityRspBO rspBO = new FscCancelOrderAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setOrderId(reqBO.getOrderId());
        List fscOrderRelationPOS = this.fscOrderRelationMapper.getList(fscOrderRelationPO);
        if (ObjectUtil.isEmpty((Object)fscOrderRelationPOS)) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u6240\u5173\u8054\u7684\u7ed3\u7b97\u5355");
            return rspBO;
        }
        List fscOrderIds = fscOrderRelationPOS.stream().filter(bo -> bo.getOrderTotalCharge().compareTo(BigDecimal.ZERO) > 0).map(FscOrderRelationPO::getFscOrderId).collect(Collectors.toList());
        if (ObjectUtil.isEmpty(fscOrderIds)) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u8ba2\u5355\u6240\u5173\u8054\u7684\u91d1\u989d\u4e3a\u96f6");
            return rspBO;
        }
        Map<Long, List<FscOrderRelationPO>> fscOrderRelationPOListMap = fscOrderRelationPOS.stream().filter(bo -> bo.getOrderTotalCharge().compareTo(BigDecimal.ZERO) > 0).collect(Collectors.groupingBy(FscOrderRelationPO::getFscOrderId));
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(fscOrderIds);
        List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
        FscCancelOrderBusiReqBO fscCancelOrderBusiReqBO = new FscCancelOrderBusiReqBO();
        ArrayList<FscCancelOrderBO> fscCancelOrderBOList = new ArrayList<FscCancelOrderBO>();
        for (FscOrderPO orderInfo : fscOrderPOList) {
            if (FscConstants.FscPayOrderState.CANCEL.equals(orderInfo.getOrderState())) continue;
            FscCancelOrderBO fscCancelOrderBO = new FscCancelOrderBO();
            fscCancelOrderBO.setFscOrderId(orderInfo.getFscOrderId());
            fscCancelOrderBO.setOrderId(reqBO.getOrderId());
            fscCancelOrderBO.setOrderFlow(orderInfo.getOrderFlow());
            if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(orderInfo.getOrderFlow()) || !FscConstants.OrderFlow.INVOICE.equals(orderInfo.getOrderFlow())) continue;
            List<Long> inspIdList = fscOrderRelationPOListMap.get(orderInfo.getFscOrderId()).stream().map(FscOrderRelationPO::getAcceptOrderId).collect(Collectors.toList());
            BigDecimal deductionAmount = BigDecimal.ZERO;
            if (reqBO.getCancelType() == 0) {
                deductionAmount = this.getInvoiceDeductionAmount(inspIdList, orderInfo.getFscOrderId());
            } else if (reqBO.getCancelType() == 1) {
                deductionAmount = orderInfo.getMakeType().equals(FscConstants.FscOrderMakeType.OPERTION) && orderInfo.getReceiveType().equals(FscConstants.FscOrderReceiveType.PURCHASE) && (orderInfo.getOrderSource().equals(Integer.parseInt("2")) || orderInfo.getOrderSource().equals(Integer.parseInt("3"))) ? reqBO.getSaleDeductionAmount() : reqBO.getPurDeductionAmount();
            }
            fscCancelOrderBO.setDeductionAmount(deductionAmount);
            if (orderInfo.getTotalCharge().compareTo(deductionAmount) > 0) {
                fscCancelOrderBO.setCancelOrderType(0);
            } else {
                fscCancelOrderBO.setCancelOrderType(1);
            }
            fscCancelOrderBOList.add(fscCancelOrderBO);
            orderInfo.setOrderNo(null);
            FscOrderPO payOrderInfo = this.fscOrderMapper.getPayOrderByFscOrderId(orderInfo);
            if (ObjectUtil.isEmpty((Object)payOrderInfo)) continue;
            FscCancelOrderBO fscCancelPayOrderBO = new FscCancelOrderBO();
            fscCancelPayOrderBO.setFscOrderId(payOrderInfo.getFscOrderId());
            fscCancelPayOrderBO.setOrderFlow(payOrderInfo.getOrderFlow());
            fscCancelPayOrderBO.setDeductionAmount(deductionAmount);
            fscCancelPayOrderBO.setOrderId(reqBO.getOrderId());
            if (payOrderInfo.getTotalCharge().compareTo(deductionAmount) > 0) {
                fscCancelPayOrderBO.setCancelOrderType(0);
            } else {
                fscCancelPayOrderBO.setCancelOrderType(1);
            }
            fscCancelOrderBOList.add(fscCancelPayOrderBO);
        }
        if (ObjectUtil.isNotEmpty(fscCancelOrderBOList)) {
            ArrayList list = new ArrayList();
            fscCancelOrderBOList.forEach(bo -> {
                FscOrderCancelPO fscOrderCancelPO = new FscOrderCancelPO();
                fscOrderCancelPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscOrderCancelPO.setOrderId(bo.getOrderId());
                fscOrderCancelPO.setFscOrderId(bo.getFscOrderId());
                fscOrderCancelPO.setOrderTotalCharge(bo.getDeductionAmount());
                fscOrderCancelPO.setCreateTime(new Date());
                fscOrderCancelPO.setOperId(null == reqBO.getUserId() ? null : reqBO.getUserId().toString());
                fscOrderCancelPO.setOperName(reqBO.getName());
                list.add(fscOrderCancelPO);
            });
            this.fscOrderCancelMapper.insertBatch(list);
            fscCancelOrderBusiReqBO.setFscCancelOrderBOList(fscCancelOrderBOList);
            FscCancelOrderBusiRspBO fscCancelOrderBusiRspBO = this.fscCancelOrderBusiService.cancelOrder(fscCancelOrderBusiReqBO);
            if (!"0000".equals(fscCancelOrderBusiRspBO.getRespCode())) {
                throw new ZTBusinessException(fscCancelOrderBusiRspBO.getRespDesc());
            }
            for (FscCancelOrderBO fscCancelOrderBO : fscCancelOrderBusiReqBO.getFscCancelOrderBOList()) {
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(fscCancelOrderBO.getFscOrderId());
                this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
            }
        }
        return rspBO;
    }

    private BigDecimal getServiceFeeDeductionAmount(List<Long> inspIdList) {
        FscUocFeeServiceInspectionDetailsListPageQueryReqBO fscUocInspectionDetailsListPageQueryReqBO = new FscUocFeeServiceInspectionDetailsListPageQueryReqBO();
        fscUocInspectionDetailsListPageQueryReqBO.setInspOrderIdList(inspIdList);
        fscUocInspectionDetailsListPageQueryReqBO.setPageNo(Integer.valueOf(-1));
        fscUocInspectionDetailsListPageQueryReqBO.setPageSize(Integer.valueOf(500));
        fscUocInspectionDetailsListPageQueryReqBO.setPayServiceCode("953317067065413636");
        FscUocFeeServicePdfInspectionDetailsListPageQueryRspBO fscUocInspectionDetailsListPageQueryRspBO = this.fscUocFeeServicePdfInspectionDetailsListPageQueryService.getPdfInspectionDetailsList(fscUocInspectionDetailsListPageQueryReqBO);
        List fscUocInspectionDetailsListBOList = fscUocInspectionDetailsListPageQueryRspBO.getRows();
        BigDecimal serviceFeeDeductionAmount = fscUocInspectionDetailsListBOList.stream().map(FscServiceFeePdfQryListBO::getSerPriceMoney).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("\u670d\u52a1\u8d39\u6263\u51cf\u91d1\u989d:{}", (Object)serviceFeeDeductionAmount);
        return serviceFeeDeductionAmount;
    }

    private BigDecimal getInvoiceDeductionAmount(List<Long> inspIdList, Long fscOrderId) {
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setAcceptOrderIds(inspIdList);
        fscOrderItemPO.setFscOrderId(fscOrderId);
        List fscOrderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        BigDecimal serviceFeeDeductionAmount = fscOrderItemPOList.stream().map(FscOrderItemPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("\u7ed3\u7b97\u5355\u6263\u51cf\u91d1\u989d:{}", (Object)serviceFeeDeductionAmount);
        return serviceFeeDeductionAmount;
    }
}

