/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderRelUpdateReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderRelUpdateRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityReqBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocOrderRelUpdateAbilityService;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscPayBillWriteOffAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayBillWriteOffAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPayBillWriteOffAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscPayBillWriteOffBusiService;
import com.tydic.fsc.common.busi.bo.FscPayBillWriteOffBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPayBillWriteOffBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.FscRspUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscPayBillWriteOffAbilityService"})
public class FscPayBillWriteOffAbilityServiceImpl
implements FscPayBillWriteOffAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillWriteOffAbilityServiceImpl.class);
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscPayBillWriteOffBusiService fscPayBillWriteOffBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscUocOrderRelUpdateAbilityService fscUocOrderRelUpdateAbilityService;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;

    @PostMapping(value={"payBillWriteOff"})
    public FscPayBillWriteOffAbilityRspBO payBillWriteOff(@RequestBody FscPayBillWriteOffAbilityReqBO reqBO) {
        String validateStr = this.validateArgs(reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u68c0\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            FscPayBillWriteOffAbilityRspBO retBo = (FscPayBillWriteOffAbilityRspBO)FscRspUtil.getRspBo((String)"191000", (String)("\u5165\u53c2\u68c0\u9a8c\u5931\u8d25" + validateStr), FscPayBillWriteOffAbilityRspBO.class);
            return retBo;
        }
        FscPayBillWriteOffBusiReqBO busiReqBO = (FscPayBillWriteOffBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscPayBillWriteOffBusiReqBO.class));
        FscPayBillWriteOffBusiRspBO busiRspBO = this.fscPayBillWriteOffBusiService.payBillWriteOff(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        if (null != reqBO.getFscOrderId()) {
            for (Long fscOrderId : reqBO.getFscOrderId()) {
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
                this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
                this.syncOrderStatus1(fscOrderId);
            }
        }
        return (FscPayBillWriteOffAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiRspBO)), FscPayBillWriteOffAbilityRspBO.class);
    }

    private String validateArgs(FscPayBillWriteOffAbilityReqBO reqBo) {
        if (null == reqBo) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getFscOrderId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u64cd\u4f5c\u7c7b\u578b[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getBankCheckIds())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\uff1a\u64cd\u4f5c\u7c7b\u578b[bankCheckIds]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }

    private void syncOrderStatus(Long fscPayOrderId) {
        List fscShouldPayPOList = this.fscShouldPayMapper.getByFscOrderId(fscPayOrderId);
        for (FscShouldPayPO fscShouldPayPO : fscShouldPayPOList) {
            FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
            fscOrderRelationPo.setFscOrderId(fscShouldPayPO.getObjectId());
            List fscOrderRelationPOs = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
            for (FscOrderRelationPO fscOrderRelationPO : fscOrderRelationPOs) {
                FscUocOrderRelUpdateReqBO fscUocOrderRelUpdateReqBO = new FscUocOrderRelUpdateReqBO();
                fscUocOrderRelUpdateReqBO.setOrderId(fscOrderRelationPO.getOrderId());
                fscUocOrderRelUpdateReqBO.setRelId(fscShouldPayPO.getObjectId());
                fscUocOrderRelUpdateReqBO.setRelState(FscConstants.FscRelStatus.COMMITTED);
                fscUocOrderRelUpdateReqBO.setPayState(FscConstants.PAY_STATE.PAYED.toString());
                fscUocOrderRelUpdateReqBO.setRelType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
                fscUocOrderRelUpdateReqBO.setObjId(fscOrderRelationPO.getAcceptOrderId());
                fscUocOrderRelUpdateReqBO.setObjType(FscConstants.ORDER_OBJ_TYPE.SALE);
                fscUocOrderRelUpdateReqBO.setPayTime(new Date());
                FscUocOrderRelUpdateRspBO fscUocOrderRelUpdateRspBO = this.fscUocOrderRelUpdateAbilityService.dealRelUpdate(fscUocOrderRelUpdateReqBO);
                if ("0000".equals(fscUocOrderRelUpdateRspBO.getRespCode())) continue;
                throw new FscBusinessException("193207", StrUtil.format((CharSequence)"\u540c\u6b65\u66f4\u65b0\u8ba2\u5355\u51fa\u9519\uff1a{}", (Object[])new Object[]{fscUocOrderRelUpdateRspBO.getRespDesc()}));
            }
        }
    }

    private void syncOrderStatus1(Long fscPayOrderId) {
        List fscShouldPayPOList = this.fscShouldPayMapper.getByFscOrderId(fscPayOrderId);
        Map<Long, FscShouldPayPO> fscShouldPayPOMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getObjectId, FscShouldPayPO2 -> FscShouldPayPO2));
        if (CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            return;
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderIds(fscShouldPayPOList.stream().map(FscShouldPayPO::getObjectId).collect(Collectors.toList()));
        List orderList = this.fscOrderMapper.getList(fscOrderPo);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return;
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderIds(orderList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList()));
        List fscOrderRelationPOs = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (!CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            FscUocProOrderPaymentCallbackAbilityReqBO fscUocProOrderPaymentCallbackAbilityReqBO = new FscUocProOrderPaymentCallbackAbilityReqBO();
            fscUocProOrderPaymentCallbackAbilityReqBO.setUocPaymentCallbackBOS(fscOrderRelationPOs.stream().map(fscPaySuccessCallBackOrderBO -> {
                FscUocProOrderPaymentCallbackAbilityBO fscUocProOrderPaymentCallbackAbilityBO = new FscUocProOrderPaymentCallbackAbilityBO();
                fscUocProOrderPaymentCallbackAbilityBO.setSaleOrderId(fscPaySuccessCallBackOrderBO.getOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setObjectId(fscPaySuccessCallBackOrderBO.getAcceptOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setPayerType(FscConstants.FscOrderReceiveType.PURCHASE.equals(((FscOrderPO)orderList.get(0)).getReceiveType()) ? "pur" : "pro");
                fscUocProOrderPaymentCallbackAbilityBO.setPayMod(Integer.valueOf(30));
                fscUocProOrderPaymentCallbackAbilityBO.setPayResult(Boolean.valueOf(true));
                fscUocProOrderPaymentCallbackAbilityBO.setShouldPayMoney(fscPaySuccessCallBackOrderBO.getOrderTotalCharge());
                fscUocProOrderPaymentCallbackAbilityBO.setFscShouldPayId(((FscShouldPayPO)fscShouldPayPOMap.get(fscPaySuccessCallBackOrderBO.getFscOrderId())).getShouldPayId());
                return fscUocProOrderPaymentCallbackAbilityBO;
            }).collect(Collectors.toList()));
            this.fscUocProOrderPaymentCallbackAbilityService.dealOrderPaymentCallback(fscUocProOrderPaymentCallbackAbilityReqBO);
        }
    }
}

