/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.busi.api.FscOrderAutoWriteOffBusiService;
import com.tydic.fsc.common.busi.bo.FscOrderAutoWriteOffBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscOrderAutoWriteOffBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscLegalCompanyPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscOrderAutoWriteOffBusiServiceImpl
implements FscOrderAutoWriteOffBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderAutoWriteOffBusiServiceImpl.class);
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscWriteOffItemMapper fscWriteOffItemMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;

    @Override
    public FscOrderAutoWriteOffBusiRspBO autoWriteOffFscOrderEdit(FscOrderAutoWriteOffBusiReqBO reqBO) {
        FscLegalCompanyPO fscLegalCompanyPO;
        FscOrderAutoWriteOffBusiRspBO rspBO = new FscOrderAutoWriteOffBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderPO fscOrderPOQry = new FscOrderPO();
        fscOrderPOQry.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPOQry.setOrderState(FscConstants.FscPayOrderState.TO_PAY);
        fscOrderPOQry.setOrderFlow(FscConstants.OrderFlow.PAY);
        fscOrderPOQry.setLastPayDateEnd(new Date());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPOQry);
        if (null == fscOrder) {
            return rspBO;
        }
        FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
        fscBankCheckFileItemPO.setBankCheckId(Long.valueOf(Sequence.getInstance().nextId()));
        fscBankCheckFileItemPO.setPayeeOraCode(fscOrder.getPayeeId().toString());
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setOrgIdS(Arrays.asList(fscOrder.getPayerId(), fscOrder.getPayeeId()));
        List fscAccountPOList = this.fscAccountMapper.getList(fscAccountPO);
        if (!ObjectUtil.isEmpty((Object)fscAccountPOList)) {
            Map<Long, List<FscAccountPO>> fscAccountMapList = fscAccountPOList.stream().collect(Collectors.groupingBy(FscAccountPO::getOrgId));
            fscBankCheckFileItemPO.setPayerAccountName(ObjectUtil.isEmpty(fscAccountMapList.get(fscOrder.getPayerId())) ? "" : fscAccountMapList.get(fscOrder.getPayerId()).get(0).getAccountName());
            fscBankCheckFileItemPO.setPayerBankAccount(ObjectUtil.isEmpty(fscAccountMapList.get(fscOrder.getPayerId())) ? "" : fscAccountMapList.get(fscOrder.getPayerId()).get(0).getAccountNo());
            fscBankCheckFileItemPO.setPayerBankName(ObjectUtil.isEmpty(fscAccountMapList.get(fscOrder.getPayerId())) ? "" : fscAccountMapList.get(fscOrder.getPayerId()).get(0).getDepositBankName());
            fscBankCheckFileItemPO.setPayeeAccountNo(fscOrder.getPayeeBankAccount());
            fscBankCheckFileItemPO.setPayeeAccountName(fscOrder.getPayeeBankName());
        }
        fscBankCheckFileItemPO.setPayeeSubAccountNo(ObjectUtil.isEmpty((Object)(fscLegalCompanyPO = this.fscLegalCompanyMapper.getByOrgId(fscOrder.getPayeeId()))) ? "" : fscLegalCompanyPO.getSubAccountNo());
        fscBankCheckFileItemPO.setTradeAmt(BigDecimal.ZERO);
        fscBankCheckFileItemPO.setPayerId(fscOrder.getPayerId());
        fscBankCheckFileItemPO.setPayerName(fscOrder.getPayerName());
        fscBankCheckFileItemPO.setPayeeId(fscOrder.getPayeeId());
        fscBankCheckFileItemPO.setPayeeName(fscOrder.getPayeeName());
        fscBankCheckFileItemPO.setWriteOffFlag("1");
        fscBankCheckFileItemPO.setStatus(Integer.valueOf(1));
        fscBankCheckFileItemPO.setShouldPayNo(fscOrder.getOrderNo());
        fscBankCheckFileItemPO.setMemo(fscOrder.getOrderNo());
        int result = this.fscBankCheckFileItemMapper.insert(fscBankCheckFileItemPO);
        if (result < 1) {
            throw new FscBusinessException("198888", "\u65b0\u589e\u94f6\u884c\u6d41\u6c34\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
        fscWriteOffItemPO.setMemo("\u81ea\u52a8\u6838\u9500[\u6536\u6b3e\u8d26\u6237\u4e3a\u975e\u76d1\u7ba1\u8d26\u6237]");
        fscWriteOffItemPO.setFscOrderId(fscOrder.getFscOrderId());
        fscWriteOffItemPO.setBankCheckId(fscBankCheckFileItemPO.getBankCheckId());
        fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
        fscWriteOffItemPO.setCreateTime(new Date());
        fscWriteOffItemPO.setCreateOperId(Long.valueOf(1L));
        fscWriteOffItemPO.setCreateOperUser("admin");
        this.fscWriteOffItemMapper.insert(fscWriteOffItemPO);
        FscOrderPO fscOrderPOUpdate = new FscOrderPO();
        fscOrderPOUpdate.setFscOrderId(fscOrder.getFscOrderId());
        fscOrderPOUpdate.setOrderState(FscConstants.FscPayOrderState.PAIED);
        fscOrderPOUpdate.setPayState(FscConstants.PayOrderPayStatus.PAIED);
        this.fscOrderMapper.updateById(fscOrderPOUpdate);
        return rspBO;
    }
}

