/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.consumer.bo.FscInvoiceSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService"})
public class FscComInvoiceSyncAbilityServiceImpl
implements FscComInvoiceSyncAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComInvoiceSyncAbilityServiceImpl.class);
    @Resource(name="fscSyncInvoiceListMqServiceProvider")
    private ProxyMessageProducer fscSyncInvoiceListMqServiceProvider;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${es.FSC_INVOICE_SYNC_TOPIC}")
    private String topic;
    @Value(value="${es.FSC_INVOICE_SYNC_TAG}")
    private String tag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    @PostMapping(value={"dealComOrderSyncEs"})
    public void dealComOrderSyncEs(@RequestBody FscComInvoiceListSyncAbilityReqBO reqBO) {
        if (ObjectUtil.isNotEmpty((Object)reqBO.getFscOrderIds())) {
            for (Long fscOrderId : reqBO.getFscOrderIds()) {
                FscInvoiceSyncReqBO fscInvoiceSyncReqBO = new FscInvoiceSyncReqBO();
                fscInvoiceSyncReqBO.setFscOrderId(fscOrderId);
                ProxyMessage message = new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscInvoiceSyncReqBO));
                log.info("\u7ed3\u7b97\u5355id\uff1a{},\u540c\u6b65\u53d1\u7968\u6d88\u606f\u53d1\u9001\u65f6\u95f4\uff1a{}", (Object)fscOrderId, (Object)DateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
                ProxySendResult proxySendResult = this.fscSyncInvoiceListMqServiceProvider.send(message);
                if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
                this.writeFailLog(reqBO);
            }
        }
        if (null != reqBO.getFscOrderId()) {
            FscInvoiceSyncReqBO fscInvoiceSyncReqBO = new FscInvoiceSyncReqBO();
            fscInvoiceSyncReqBO.setFscOrderId(reqBO.getFscOrderId());
            ProxyMessage message = new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscInvoiceSyncReqBO));
            log.info("\u7ed3\u7b97\u5355id\uff1a{},\u540c\u6b65\u53d1\u7968\u6d88\u606f\u53d1\u9001\u65f6\u95f4\uff1a{}", (Object)reqBO.getFscOrderId(), (Object)DateUtil.dateToStr((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            ProxySendResult proxySendResult = this.fscSyncInvoiceListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscInvoiceSyncReqBO)));
            if (!"SEND_OK".equals(proxySendResult.getStatus())) {
                this.writeFailLog(reqBO);
            }
        }
    }

    @PostMapping(value={"syncAllComInvoiceList"})
    public void syncAllComInvoiceList() {
        FscOrderPO fscOrderPO = new FscOrderPO();
        List fscOrderList = this.fscOrderMapper.getList(fscOrderPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderList)) {
            for (FscOrderPO orderPO : fscOrderList) {
                FscInvoiceSyncReqBO fscInvoiceSyncReqBO = new FscInvoiceSyncReqBO();
                fscInvoiceSyncReqBO.setFscOrderId(orderPO.getFscOrderId());
                ProxySendResult proxySendResult = this.fscSyncInvoiceListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscInvoiceSyncReqBO)));
                if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
                FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
                fscComInvoiceListSyncAbilityReqBO.setFscOrderId(orderPO.getFscOrderId());
                this.writeFailLog(fscComInvoiceListSyncAbilityReqBO);
            }
        }
    }

    private void writeFailLog(FscComInvoiceListSyncAbilityReqBO reqBO) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(reqBO.getFscOrderId());
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ES);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

