/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.common.ability.api.FscComOrderItemListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderItemListBO;
import com.tydic.fsc.common.ability.bo.FscComOrderItemListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderItemListQueryAbilityRspBO;
import com.tydic.fsc.dao.FscGoodsDeductionRecordRelMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscGoodsDeductionRecordRelPO;
import com.tydic.fsc.po.FscOrderItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderItemListQueryAbilityService"})
public class FscComOrderItemListQueryAbilityServiceImpl
implements FscComOrderItemListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderItemListQueryAbilityServiceImpl.class);
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscGoodsDeductionRecordRelMapper fscGoodsDeductionRecordRelMapper;

    @PostMapping(value={"qryOrderItemList"})
    public FscComOrderItemListQueryAbilityRspBO qryOrderItemList(@RequestBody FscComOrderItemListQueryAbilityReqBO reqBO) {
        if (null == reqBO || null == reqBO.getOrderId()) {
            throw new FscBusinessException("191009", "\u5165\u53c2\u4e3a\u7a7a");
        }
        FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
        fscOrderItemPo.setFscOrderId(reqBO.getOrderId());
        fscOrderItemPo.setAcceptOrderIds(reqBO.getAcceptOrderIds());
        List orderItemPOList = this.fscOrderItemMapper.getList(fscOrderItemPo);
        List comOrderItemListBOList = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)orderItemPOList)) {
            comOrderItemListBOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)orderItemPOList), FscComOrderItemListBO.class);
        }
        FscGoodsDeductionRecordRelPO fscGoodsDeductionRecordRelPo = new FscGoodsDeductionRecordRelPO();
        fscGoodsDeductionRecordRelPo.setFscOrderId(reqBO.getOrderId());
        fscGoodsDeductionRecordRelPo.setAcceptOrderIds(reqBO.getAcceptOrderIds());
        List recordRelPOList = this.fscGoodsDeductionRecordRelMapper.getList(fscGoodsDeductionRecordRelPo);
        HashMap<String, BigDecimal> deductionNumMap = new HashMap<String, BigDecimal>();
        if (ObjectUtil.isNotEmpty((Object)recordRelPOList)) {
            Map<String, List<FscGoodsDeductionRecordRelPO>> recordRelPOListMap = recordRelPOList.stream().collect(Collectors.groupingBy(bo -> bo.getAcceptOrderId() + "-" + bo.getOrderItemId()));
            for (String keyStr : recordRelPOListMap.keySet()) {
                deductionNumMap.put(keyStr, recordRelPOListMap.get(keyStr).stream().map(FscGoodsDeductionRecordRelPO::getDeductionNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }
        comOrderItemListBOList.forEach(bo -> {
            BigDecimal deductionNum = (BigDecimal)deductionNumMap.get(bo.getAcceptOrderId() + "-" + bo.getOrderItemId());
            bo.setDeductionNum(null == deductionNum ? BigDecimal.ZERO : deductionNum);
        });
        FscComOrderItemListQueryAbilityRspBO rspBO = new FscComOrderItemListQueryAbilityRspBO();
        rspBO.setRows(comOrderItemListBOList);
        return rspBO;
    }
}

