/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankJgf002Service;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankJgf002ReqBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankJgf002RspBO;
import com.tydic.fsc.common.busi.api.FscComIntBalanceWithdrawalBusiService;
import com.tydic.fsc.common.busi.bo.FscComBalanceWithdrawalBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscComIntBalanceWithdrawalBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscWithdrawalLogItemMapper;
import com.tydic.fsc.dao.FscWithdrawalLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscLegalCompanyPO;
import com.tydic.fsc.po.FscWithdrawalLogItemPO;
import com.tydic.fsc.po.FscWithdrawalLogPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class FscComIntBalanceWithdrawalBusiServiceImpl
implements FscComIntBalanceWithdrawalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComIntBalanceWithdrawalBusiServiceImpl.class);
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscWithdrawalLogMapper fscWithdrawalLogMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscWithdrawalLogItemMapper fscWithdrawalLogItemMapper;
    @Autowired
    private FscBToBPingAnBankJgf002Service fscBToBPingAnBankJgf002Service;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FscComBalanceWithdrawalBusiRspBO balanceWithdrawal(FscComIntBalanceWithdrawalBusiReqBO reqBO) {
        FscBalancePO selectFscBalancePO = new FscBalancePO();
        selectFscBalancePO.setOrgId(reqBO.getOrgId());
        if (!ObjectUtil.isEmpty((Object)reqBO.getRecvSubLedgerAcctNo())) {
            selectFscBalancePO.setSubAccountNo(reqBO.getRecvSubLedgerAcctNo().toString());
        }
        selectFscBalancePO.setBankCheckIds(reqBO.getBankCheckIds());
        Long orgId = reqBO.getOrgId();
        log.debug("\u67e5\u8be2\u8d26\u6237\u673a\u6784id\u4e3a:{}", (Object)orgId);
        log.info("\u67e5\u8be2\u8be5\u8d26\u6237\u4f59\u989d\u5165\u53c2\u4e3a:{}", (Object)JSON.toJSONString((Object)selectFscBalancePO));
        List fscBalancePOList = this.fscBalanceMapper.getByOrgIdAnPayeeAccount(selectFscBalancePO);
        log.debug("\u67e5\u8be2\u5230\u7684\u4f59\u989d\u4fe1\u606f\u4e3a:{}", (Object)fscBalancePOList);
        if (CollectionUtils.isEmpty((Collection)fscBalancePOList)) {
            throw new FscBusinessException("198888", "\u8be5\u8d26\u6237\u76ee\u524d\u6ca1\u6709\u4f59\u989d\u4fe1\u606f\u6570\u636e");
        }
        FscAccountPO queryAccount = new FscAccountPO();
        queryAccount.setAccountNo(reqBO.getAccountNo());
        if (!ObjectUtil.isEmpty((Object)reqBO.getRecvSubLedgerAcctNo())) {
            queryAccount.setRecvSubLedgerAcctNo(reqBO.getRecvSubLedgerAcctNo().toString());
        }
        queryAccount.setOrgId(orgId);
        queryAccount.setStatus(FscConstants.AccountStatus.VALID);
        queryAccount.setAccountNoType("2");
        FscAccountPO fscAccountPO = this.fscAccountMapper.getModelBy(queryAccount);
        log.debug("\u67e5\u8be2\u7684\u8d26\u6237\u4fe1\u606f\u4e3a:{}", (Object)fscAccountPO);
        if (fscAccountPO == null) {
            throw new FscBusinessException("191103", "\u63d0\u73b0\u8d26\u6237\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        if (!FscConstants.AccountStatus.FAIL.equals(fscAccountPO.getB2bStatus())) {
            throw new FscBusinessException("198888", "\u63d0\u73b0\u8d26\u6237\u72b6\u6001\u5f02\u5e38,\u8bf7\u5f00\u901a\u6536\u6b3e\u529f\u80fd");
        }
        FscLegalCompanyPO fscLegalCompanyPO = this.fscLegalCompanyMapper.getById(orgId);
        log.debug("\u5b50\u8d26\u6237\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\u4e3a:{}", (Object)fscLegalCompanyPO);
        if (fscLegalCompanyPO == null) {
            throw new FscBusinessException("198888", "\u63d0\u73b0\u5b50\u8d26\u6237\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        Integer status = fscLegalCompanyPO.getStatus();
        if (!FscConstants.MerchantStatus.VALID.equals(status)) {
            throw new FscBusinessException("198888", "\u63d0\u73b0\u5b50\u8d26\u6237\u8d26\u53f7\u72b6\u6001\u5f02\u5e38");
        }
        BigDecimal totalUsableAmount = BigDecimal.ZERO;
        for (FscBalancePO fscBalancePO : fscBalancePOList) {
            totalUsableAmount = totalUsableAmount.add(fscBalancePO.getUsableAmount());
        }
        BigDecimal reqUseAmount = reqBO.getUseAmount();
        if (reqUseAmount.compareTo(totalUsableAmount) != 0) {
            throw new FscBusinessException("198888", "\u63d0\u73b0\u91d1\u989d\u548c\u53ef\u63d0\u73b0\u91d1\u989d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\uff01");
        }
        Date dateTime = new Date();
        log.debug("\u5f53\u524d\u65f6\u95f4\u4e3a:{}", (Object)dateTime);
        FscBalancePO set = new FscBalancePO();
        set.setOperId(reqBO.getUserId());
        set.setOperName(reqBO.getName());
        set.setWithdrawalTime(dateTime);
        this.fscBalanceMapper.updateUsedAmountByBankId(fscBalancePOList, set);
        Long cnsmrSeqNo = Sequence.getInstance().nextId();
        Long thirdVoucher = Sequence.getInstance().nextId();
        log.info("\u5f00\u59cb\u8c03\u53d6\u94f6\u884c\u63d0\u73b0\u63a5\u53e3!");
        FscBToBPingAnBankJgf002ReqBO bankWithdrawCashReqBO = new FscBToBPingAnBankJgf002ReqBO();
        bankWithdrawCashReqBO.setCnsmrSeqNo(cnsmrSeqNo.toString());
        bankWithdrawCashReqBO.setThirdVoucher(thirdVoucher.toString());
        bankWithdrawCashReqBO.setFreezeNo(fscAccountPO.getFreezeNo());
        bankWithdrawCashReqBO.setOutAcctNo(fscAccountPO.getRecvSubLedgerAcctNo());
        bankWithdrawCashReqBO.setOutAcctName(fscAccountPO.getRecvSubLedgerAcctName());
        bankWithdrawCashReqBO.setInAcctNo(fscAccountPO.getAccountNo());
        bankWithdrawCashReqBO.setInAcctName(fscAccountPO.getAccountName());
        bankWithdrawCashReqBO.setInAcctBankName(fscAccountPO.getDepositBankName());
        bankWithdrawCashReqBO.setCcyCode("RMB");
        bankWithdrawCashReqBO.setTranAmount(reqBO.getUseAmount());
        bankWithdrawCashReqBO.setUnionFlag("0");
        bankWithdrawCashReqBO.setAddrFlag("1");
        log.debug("\u8c03\u53d6\u94f6\u884c\u63d0\u73b0\u4e1a\u52a1\u5165\u53c2:{}", (Object)bankWithdrawCashReqBO);
        FscBToBPingAnBankJgf002RspBO bankBindBankAccountRspBO = this.fscBToBPingAnBankJgf002Service.withdrawCash(bankWithdrawCashReqBO);
        if (!"0000".equals(bankBindBankAccountRspBO.getRespCode())) {
            throw new FscBusinessException("198888", bankBindBankAccountRspBO.getRespDesc());
        }
        log.debug("\u8c03\u53d6\u94f6\u884c\u63d0\u73b0\u64cd\u4f5c\u7ed3\u679c\u4e3a:{}", (Object)bankBindBankAccountRspBO);
        Integer resultStatus = 1;
        if ("20".equals(bankBindBankAccountRspBO.getReturnStatu())) {
            resultStatus = 2;
        } else if ("30".equals(bankBindBankAccountRspBO.getReturnStatu())) {
            resultStatus = 3;
        }
        log.info("\u8c03\u53d6\u94f6\u884c\u63d0\u73b0\u63a5\u53e3\u7ed3\u675f!");
        FscWithdrawalLogPO fscWithdrawalLogPO = new FscWithdrawalLogPO();
        fscWithdrawalLogPO.setId(cnsmrSeqNo).setOrgId(reqBO.getOrgId()).setOrgName(reqBO.getOrgName()).setAccountId(fscAccountPO.getId()).setAccountNo(fscAccountPO.getAccountNo()).setAccountName(fscAccountPO.getAccountName()).setSubAccountNo(fscLegalCompanyPO.getSubAccountNo()).setDepositBankName(fscAccountPO.getDepositBankName()).setUsedAmount(reqBO.getUseAmount()).setThirdVoucher(thirdVoucher.toString()).setStatus(resultStatus).setHostFlowNo(bankBindBankAccountRspBO.getHostFlowNo()).setFrontSeqNo(bankBindBankAccountRspBO.getFrontLogNo()).setCreateTime(dateTime).setTransferFee(new BigDecimal("0")).setAccountNoType(fscAccountPO.getAccountNoType()).setOperId(reqBO.getUserId()).setOperName(reqBO.getName());
        log.debug("\u5373\u5c06\u6dfb\u52a0\u63d0\u73b0\u8bb0\u5f55:{}", (Object)fscWithdrawalLogPO);
        int insertRows = this.fscWithdrawalLogMapper.insert(fscWithdrawalLogPO);
        if (insertRows != 1) {
            throw new FscBusinessException("198888", "\u7cfb\u7edf\u5f02\u5e38,\u63d0\u73b0\u8bb0\u5f55\u6570\u636e\u6dfb\u52a0\u5f02\u5e38!");
        }
        ArrayList<FscWithdrawalLogItemPO> logItemPOlist = new ArrayList<FscWithdrawalLogItemPO>();
        for (FscBalancePO fscBalancePO : fscBalancePOList) {
            FscWithdrawalLogItemPO withdrawalLogItemPO = new FscWithdrawalLogItemPO();
            withdrawalLogItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            withdrawalLogItemPO.setWithdrawalLogId(cnsmrSeqNo);
            withdrawalLogItemPO.setBankCheckId(fscBalancePO.getBankCheckId());
            withdrawalLogItemPO.setOrgId(fscBalancePO.getOrgId());
            withdrawalLogItemPO.setAccountNo(reqBO.getAccountNo());
            withdrawalLogItemPO.setUsedAmount(fscBalancePO.getUsableAmount());
            withdrawalLogItemPO.setTransferFee(BigDecimal.ZERO);
            withdrawalLogItemPO.setCreateTime(dateTime);
            withdrawalLogItemPO.setOperId(reqBO.getUserId());
            withdrawalLogItemPO.setOperName(reqBO.getName());
            logItemPOlist.add(withdrawalLogItemPO);
        }
        this.fscWithdrawalLogItemMapper.insertBatch(logItemPOlist);
        FscComBalanceWithdrawalBusiRspBO rspBO = new FscComBalanceWithdrawalBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setBankCheckIds(reqBO.getBankCheckIds());
        rspBO.setRespDesc("\u63d0\u73b0\u64cd\u4f5c\u6210\u529f!");
        return rspBO;
    }
}

