/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityReqBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.common.ability.api.FscBillUpdateOrderStateAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillUpdateOrderStateAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscBillUpdateOrderStateAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscUpdateOrderInfoBusiService;
import com.tydic.fsc.common.busi.bo.FscUpdateOrderInfoBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscUpdateOrderInfoBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscBillUpdateOrderStateAbilityService"})
public class FscBillUpdateOrderStateAbilityServiceImpl
implements FscBillUpdateOrderStateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillUpdateOrderStateAbilityServiceImpl.class);
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscUpdateOrderInfoBusiService fscUpdateOrderInfoBusiService;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;
    private static final String DEAL_DESC = "\u5f00\u7968\u4e3b\u5355\u521b\u5efa";
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;

    @BigDecimalConvert
    @FscDuplicateCommitLimit
    @PostMapping(value={"dealUpdate"})
    public FscBillUpdateOrderStateAbilityRspBO dealUpdate(@RequestBody FscBillUpdateOrderStateAbilityReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191019", "\u4ed8\u6b3e\u5355\u4e0d\u5b58\u5728");
        }
        if (FscConstants.FscPayOrderState.TO_PAY.equals(fscOrderPO.getOrderState())) {
            FscUpdateOrderInfoBusiReqBO busiReqBO = new FscUpdateOrderInfoBusiReqBO();
            FscOrderPO set = new FscOrderPO();
            set.setOrderState(FscConstants.FscPayOrderState.PAIED);
            set.setPayState(FscConstants.PayOrderPayStatus.PAIED);
            set.setUpdateOperId(null != reqBO.getUserId() ? reqBO.getUserId().toString() : "");
            set.setUpdateTime(new Date());
            set.setUpdateOperName(reqBO.getName());
            busiReqBO.setSetPO(set);
            FscOrderPO where = new FscOrderPO();
            where.setFscOrderId(fscOrderPO.getFscOrderId());
            busiReqBO.setWherePO(where);
            FscUpdateOrderInfoBusiRspBO busiRspBO = this.fscUpdateOrderInfoBusiService.updateOrderInfo(busiReqBO);
            if (!"0000".equals(busiRspBO.getRespCode())) {
                throw new FscBusinessException("193130", busiRspBO.getRespDesc());
            }
            this.sendMq(reqBO);
            this.syncOrderStatus1(fscOrderPO.getFscOrderId());
        }
        return new FscBillUpdateOrderStateAbilityRspBO();
    }

    private void val(FscBillUpdateOrderStateAbilityReqBO reqBO) {
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderId]\u4e3a\u7a7a");
        }
    }

    private void sendMq(FscBillUpdateOrderStateAbilityReqBO fscBillUpdateOrderAbilityReqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscBillUpdateOrderAbilityReqBO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void syncOrderStatus1(Long fscPayOrderId) {
        List fscShouldPayPOList = this.fscShouldPayMapper.getByFscOrderId(fscPayOrderId);
        Map<Long, FscShouldPayPO> fscShouldPayPOMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getObjectId, FscShouldPayPO2 -> FscShouldPayPO2));
        if (CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            return;
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderIds(fscShouldPayPOList.stream().map(FscShouldPayPO::getObjectId).collect(Collectors.toList()));
        List orderList = this.fscOrderMapper.getList(fscOrderPo);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return;
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderIds(orderList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList()));
        List fscOrderRelationPOs = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (!CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            FscUocProOrderPaymentCallbackAbilityReqBO fscUocProOrderPaymentCallbackAbilityReqBO = new FscUocProOrderPaymentCallbackAbilityReqBO();
            fscUocProOrderPaymentCallbackAbilityReqBO.setUocPaymentCallbackBOS(fscOrderRelationPOs.stream().map(fscPaySuccessCallBackOrderBO -> {
                FscUocProOrderPaymentCallbackAbilityBO fscUocProOrderPaymentCallbackAbilityBO = new FscUocProOrderPaymentCallbackAbilityBO();
                fscUocProOrderPaymentCallbackAbilityBO.setSaleOrderId(fscPaySuccessCallBackOrderBO.getOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setPayMod(Integer.valueOf(30));
                fscUocProOrderPaymentCallbackAbilityBO.setObjectId(fscPaySuccessCallBackOrderBO.getAcceptOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setPayerType(FscConstants.FscOrderReceiveType.PURCHASE.equals(((FscOrderPO)orderList.get(0)).getReceiveType()) ? "pur" : "pro");
                fscUocProOrderPaymentCallbackAbilityBO.setPayResult(Boolean.valueOf(true));
                fscUocProOrderPaymentCallbackAbilityBO.setPayTime(new Date());
                fscUocProOrderPaymentCallbackAbilityBO.setShouldPayMoney(fscPaySuccessCallBackOrderBO.getOrderTotalCharge());
                fscUocProOrderPaymentCallbackAbilityBO.setFscShouldPayId(((FscShouldPayPO)fscShouldPayPOMap.get(fscPaySuccessCallBackOrderBO.getFscOrderId())).getShouldPayId());
                return fscUocProOrderPaymentCallbackAbilityBO;
            }).collect(Collectors.toList()));
            this.fscUocProOrderPaymentCallbackAbilityService.dealOrderPaymentCallback(fscUocProOrderPaymentCallbackAbilityReqBO);
        }
    }
}

