/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.comb.api.FscUocOrderRelUpdateCombService;
import com.tydic.fsc.busibase.comb.bo.FscUocOrderRelUpdateCombReqBO;
import com.tydic.fsc.busibase.comb.bo.FscUocOrderRelUpdateCombRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderConfirmAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncSendTodoAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderConfirmAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderConfirmAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncSendTodoAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscComOrderConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderConfirmBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderConfirmAbilityService"})
public class FscComOrderConfirmAbilityServiceImpl
implements FscComOrderConfirmAbilityService {
    @Autowired
    private FscComOrderConfirmBusiService fscComOrderConfirmBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscSyncSendTodoAbilityService fscSyncSendTodoAbilityService;
    @Autowired
    private FscUocOrderRelUpdateCombService fscUocOrderRelUpdateCombService;

    @PostMapping(value={"dealOrderConfirm"})
    public FscComOrderConfirmAbilityRspBO dealOrderConfirm(@RequestBody FscComOrderConfirmAbilityReqBO reqBO) {
        if (!"0".equals(reqBO.getIsprofess()) && !"2".equals(reqBO.getIsprofess())) {
            throw new FscBusinessException("193110", "\u65e0\u64cd\u4f5c\u6743\u9650\uff01");
        }
        this.val(reqBO);
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
        if ("2".equals(reqBO.getIsprofess()) && !FscBillStatus.TO_BE_CONFIRM.getCode().equals(fscOrder.getOrderState()) || "0".equals(reqBO.getIsprofess()) && !FscBillStatus.MAIN_ORDER_FEEDBACK.getCode().equals(fscOrder.getOrderState()) && !FscBillStatus.MAIN_ORDER_REJECT.getCode().equals(fscOrder.getOrderState())) {
            throw new FscBusinessException("191126", "\u5f53\u524d\u7ed3\u7b97\u5355\u72b6\u6001\u4e0d\u80fd\u786e\u8ba4");
        }
        this.verifyServiceFeeConfirmTime(fscOrderPo);
        String jsonString = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscComOrderConfirmBusiReqBO busiReqBO = (FscComOrderConfirmBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscComOrderConfirmBusiReqBO.class));
        busiReqBO.setOrderFlow(fscOrder.getOrderFlow());
        busiReqBO.setFscOrderNo(fscOrder.getOrderNo());
        busiReqBO.setTotalCharge(fscOrder.getTotalCharge());
        this.calShouldPayInfo(fscOrder, busiReqBO);
        FscComOrderConfirmBusiRspBO busiRspBO = this.fscComOrderConfirmBusiService.dealOrderConfirm(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("191126", busiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        if ("nopass".equals(reqBO.getAdjustResult()) && fscOrder.getTotalCharge().compareTo(null == fscOrder.getCreditAmount() ? BigDecimal.ZERO : fscOrder.getCreditAmount()) == 0) {
            this.syncOrderStatus(reqBO.getOrderId(), reqBO);
        }
        if ("2".equals(reqBO.getIsprofess())) {
            FscSyncSendTodoAbilityReqBO fscSendTodoBusiReqBO = new FscSyncSendTodoAbilityReqBO();
            fscSendTodoBusiReqBO.setFscOrderId(reqBO.getOrderId());
            fscSendTodoBusiReqBO.setCreateUserId(reqBO.getUserId());
            fscSendTodoBusiReqBO.setCreateUserName(reqBO.getUserName());
            fscSendTodoBusiReqBO.setSourceType(FscConstants.SOURCE_TYPE.FIX_SERVICE_FEE);
            fscSendTodoBusiReqBO.setObjType(FscConstants.TODO_OBJ_TYPE.DONE);
            this.fscSyncSendTodoAbilityService.syncSendTodo(fscSendTodoBusiReqBO);
        }
        return new FscComOrderConfirmAbilityRspBO();
    }

    private void verifyServiceFeeConfirmTime(FscOrderPO fscOrderPo) {
        if ((FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(fscOrderPo.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscOrderPo.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPo.getOrderFlow())) && System.currentTimeMillis() > fscOrderPo.getCreditConfirmDueDate().getTime()) {
            throw new FscBusinessException("191126", "\u8d85\u8fc7\u786e\u8ba4\u65f6\u9650\u65f6\u9650");
        }
    }

    private void val(FscComOrderConfirmAbilityReqBO reqBO) {
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAdjustResult())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[AdjustResult]\u4e3a\u7a7a");
        }
    }

    private void sendMq(FscComOrderConfirmAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        fscComOrderListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscComOrderListSyncAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void calShouldPayInfo(FscOrderPO fscOrderPO, FscComOrderConfirmBusiReqBO fscComOrderConfirmBusiReqBO) {
        ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
        fscShouldPayBO.setShouldPayId(fscOrderPO.getFscOrderId());
        fscShouldPayBO.setShouldPayNo(fscOrderPO.getOrderNo());
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PALATFORM_USE_PAY);
            fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.USR_ORDER);
            fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PREP);
        } else {
            fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.DEAL_PAY);
            fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.DEAL_ORDER);
            fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
        }
        fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
        fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
        if (fscOrderPO.getActualAmount() == null || BigDecimal.ZERO.compareTo(fscOrderPO.getActualAmount()) == 0) {
            fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
        } else {
            fscShouldPayBO.setShouldPayAmount(fscOrderPO.getActualAmount());
        }
        fscShouldPayBO.setPayeeId(fscOrderPO.getProOrgId());
        fscShouldPayBO.setPayeeName(fscOrderPO.getProOrgName());
        fscShouldPayBO.setPayerId(fscOrderPO.getSupplierId());
        fscShouldPayBO.setPayerName(fscOrderPO.getSupplierName());
        fscShouldPayBOS.add(fscShouldPayBO);
        fscComOrderConfirmBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
        fscComOrderConfirmBusiReqBO.setOrderFlow(fscOrderPO.getOrderFlow());
    }

    private void syncOrderStatus(Long fscOrderId, FscComOrderConfirmAbilityReqBO reqBO) {
        FscUocOrderRelUpdateCombReqBO fscUocOrderRelUpdateCombReqBO = new FscUocOrderRelUpdateCombReqBO();
        fscUocOrderRelUpdateCombReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateCombReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
        fscUocOrderRelUpdateCombReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        fscUocOrderRelUpdateCombReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscUocOrderRelUpdateCombReqBO.setSysTenantName(reqBO.getSysTenantName());
        FscUocOrderRelUpdateCombRspBO fscUocOrderRelUpdateCombRspBO = this.fscUocOrderRelUpdateCombService.dealRelUpdate(fscUocOrderRelUpdateCombReqBO);
        if (!"0000".equals(fscUocOrderRelUpdateCombRspBO.getRespCode())) {
            throw new FscBusinessException("193207", StrUtil.format((CharSequence)"\u540c\u6b65\u66f4\u65b0\u8ba2\u5355\u51fa\u9519\uff1a{}", (Object[])new Object[]{fscUocOrderRelUpdateCombRspBO.getRespDesc()}));
        }
    }
}

