/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscComPayOrderListBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscComPayOrderListPageQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComPayOrderListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComPayOrderListQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComPayOrderListPageQueryAbilityService"})
public class FscComPayOrderListPageQueryAbilityServiceImpl
implements FscComPayOrderListPageQueryAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"getComPayOrderListPageQuery"})
    public FscComPayOrderListQueryAbilityRspBO getComPayOrderListPageQuery(@RequestBody FscComPayOrderListQueryAbilityReqBO reqBO) {
        this.val(reqBO);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPayItemPO.setFscOrderNo(reqBO.getFscOrderNo());
        List pos = this.fscOrderPayItemMapper.getListForDealPaySuccessPage(fscOrderPayItemPO, page);
        if (!CollectionUtils.isEmpty((Collection)pos)) {
            for (FscComPayOrderListBO po : pos) {
                if (po.getActualAmount() == null) {
                    po.setActualAmount(BigDecimal.ZERO);
                }
                Map orderStateMap = 0 == po.getOrderFlow() && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(po.getMakeType()) ? this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_PUR_MATCH_ECOM_SETTLE_ORDER_STATE") : (0 == po.getOrderFlow() && !FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(po.getMakeType()) ? this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_LIST_STATE") : this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SERVICE_LIST_STATE"));
                po.setOrderStateStr((String)orderStateMap.get(po.getOrderState().toString()));
                if (ObjectUtil.isEmpty((Object)po.getCancelOrderType())) continue;
                if (po.getCancelOrderType().equals(0)) {
                    po.setCancelOrderTypeStr(po.getOrderFlow().equals(FscConstants.OrderFlow.INVOICE) ? "\u7ed3\u7b97\u5355\u90e8\u5206\u5546\u54c1\u8ba2\u5355\u5df2\u53d6\u6d88" : (po.getOrderFlow().equals(FscConstants.OrderFlow.PAY) ? "\u4ed8\u6b3e\u5355\u90e8\u5206\u5546\u54c1\u8ba2\u5355\u5df2\u53d6\u6d88" : "\u6210\u4ea4\u670d\u52a1\u8d39\u90e8\u5206\u5546\u54c1\u8ba2\u5355\u5df2\u53d6\u6d88"));
                    continue;
                }
                if (po.getCancelOrderType().equals(1)) {
                    po.setCancelOrderTypeStr(po.getOrderFlow().equals(FscConstants.OrderFlow.INVOICE) ? "\u7ed3\u7b97\u5355\u5df2\u53d6\u6d88" : (po.getOrderFlow().equals(FscConstants.OrderFlow.PAY) ? "\u4ed8\u6b3e\u5355\u5df2\u53d6\u6d88" : "\u6210\u4ea4\u670d\u52a1\u8d39\u5df2\u53d6\u6d88"));
                    continue;
                }
                if (!po.getCancelOrderType().equals(3)) continue;
                po.setCancelOrderTypeStr(po.getOrderFlow().equals(FscConstants.OrderFlow.INVOICE) ? "\u7ed3\u7b97\u5355\u5df2\u6838\u9500\u91d1\u989d\u4e0d\u505a\u4fee\u6539" : (po.getOrderFlow().equals(FscConstants.OrderFlow.PAY) ? "\u4ed8\u6b3e\u5355\u5df2\u6838\u9500\u91d1\u989d\u4e0d\u505a\u4fee\u6539" : "\u6210\u4ea4\u670d\u52a1\u8d39\u5df2\u6838\u9500\u91d1\u989d\u4e0d\u505a\u4fee\u6539"));
            }
        }
        FscComPayOrderListQueryAbilityRspBO abilityRspBO = new FscComPayOrderListQueryAbilityRspBO();
        abilityRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        abilityRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        abilityRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        abilityRspBO.setRespCode("0000");
        abilityRspBO.setRespDesc("\u5e94\u4ed8\u8bb0\u5f55\u67e5\u8be2\u6210\u529f");
        abilityRspBO.setRows(pos);
        return abilityRspBO;
    }

    private void val(FscComPayOrderListQueryAbilityReqBO reqBO) {
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderId]\u4e3a\u7a7a");
        }
    }
}

