/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.common.ability.api.FscExecuteInvoicingTimeoutTaskService;
import com.tydic.fsc.common.ability.bo.FscExecuteInvoicingTimeoutTaskReqBO;
import com.tydic.fsc.common.ability.bo.FscExecuteInvoicingTimeoutTaskRspBO;
import com.tydic.fsc.common.busi.api.FscUpdateOrderInfoBusiService;
import com.tydic.fsc.common.busi.bo.FscUpdateOrderInfoBusiReqBO;
import com.tydic.fsc.common.consumer.bo.FscInvoiceTimeoutReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.umc.general.ability.api.UmcSendTodoAbilityService;
import com.tydic.umc.general.ability.bo.UmcSendTodoAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcSendTodoAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcTodoBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscExecuteInvoicingTimeoutTaskService"})
public class FscExecuteInvoicingTimeoutTaskServiceImpl
implements FscExecuteInvoicingTimeoutTaskService {
    private static final Logger log = LoggerFactory.getLogger(FscExecuteInvoicingTimeoutTaskServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${task.max.pageSize}")
    private Integer maxPageSize;
    @Value(value="${task.invoice.timeout}")
    private Integer dayTime;
    @Autowired
    private UmcSendTodoAbilityService umcSendTodoAbilityService;
    @Autowired
    private FscUpdateOrderInfoBusiService fscUpdateOrderInfoBusiService;
    @Resource(name="fscInvoiceTimeoutProducer")
    private ProxyMessageProducer fscInvoiceTimeoutProducer;
    @Value(value="${INVOICE_TIMEOUT_TOPIC:INVOICE_TIMEOUT_TOPIC}")
    private String INVOICE_TIMEOUT_TOPIC;
    @Value(value="${INVOICE_TIMEOUT_TAG:INVOICE_TIMEOUT_TAG}")
    private String INVOICE_TIMEOUT_TAG;

    @PostMapping(value={"executeInvoicingTimeoutTask"})
    public FscExecuteInvoicingTimeoutTaskRspBO executeInvoicingTimeoutTask(@RequestBody FscExecuteInvoicingTimeoutTaskReqBO reqBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setOrderStates(Arrays.asList(FscConstants.FscServiceOrderState.BILLED_INVOICE, FscConstants.FscServiceOrderState.TO_BE_APPROVAL));
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
        Calendar now = Calendar.getInstance();
        now.add(5, Math.negateExact(this.dayTime));
        fscOrderPO.setCreateTimeEnd(now.getTime());
        fscOrderPO.setGroupByField("supplier_id");
        log.info("\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderPO));
        List supplierFscOrderPOList = this.fscOrderMapper.getInvoiceTimeoutOrderGroupBy(fscOrderPO);
        if (!ObjectUtil.isEmpty((Object)supplierFscOrderPOList)) {
            for (FscOrderPO item : supplierFscOrderPOList) {
                FscInvoiceTimeoutReqBO fscInvoiceTimeoutReqBO = new FscInvoiceTimeoutReqBO();
                fscInvoiceTimeoutReqBO.setTaskCode("INVOICE_TIMEOUT_NOTICE_SUPPLIER");
                fscInvoiceTimeoutReqBO.setSupplierId(item.getSupplierId());
                fscInvoiceTimeoutReqBO.setSysTenantId(reqBO.getSysTenantId());
                fscInvoiceTimeoutReqBO.setSysTenantName(reqBO.getSysTenantName());
                log.info("\u4f9b\u5e94\u5546----\u53d1\u9001\u6d88\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscInvoiceTimeoutReqBO));
                ProxySendResult proxySendResult = this.fscInvoiceTimeoutProducer.send(new ProxyMessage(this.INVOICE_TIMEOUT_TOPIC, this.INVOICE_TIMEOUT_TAG, JSONObject.toJSONString((Object)fscInvoiceTimeoutReqBO)));
            }
        }
        fscOrderPO.setGroupByField("swap_user_id");
        log.info("\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderPO));
        List purchaserFscOrderPOList = this.fscOrderMapper.getInvoiceTimeoutOrderGroupBy(fscOrderPO);
        if (!ObjectUtil.isEmpty((Object)purchaserFscOrderPOList)) {
            for (FscOrderPO item : purchaserFscOrderPOList) {
                FscInvoiceTimeoutReqBO fscInvoiceTimeoutReqBO = new FscInvoiceTimeoutReqBO();
                fscInvoiceTimeoutReqBO.setTaskCode("INVOICE_TIMEOUT_NOTICE_OPERATE");
                fscInvoiceTimeoutReqBO.setCreateUserId(item.getSwapUserId());
                fscInvoiceTimeoutReqBO.setSysTenantId(reqBO.getSysTenantId());
                fscInvoiceTimeoutReqBO.setSysTenantName(reqBO.getSysTenantName());
                log.info("\u91c7\u8d2d\u7ed3\u7b97\u5458----\u53d1\u9001\u6d88\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscInvoiceTimeoutReqBO));
                ProxySendResult proxySendResult = this.fscInvoiceTimeoutProducer.send(new ProxyMessage(this.INVOICE_TIMEOUT_TOPIC, this.INVOICE_TIMEOUT_TAG, JSONObject.toJSONString((Object)fscInvoiceTimeoutReqBO)));
            }
        }
        return new FscExecuteInvoicingTimeoutTaskRspBO();
    }

    private void sendToDo(FscOrderPO fscOrderPO) {
        UmcSendTodoAbilityReqBO sendTodoAbilityReqBO = new UmcSendTodoAbilityReqBO();
        ArrayList<UmcTodoBO> todoBos = new ArrayList<UmcTodoBO>();
        UmcTodoBO umcTodoBO = new UmcTodoBO();
        umcTodoBO.setBusiId(fscOrderPO.getFscOrderId().toString());
        umcTodoBO.setTodoName("\u53d1\u7968\u5f00\u7968\u8d85\u671f:" + fscOrderPO.getOrderNo());
        umcTodoBO.setTodoItemCode("INVOICE_FAIL_NOTICE_TODO");
        umcTodoBO.setTodoItemName("\u53d1\u7968\u5f00\u7968\u5931\u8d25\u53d1\u9001\u4ee3\u529e");
        umcTodoBO.setTodoUrl("editFscOrder");
        umcTodoBO.setUrlSuffix("?fscOrderId=" + fscOrderPO.getFscOrderId() + "&purchaserId=" + fscOrderPO.getPurchaserId());
        umcTodoBO.setTodoModuleCode("settle");
        umcTodoBO.setTodoModuleName("\u53d1\u7968\u5f00\u7968\u5931\u8d25\u53d1\u9001\u4ee3\u529e");
        umcTodoBO.setCandidateOperId(fscOrderPO.getCreateOperId().toString());
        umcTodoBO.setCandidateOperName(fscOrderPO.getCreateOperName());
        umcTodoBO.setCreateOperId("1");
        umcTodoBO.setCreateOperName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        umcTodoBO.setBusinessUnid(fscOrderPO.getFscOrderId().toString());
        umcTodoBO.setCurnode("\u53d1\u7968\u5f00\u7968\u5931\u8d25");
        umcTodoBO.setFlowstatus("\u5931\u8d25");
        todoBos.add(umcTodoBO);
        sendTodoAbilityReqBO.setTodoList(todoBos);
        sendTodoAbilityReqBO.setType("unread");
        log.info("\u521b\u5efa\u9700\u6c42\u5355\u53d1\u9001\u4ee3\u529e\u53c2\u6570\uff1a{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)sendTodoAbilityReqBO));
        UmcSendTodoAbilityRspBO umcSendTodoAbilityRspBO = this.umcSendTodoAbilityService.sendTodo(sendTodoAbilityReqBO);
        log.info("\u521b\u5efa\u9700\u6c42\u5355\u53d1\u9001\u4ee3\u529e\u51fa\u53c2\uff1a{}", (Object)com.aliyun.openservices.shade.com.alibaba.fastjson.JSON.toJSONString((Object)umcSendTodoAbilityRspBO));
        if (!"0000".equals(umcSendTodoAbilityRspBO.getRespCode())) {
            this.updateInfo(fscOrderPO, 0);
        } else {
            this.updateInfo(fscOrderPO, 1);
        }
    }

    private void updateInfo(FscOrderPO fscOrderPO, Integer type) {
        FscOrderPO setPO = new FscOrderPO();
        setPO.setInvoiceFailNoticeTime(new Date());
        setPO.setInvoiceNoticeState(type);
        FscOrderPO wherePO = new FscOrderPO();
        wherePO.setFscOrderId(fscOrderPO.getFscOrderId());
        FscUpdateOrderInfoBusiReqBO fscUpdateOrderInfoBusiReqBO = new FscUpdateOrderInfoBusiReqBO();
        fscUpdateOrderInfoBusiReqBO.setSetPO(setPO);
        fscUpdateOrderInfoBusiReqBO.setWherePO(wherePO);
        this.fscUpdateOrderInfoBusiService.updateOrderInfo(fscUpdateOrderInfoBusiReqBO);
    }
}

