/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bo.FscMerchantChannelDataBO;
import com.tydic.fsc.bo.FscMerchantPayMethodDataBO;
import com.tydic.fsc.bo.FscMerchantPayeeDataBO;
import com.tydic.fsc.busibase.external.api.pay.FscPayTransPayInsService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsReqBo;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsRspBo;
import com.tydic.fsc.common.ability.api.FscMerchantConfListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscMerchantConfListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscMerchantConfListQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscMerchantPayeeChannelMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscSkuCategoryMapper;
import com.tydic.fsc.po.FscDicDictionaryPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscMerchantPayeeChannelPO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscSkuCategoryPO;
import com.tydic.fsc.util.FscRspUtil;
import com.tydic.umc.supplier.ability.api.UmcSupSignContractAbilityService;
import com.tydic.umc.supplier.ability.bo.UmcSupSalesCategoryListAbilityReqBO;
import com.tydic.umc.supplier.ability.bo.UmcSupSalesCategoryListAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscMerchantConfListQueryAbilityService"})
public class FscMerchantConfListQueryAbilityServiceImpl
implements FscMerchantConfListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantConfListQueryAbilityServiceImpl.class);
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Autowired
    private FscMerchantPayeeChannelMapper fscMerchantPayeeChannelMapper;
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;
    @Autowired
    private FscPayTransPayInsService fscPayTransPayInsService;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscSkuCategoryMapper fscSkuCategoryMapper;
    @Autowired
    private UmcSupSignContractAbilityService umcSupSignContractAbilityService;
    @Value(value="${enabled.pingAn.account:true}")
    private Boolean enabledPingAnAccount;

    @PostMapping(value={"queryConfList"})
    public FscMerchantConfListQueryAbilityRspBO queryConfList(@RequestBody FscMerchantConfListQueryAbilityReqBO reqBO) {
        FscMerchantConfListQueryAbilityRspBO retBo = (FscMerchantConfListQueryAbilityRspBO)FscRspUtil.getRspBo((String)"191127", (String)"\u5931\u8d25", FscMerchantConfListQueryAbilityRspBO.class);
        String validateStr = this.validateArgs(reqBO);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a{}", (Object)validateStr);
            retBo.setRespDesc(validateStr);
            return retBo;
        }
        FscMerchantPO queryPo = new FscMerchantPO();
        queryPo.setOrgId(reqBO.getSupOrgId());
        queryPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        queryPo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
        queryPo.setStatus(FscConstants.MerchantStatus.VALID);
        FscMerchantPO merchantPo = this.fscMerchantMapper.getModelBy(queryPo);
        if (null == merchantPo) {
            log.error("\u6839\u636e\u5165\u53c2\uff1a[{}]\uff0c\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u5546\u6237\u4fe1\u606f", (Object)JSON.toJSONString((Object)reqBO));
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u6709\u6548\u7684\u5546\u6237\u4fe1\u606f");
            return retBo;
        }
        if (!(StringUtils.isEmpty((Object)reqBO.getPayBusiSceneRange()) || "0".equals(merchantPo.getPayBusiSceneRange()) || merchantPo.getPayBusiSceneRange().equals(reqBO.getPayBusiSceneRange()))) {
            log.error("\u6839\u636e\u5165\u53c2\uff1a[{}]\uff0c\u67e5\u8be2\u5230\u5546\u6237\u4e1a\u52a1\u573a\u666f\u4e0d\u5339\u914d", (Object)JSON.toJSONString((Object)reqBO));
            retBo.setRespDesc("\u5546\u6237\u4e1a\u52a1\u573a\u666f\u4e0d\u5339\u914d");
            return retBo;
        }
        BeanUtils.copyProperties((Object)merchantPo, (Object)retBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        FscMerchantPayeePO payeePo = new FscMerchantPayeePO();
        payeePo.setMerchantId(merchantPo.getMerchantId());
        if (this.enabledPingAnAccount.booleanValue()) {
            payeePo.setAccountNoType("2");
        } else {
            payeePo.setAccountNoType("1");
        }
        payeePo = this.fscMerchantPayeeMapper.getModelBy(payeePo);
        if (null == payeePo) {
            payeePo = new FscMerchantPayeePO();
            payeePo.setMerchantId(merchantPo.getMerchantId());
            payeePo.setAccountNoType("3");
            payeePo = this.fscMerchantPayeeMapper.getModelBy(payeePo);
            if (null == payeePo) {
                log.error("\u672a\u67e5\u8be2\u5230\u5546\u6237\uff1a{}\uff0c\u7684\u6536\u6b3e\u8d26\u6237\u4fe1\u606f", (Object)merchantPo.getMerchantId());
                retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u673a\u6784\uff1a" + reqBO.getSupOrgId() + "\uff0c\u7684\u6536\u6b3e\u8d26\u6237\u4fe1\u606f");
                return retBo;
            }
        }
        FscMerchantPayeeDataBO payeeInfo = new FscMerchantPayeeDataBO();
        BeanUtils.copyProperties((Object)payeePo, (Object)payeeInfo);
        if (null != merchantPo.getPayType()) {
            payeeInfo.setPayType(merchantPo.getPayType().toString());
            payeeInfo.setPayTypeStr(this.getDicMap().get(merchantPo.getPayType().toString()));
        }
        retBo.setPayeeInfo(payeeInfo);
        ArrayList<FscMerchantChannelDataBO> payChannels = new ArrayList<FscMerchantChannelDataBO>();
        retBo.setPayChannels(payChannels);
        this.queryPayChannel(merchantPo.getMerchantId(), payChannels);
        if (FscConstants.MerchantAllowException.YES.equals(merchantPo.getPayAllowExceptionFlag())) {
            queryPo.setStatus(FscConstants.MerchantStatus.DRAFT);
            queryPo.setParentId(merchantPo.getMerchantId());
            queryPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
            if (null != reqBO.getPurOrgId()) {
                queryPo.setPayObjId(reqBO.getPurOrgId());
            } else {
                queryPo.setPayUserIdentity(Integer.valueOf(reqBO.getUserIdentity()));
            }
            FscMerchantPO payException = this.fscMerchantMapper.getModelBy(queryPo);
            if (null != payException) {
                retBo.setPayType(payException.getPayType());
                retBo.setPayBusiSceneRange(payException.getPayBusiSceneRange());
                retBo.setPayRule(payException.getPayRule());
                retBo.setPayCreditAmount(payException.getPayCreditAmount());
                retBo.setPayBreakScale(payException.getPayBreakScale());
                retBo.setPayAccountDay(payException.getPayAccountDay());
                retBo.setPayAccountDayRule(payException.getPayAccountDayRule());
                retBo.setPayNodeAccountDays(payException.getPayNodeAccountDays());
                retBo.setPayNodeRule(payException.getPayNodeRule());
                if (null != merchantPo.getPayType()) {
                    payeeInfo.setPayType(merchantPo.getPayType().toString());
                    payeeInfo.setPayTypeStr(this.getDicMap().get(merchantPo.getPayType().toString()));
                }
                this.queryPayChannel(payException.getMerchantId(), payChannels);
            }
        }
        if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(retBo.getPayRule())) {
            retBo.setPayAccountDay(retBo.getPayNodeAccountDays());
        }
        if (FscConstants.MerchantAllowException.YES.equals(merchantPo.getModelAllowExceptionFlag())) {
            FscMerchantPO queryModelPo = new FscMerchantPO();
            queryModelPo.setOrgId(reqBO.getSupOrgId());
            queryModelPo.setParentId(merchantPo.getMerchantId());
            queryModelPo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
            queryModelPo.setStatus(FscConstants.MerchantStatus.DRAFT);
            queryModelPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
            queryModelPo.setModelObjId(reqBO.getPurOrgId());
            FscMerchantPO fscMerchantPO = this.fscMerchantMapper.getModelBy(queryModelPo);
            if (null == fscMerchantPO && !StringUtils.isEmpty((Object)reqBO.getUserIdentity())) {
                queryModelPo.setModelObjId(null);
                if (!StringUtils.isEmpty((Object)reqBO.getUserIdentity()) && reqBO.getUserIdentity().equals("1")) {
                    queryModelPo.setModelUserIdentity(Integer.valueOf(3));
                } else if (!StringUtils.isEmpty((Object)reqBO.getUserIdentity()) && reqBO.getUserIdentity().equals("2")) {
                    queryModelPo.setModelUserIdentity(Integer.valueOf(2));
                } else if (!StringUtils.isEmpty((Object)reqBO.getUserIdentity()) && reqBO.getUserIdentity().equals("4")) {
                    queryModelPo.setModelUserIdentity(Integer.valueOf(0));
                } else if (!StringUtils.isEmpty((Object)reqBO.getUserIdentity()) && reqBO.getUserIdentity().equals("3")) {
                    queryModelPo.setModelUserIdentity(Integer.valueOf(1));
                }
                fscMerchantPO = this.fscMerchantMapper.getModelBy(queryModelPo);
            }
            if (null != fscMerchantPO) {
                if (FscConstants.MerchantModelSceneRange.CONTRACT.equals(fscMerchantPO.getModelSceneRange())) {
                    UmcSupSalesCategoryListAbilityReqBO umcSupSalesCategoryListAbilityReqBO = new UmcSupSalesCategoryListAbilityReqBO();
                    umcSupSalesCategoryListAbilityReqBO.setSignContractId(fscMerchantPO.getModelContractId());
                    umcSupSalesCategoryListAbilityReqBO.setPageNo(Integer.valueOf(-1));
                    umcSupSalesCategoryListAbilityReqBO.setPageSize(Integer.valueOf(-1));
                    UmcSupSalesCategoryListAbilityRspBO signContractApplyDetail = this.umcSupSignContractAbilityService.getSalesCategoryList(umcSupSalesCategoryListAbilityReqBO);
                    if (!"0000".equals(signContractApplyDetail.getRespCode())) {
                        retBo.setRespDesc(signContractApplyDetail.getRespDesc());
                        return retBo;
                    }
                    if (!CollectionUtils.isEmpty((Collection)signContractApplyDetail.getRows())) {
                        List itemCatIds = signContractApplyDetail.getRows().stream().map(applyBo -> Convert.toStr((Object)applyBo.getItemCatId())).distinct().collect(Collectors.toList());
                        retBo.setExtSkuCategoryIds(itemCatIds);
                    }
                } else {
                    FscSkuCategoryPO fscSkuCategoryPO = new FscSkuCategoryPO();
                    fscSkuCategoryPO.setMerchantId(fscMerchantPO.getMerchantId());
                    List skuCategoryList = this.fscSkuCategoryMapper.getList(fscSkuCategoryPO);
                    if (!CollectionUtils.isEmpty((Collection)skuCategoryList)) {
                        List itemCatIds = skuCategoryList.stream().map(FscSkuCategoryPO::getCategoryTreePath).distinct().collect(Collectors.toList());
                        retBo.setExtSkuCategoryIds(itemCatIds);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5546\u6237\u652f\u4ed8\u914d\u7f6e\u67e5\u8be2\u5b8c\u6210\uff0c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        if (!FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(retBo.getPayType()) && FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PREP.equals(retBo.getPayType())) {
            retBo.setPayNodeRule(null);
            retBo.setPayNodeAccountDays(null);
            retBo.setPayAccountDay(null);
            retBo.setPayAccountDayRule(null);
            retBo.setPayCreditAmount(null);
            retBo.setPayBreakScale(null);
        }
        return retBo;
    }

    private void queryPayChannel(Long merchantId, List<FscMerchantChannelDataBO> payChannels) {
        FscMerchantPayeeChannelPO qryPo = new FscMerchantPayeeChannelPO();
        qryPo.setMerchantId(merchantId);
        List channelPos = this.fscMerchantPayeeChannelMapper.getList(qryPo);
        if (CollectionUtils.isEmpty((Collection)channelPos)) {
            return;
        }
        payChannels.clear();
        List paymentInsId = channelPos.stream().map(item -> Long.valueOf(item.getPayChannel())).collect(Collectors.toList());
        FscPayTransPayInsReqBo transReqBo = new FscPayTransPayInsReqBo();
        transReqBo.setPaymentInsId(paymentInsId);
        FscPayTransPayInsRspBo transRetBo = this.fscPayTransPayInsService.tranPayIns(transReqBo);
        if (!"0000".equals(transRetBo.getRespCode())) {
            return;
        }
        Map payInsMap = transRetBo.getPayInsMap();
        Map payMethodMap = transRetBo.getPayMethodMap();
        for (FscMerchantPayeeChannelPO channelPo : channelPos) {
            FscMerchantChannelDataBO dataBO = new FscMerchantChannelDataBO();
            dataBO.setPayChannel(channelPo.getPayChannel());
            dataBO.setPayChannelStr((String)payInsMap.get(channelPo.getPayChannel()));
            ArrayList<FscMerchantPayMethodDataBO> payMethodDataBOList = new ArrayList<FscMerchantPayMethodDataBO>();
            String[] payMethods = channelPo.getPayMethod().split(",");
            for (int i = 0; i < payMethods.length; ++i) {
                FscMerchantPayMethodDataBO methodBo = new FscMerchantPayMethodDataBO();
                methodBo.setPayMethod(payMethods[i]);
                methodBo.setPayMethodStr((String)payMethodMap.get(payMethods[i]));
                payMethodDataBOList.add(methodBo);
            }
            dataBO.setPayMethods(payMethodDataBOList);
            payChannels.add(dataBO);
        }
    }

    private String validateArgs(FscMerchantConfListQueryAbilityReqBO reqBO) {
        if (null == reqBO) {
            return "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getSupOrgId()) {
            return "\u4f9b\u5e94\u5546ID[supOrgId]\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (null == reqBO.getPurOrgId() && StringUtils.isEmpty((Object)reqBO.getUserIdentity())) {
            return "\u91c7\u8d2d\u5355\u4f4dID[purOrgId]\u548c\u5e73\u53f0\u7528\u6237\u8eab\u4efd[userIdentity]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a";
        }
        return null;
    }

    private Map<String, String> getDicMap() {
        HashMap dicMap = new HashMap(16);
        FscDicDictionaryPO queryPo = new FscDicDictionaryPO();
        queryPo.setSysCode("FSC");
        queryPo.setPCode("MERCHANT_PAY_TYPE");
        List dicDictionaryPos = this.fscDicDictionaryMapper.getListByCondition(queryPo);
        Map<String, String> map = dicDictionaryPos.stream().collect(Collectors.toMap(FscDicDictionaryPO::getCode, fscDicDictionaryPO -> fscDicDictionaryPO.getTitle()));
        return map;
    }
}

