/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityReqBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderAutoWriteOffAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderAutoWriteOffAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderAutoWriteOffAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscWriteOffBankFileApprovalAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscOrderAutoWriteOffBusiService;
import com.tydic.fsc.common.busi.bo.FscOrderAutoWriteOffBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscOrderAutoWriteOffBusiRspBO;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscWriteOffApprovalOrderMapper;
import com.tydic.fsc.dao.FscWriteOffApprovalRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscOrderAutoWriteOffAbilityService"})
public class FscOrderAutoWriteOffAbilityServiceImpl
implements FscOrderAutoWriteOffAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderAutoWriteOffAbilityServiceImpl.class);
    @Autowired
    private FscOrderAutoWriteOffBusiService fscOrderAutoWriteOffBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscWriteOffApprovalOrderMapper fscWriteOffApprovalOrderMapper;
    @Autowired
    private FscWriteOffApprovalRelationMapper fscWriteOffApprovalRelationMapper;
    @Autowired
    private FscMerchantPayeeMapper fcMerchantPayeeMapper;

    @PostMapping(value={"autoWriteOffFscOrder"})
    public FscOrderAutoWriteOffAbilityRspBO autoWriteOffFscOrder(@RequestBody FscOrderAutoWriteOffAbilityReqBO reqBO) {
        FscOrderAutoWriteOffAbilityRspBO rspBO = new FscOrderAutoWriteOffAbilityRspBO();
        FscMerchantPayeePO fscMerchantPayeePo = new FscMerchantPayeePO();
        fscMerchantPayeePo.setAccountNoType("3");
        List fscMerchantPayeePOList = this.fcMerchantPayeeMapper.getList(fscMerchantPayeePo);
        if (ObjectUtil.isEmpty((Object)fscMerchantPayeePOList)) {
            return rspBO;
        }
        FscOrderPO fscOrderPOQry = new FscOrderPO();
        fscOrderPOQry.setFscOrderIds(reqBO.getFscOrderIds());
        fscOrderPOQry.setOrderState(FscConstants.FscPayOrderState.TO_PAY);
        fscOrderPOQry.setOrderFlow(FscConstants.OrderFlow.PAY);
        fscOrderPOQry.setPayeeBankAccountList(fscMerchantPayeePOList.stream().map(FscMerchantPayeePO::getPayeeBankAccount).collect(Collectors.toList()));
        fscOrderPOQry.setLastPayDateEnd(new Date());
        if (ObjectUtil.isEmpty((Object)fscOrderPOQry.getPayeeBankAccountList())) {
            return rspBO;
        }
        List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPOQry);
        if (ObjectUtil.isEmpty((Object)fscOrderPOList)) {
            return rspBO;
        }
        for (FscOrderPO fscOrderPO : fscOrderPOList) {
            FscOrderAutoWriteOffBusiReqBO fscWriteOffBankFileApprovalBusiReqBO = new FscOrderAutoWriteOffBusiReqBO();
            fscWriteOffBankFileApprovalBusiReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
            FscOrderAutoWriteOffBusiRspBO fscOrderAutoWriteOffBusiRspBO = this.fscOrderAutoWriteOffBusiService.autoWriteOffFscOrderEdit(fscWriteOffBankFileApprovalBusiReqBO);
        }
        for (FscOrderPO fscOrderPO : fscOrderPOList) {
            this.syncOrder(fscOrderPO);
            this.syncOrderStatus(fscOrderPO.getFscOrderId());
        }
        return rspBO;
    }

    private void val(FscWriteOffBankFileApprovalAbilityReqBO reqBO) {
    }

    private void syncOrder(FscOrderPO fscOrder) {
        try {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrder.getFscOrderId());
            fscComOrderListSyncAbilityReqBO.setSysTenantId(fscOrder.getSysTenantId());
            fscComOrderListSyncAbilityReqBO.setSysTenantName(fscOrder.getSysTenantName());
            this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void syncOrderStatus(Long fscPayOrderId) {
        List fscShouldPayPOList = this.fscShouldPayMapper.getByFscOrderId(fscPayOrderId);
        Map<Long, FscShouldPayPO> fscShouldPayPOMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getObjectId, FscShouldPayPO2 -> FscShouldPayPO2));
        if (CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            return;
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderIds(fscShouldPayPOList.stream().map(FscShouldPayPO::getObjectId).collect(Collectors.toList()));
        List orderList = this.fscOrderMapper.getList(fscOrderPo);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return;
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderIds(orderList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList()));
        List fscOrderRelationPOs = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (!CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            FscUocProOrderPaymentCallbackAbilityReqBO fscUocProOrderPaymentCallbackAbilityReqBO = new FscUocProOrderPaymentCallbackAbilityReqBO();
            fscUocProOrderPaymentCallbackAbilityReqBO.setUocPaymentCallbackBOS(fscOrderRelationPOs.stream().map(fscPaySuccessCallBackOrderBO -> {
                FscUocProOrderPaymentCallbackAbilityBO fscUocProOrderPaymentCallbackAbilityBO = new FscUocProOrderPaymentCallbackAbilityBO();
                fscUocProOrderPaymentCallbackAbilityBO.setSaleOrderId(fscPaySuccessCallBackOrderBO.getOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setObjectId(fscPaySuccessCallBackOrderBO.getAcceptOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setPayerType(FscConstants.FscOrderReceiveType.PURCHASE.equals(((FscOrderPO)orderList.get(0)).getReceiveType()) ? "pur" : "pro");
                fscUocProOrderPaymentCallbackAbilityBO.setPayMod(Integer.valueOf(30));
                fscUocProOrderPaymentCallbackAbilityBO.setPayResult(Boolean.valueOf(true));
                fscUocProOrderPaymentCallbackAbilityBO.setShouldPayMoney(fscPaySuccessCallBackOrderBO.getOrderTotalCharge());
                fscUocProOrderPaymentCallbackAbilityBO.setFscShouldPayId(((FscShouldPayPO)fscShouldPayPOMap.get(fscPaySuccessCallBackOrderBO.getFscOrderId())).getShouldPayId());
                return fscUocProOrderPaymentCallbackAbilityBO;
            }).collect(Collectors.toList()));
            this.fscUocProOrderPaymentCallbackAbilityService.dealOrderPaymentCallback(fscUocProOrderPaymentCallbackAbilityReqBO);
        }
    }

    private String getSerial() {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.getInstance((String)"127").getDesc());
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return (String)encodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }
}

