/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.busi.api.FscAccountEditBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountEditBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAccountEditBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscLegalCompanyPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscAccountEditBusiServiceImpl
implements FscAccountEditBusiService {
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;

    @Override
    public FscAccountEditBusiRspBO editAccount(FscAccountEditBusiReqBO reqBO) {
        FscAccountEditBusiRspBO fscAccountEditBusiRspBO = new FscAccountEditBusiRspBO();
        Date curDate = new Date();
        if (2 == reqBO.getStatus()) {
            FscAccountPO set = new FscAccountPO();
            set.setStatus(FscConstants.AccountStatus.INVALID);
            FscAccountPO where = new FscAccountPO();
            where.setOrgId(reqBO.getOrgId());
            if (Integer.parseInt("1") == reqBO.getAccountCategory()) {
                where.setAccountNo(reqBO.getAccountNo());
            } else {
                where.setRecvSubLedgerAcctNo(reqBO.getRecvSubLedgerAcctNo());
            }
            where.setAccountNoTypeList(Arrays.asList("2", "3"));
            where.setAccountCategory(reqBO.getAccountCategory());
            this.fscAccountMapper.updateBy(set, where);
        } else if (1 == reqBO.getStatus()) {
            int insert;
            FscLegalCompanyPO fscLegalCompanyPO = this.fscLegalCompanyMapper.getByOrgId(reqBO.getOrgId());
            if (null == fscLegalCompanyPO) {
                fscLegalCompanyPO = new FscLegalCompanyPO();
                fscLegalCompanyPO.setOrgId(reqBO.getOrgId());
                fscLegalCompanyPO.setOrgName(reqBO.getOrgName());
                fscLegalCompanyPO.setStatus(Integer.valueOf(3));
                if (null != reqBO.getUserId()) {
                    fscLegalCompanyPO.setCreateOperId(reqBO.getUserId().toString());
                }
                fscLegalCompanyPO.setCreateOperName(reqBO.getName());
                fscLegalCompanyPO.setCreateTime(curDate);
                fscLegalCompanyPO.setSysTenantId(reqBO.getSysTenantId());
                fscLegalCompanyPO.setSysTenantName(reqBO.getSysTenantName());
                this.fscLegalCompanyMapper.insert(fscLegalCompanyPO);
            }
            FscAccountPO fscAccountPOQry = new FscAccountPO();
            fscAccountPOQry.setOrgId(reqBO.getOrgId());
            fscAccountPOQry.setStatus(FscConstants.AccountStatus.VALID);
            fscAccountPOQry.setAccountNoTypeList(Arrays.asList("2", "3"));
            List fscAccountPOQryResult = this.fscAccountMapper.getList(fscAccountPOQry);
            if (!CollectionUtils.isEmpty((Collection)fscAccountPOQryResult)) {
                FscAccountPO set = new FscAccountPO();
                set.setStatus(FscConstants.AccountStatus.INVALID);
                this.fscAccountMapper.updateBy(set, fscAccountPOQry);
            }
            FscAccountPO fscAccountPO = (FscAccountPO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscAccountPO.class);
            fscAccountPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAccountPO.setCreateTime(new Date());
            fscAccountPO.setStatus(FscConstants.AccountStatus.VALID);
            if (null != reqBO.getUserId()) {
                fscAccountPO.setCreateOperId(reqBO.getUserId().toString());
            }
            if ((insert = this.fscAccountMapper.insert(fscAccountPO)) < 1) {
                throw new FscBusinessException("193101", "\u8d26\u6237\u4fe1\u606f\u5165\u8868\u5931\u8d25");
            }
            fscAccountEditBusiRspBO.setId(fscAccountPO.getId());
            if (Integer.parseInt("1") != reqBO.getAccountCategory()) {
                FscMerchantPO fscMerchantPo = new FscMerchantPO();
                fscMerchantPo.setOrgId(reqBO.getOrgId());
                fscMerchantPo.setStatus(Integer.valueOf(3));
                fscMerchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
                fscMerchantPo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
                FscMerchantPO fscMerchantPoQryResult = this.fscMerchantMapper.getModelBy(fscMerchantPo);
                if (null != fscMerchantPoQryResult) {
                    FscMerchantPayeePO fscMerchantPayeePo = new FscMerchantPayeePO();
                    fscMerchantPayeePo.setMerchantId(fscMerchantPoQryResult.getMerchantId());
                    ArrayList<String> accountNoTypeList = new ArrayList<String>();
                    accountNoTypeList.add("2");
                    accountNoTypeList.add("3");
                    fscMerchantPayeePo.setAccountNoTypeList(accountNoTypeList);
                    List fscMerchantPayeePoQryResult = this.fscMerchantPayeeMapper.getList(fscMerchantPayeePo);
                    if (!CollectionUtils.isEmpty((Collection)fscMerchantPayeePoQryResult)) {
                        for (FscMerchantPayeePO fscMerchantPayeePO : fscMerchantPayeePoQryResult) {
                            if (reqBO.getAccountNoType().equals(fscMerchantPayeePO.getAccountNoType())) {
                                FscMerchantPayeePO fscMerchantPayeePoUpdate = new FscMerchantPayeePO();
                                fscMerchantPayeePoUpdate.setId(fscMerchantPayeePO.getId());
                                fscMerchantPayeePoUpdate.setPayeeBankAccount(reqBO.getRecvSubLedgerAcctNo());
                                fscMerchantPayeePoUpdate.setPayeeAccountName(reqBO.getRecvSubLedgerAcctName());
                                fscMerchantPayeePoUpdate.setPayeeBankName(reqBO.getRecvSubLedgerBankName());
                                fscMerchantPayeePoUpdate.setAccountNoType(reqBO.getAccountNoType());
                                this.fscMerchantPayeeMapper.updateById(fscMerchantPayeePoUpdate);
                                continue;
                            }
                            this.fscMerchantPayeeMapper.deleteBy(fscMerchantPayeePO);
                        }
                    }
                    if (CollectionUtils.isEmpty((Collection)fscMerchantPayeePoQryResult) || fscMerchantPayeePoQryResult.stream().filter(bo -> bo.getAccountNoType().equals(reqBO.getAccountNoType())).count() <= 0L) {
                        FscMerchantPayeePO fscMerchantPayeePoUpdate = new FscMerchantPayeePO();
                        fscMerchantPayeePoUpdate.setId(Long.valueOf(Sequence.getInstance().nextId()));
                        fscMerchantPayeePoUpdate.setMerchantId(fscMerchantPoQryResult.getMerchantId());
                        fscMerchantPayeePoUpdate.setPayeeBankAccount(reqBO.getRecvSubLedgerAcctNo());
                        fscMerchantPayeePoUpdate.setPayeeAccountName(reqBO.getRecvSubLedgerAcctName());
                        fscMerchantPayeePoUpdate.setPayeeBankName(reqBO.getRecvSubLedgerBankName());
                        fscMerchantPayeePoUpdate.setAccountNoType(reqBO.getAccountNoType());
                        fscMerchantPayeePoUpdate.setSysTenantId(reqBO.getSysTenantId());
                        fscMerchantPayeePoUpdate.setSysTenantName(reqBO.getSysTenantName());
                        this.fscMerchantPayeeMapper.insert(fscMerchantPayeePoUpdate);
                    }
                }
            }
        }
        return fscAccountEditBusiRspBO;
    }
}

