/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.busi.api.FscCancelOrderBySkuBusiService;
import com.tydic.fsc.common.busi.bo.FscCancelOrderBySkuBusiBO;
import com.tydic.fsc.common.busi.bo.FscCancelOrderBySkuBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscCancelOrderBySkuBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscCancelOrderBySkuReturnBusiBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscGoodsDeductionRecordItemMapper;
import com.tydic.fsc.dao.FscOrderCancelMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.po.FscGoodsDeductionRecordItemPO;
import com.tydic.fsc.po.FscOrderCancelPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscCancelOrderBySkuBusiServiceImpl
implements FscCancelOrderBySkuBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscCancelOrderBySkuBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderCancelMapper fscOrderCancelMapper;
    @Autowired
    private FscGoodsDeductionRecordItemMapper fscGoodsDeductionRecordItemMapper;

    @Override
    public FscCancelOrderBySkuBusiRspBO cancelOrderBySku(FscCancelOrderBySkuBusiReqBO reqBO) {
        FscCancelOrderBySkuBusiRspBO rspBO = new FscCancelOrderBySkuBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList<FscCancelOrderBySkuReturnBusiBO> returnBusiBOList = new ArrayList<FscCancelOrderBySkuReturnBusiBO>();
        List<FscCancelOrderBySkuBusiBO> fscCancelOrderBySkuBusiBOList = reqBO.getFscCancelOrderBySkuBusiBOList();
        Map<Long, List<FscCancelOrderBySkuBusiBO>> fscCancelOrderBySkuBusiBOListMap = fscCancelOrderBySkuBusiBOList.stream().collect(Collectors.groupingBy(FscCancelOrderBySkuBusiBO::getFscOrderId));
        log.info("fscCancelOrderBySkuBusiBOListMap======{}", (Object)JSON.toJSONString(fscCancelOrderBySkuBusiBOListMap));
        ArrayList<FscOrderCancelPO> logList = new ArrayList<FscOrderCancelPO>();
        ArrayList<FscGoodsDeductionRecordItemPO> fscGoodsDeductionRecordItemPOList = new ArrayList<FscGoodsDeductionRecordItemPO>();
        for (Map.Entry<Long, List<FscCancelOrderBySkuBusiBO>> entry : fscCancelOrderBySkuBusiBOListMap.entrySet()) {
            String id = ((Object)entry.getKey()).toString();
            List<FscCancelOrderBySkuBusiBO> tempList = entry.getValue();
            FscOrderPO updateDeductionAmountPO = new FscOrderPO();
            updateDeductionAmountPO.setFscOrderId(Long.valueOf(Long.parseLong(id)));
            BigDecimal totalAmount = tempList.stream().map(FscCancelOrderBySkuBusiBO::getCancelAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            log.info("totalAmount======{}", (Object)totalAmount);
            for (FscCancelOrderBySkuBusiBO item : tempList) {
                if (item.getIsWriteLog() == 1) {
                    FscGoodsDeductionRecordItemPO recordItemPO = new FscGoodsDeductionRecordItemPO();
                    recordItemPO.setGoodsDeductionId(Long.valueOf(Sequence.getInstance().nextId()));
                    recordItemPO.setCancelOrderNo(item.getOrderNo());
                    recordItemPO.setCancelOrderId(item.getOrderId());
                    recordItemPO.setCancelAcceptNo(item.getAcceptOrderNo());
                    recordItemPO.setCancelAcceptId(item.getAcceptOrderId());
                    recordItemPO.setCancelFscOrderId(item.getFscOrderId());
                    recordItemPO.setCancelFscOrderNo(item.getFscOrderNo());
                    recordItemPO.setSkuCode(item.getSkuNo());
                    recordItemPO.setSupplierId(item.getSupplierId());
                    recordItemPO.setSupplierName(item.getSupplierName());
                    recordItemPO.setSkuId(String.valueOf(item.getSkuId()));
                    recordItemPO.setSkuName(item.getSkuName());
                    recordItemPO.setUnit(item.getUnit());
                    recordItemPO.setPrice(item.getPrice());
                    recordItemPO.setTaxRate(item.getTaxRate());
                    recordItemPO.setCancelNum(new BigDecimal(item.getNum()));
                    recordItemPO.setCancelAmount(item.getCancelAmt());
                    recordItemPO.setCostTypeId(item.getCostTypeId());
                    recordItemPO.setCostTypeName(item.getCostTypeName());
                    recordItemPO.setPurchaseId(item.getPurchaseId());
                    recordItemPO.setPurchaseName(item.getPurchaseName());
                    recordItemPO.setCancelTime(new Date());
                    recordItemPO.setStatus(Integer.valueOf(0));
                    recordItemPO.setRemak(item.getCancelRemark());
                    recordItemPO.setCreateDate(new Date());
                    recordItemPO.setCreateOperUserId(reqBO.getUserId());
                    recordItemPO.setCreateOperUserName(reqBO.getUserName());
                    recordItemPO.setCreateOrgId(reqBO.getOrgId());
                    recordItemPO.setCreateOrgName(reqBO.getOrgName());
                    recordItemPO.setL1CatalogName(item.getL1CatalogName());
                    recordItemPO.setSysTenantId(reqBO.getSysTenantId());
                    recordItemPO.setSysTenantName(reqBO.getSysTenantName());
                    fscGoodsDeductionRecordItemPOList.add(recordItemPO);
                    log.info("\u4fdd\u5b58\u91c7\u8d2d\u7ed3\u7b97\u53d6\u6d88\u8bb0\u5f55\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)recordItemPO));
                    continue;
                }
                log.info("item======{}", (Object)JSON.toJSONString((Object)item));
                FscCancelOrderBySkuReturnBusiBO returnBusiBO = new FscCancelOrderBySkuReturnBusiBO();
                updateDeductionAmountPO.setOrderNum(Integer.valueOf(ObjectUtil.isEmpty((Object)updateDeductionAmountPO.getOrderNum()) ? item.getNum() : updateDeductionAmountPO.getOrderNum() + item.getNum()));
                updateDeductionAmountPO.setCancelAmount(ObjectUtil.isEmpty((Object)updateDeductionAmountPO.getCancelAmount()) ? item.getCancelAmount() : item.getCancelAmount().add(updateDeductionAmountPO.getCancelAmount()));
                updateDeductionAmountPO.setCancelOrderId(item.getOrderId().toString());
                updateDeductionAmountPO.setInvStatus(Integer.valueOf(1));
                if (totalAmount.compareTo(item.getTotalAmount()) == 0) {
                    updateDeductionAmountPO.setCancelOrderType(Integer.valueOf(1));
                    updateDeductionAmountPO.setOrderState(FscConstants.FscPayOrderState.CANCEL);
                } else {
                    updateDeductionAmountPO.setCancelOrderType(Integer.valueOf(0));
                }
                FscOrderCancelPO fscOrderCancelPO = new FscOrderCancelPO();
                fscOrderCancelPO.setFscOrderId(item.getFscOrderId());
                fscOrderCancelPO.setOrderId(item.getOrderId());
                fscOrderCancelPO.setAcceptOrderId(item.getAcceptOrderId());
                fscOrderCancelPO.setOperId(reqBO.getUserId().toString());
                fscOrderCancelPO.setOperName(reqBO.getName());
                fscOrderCancelPO.setOrderTotalCharge(item.getCancelAmount());
                fscOrderCancelPO.setCreateTime(new Date());
                fscOrderCancelPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                logList.add(fscOrderCancelPO);
                FscOrderRelationPO setRelationPO = new FscOrderRelationPO();
                FscOrderRelationPO where = new FscOrderRelationPO();
                setRelationPO.setUpdateOrderTotalCharge(item.getCancelAmount());
                where.setFscOrderId(item.getFscOrderId());
                where.setOrderId(item.getOrderId());
                where.setAcceptOrderId(item.getAcceptOrderId());
                if (!ObjectUtil.isEmpty((Object)where)) {
                    this.fscOrderRelationMapper.updateBy(setRelationPO, where);
                }
                FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
                fscOrderItemPO.setAmt(item.getCancelAmt());
                fscOrderItemPO.setUntaxAmt(item.getCancelUnTaxAmt());
                fscOrderItemPO.setTaxAmt(item.getTaxAmt());
                fscOrderItemPO.setFscOrderId(item.getFscOrderId());
                fscOrderItemPO.setOrderId(item.getOrderId());
                fscOrderItemPO.setAcceptOrderId(item.getAcceptOrderId());
                fscOrderItemPO.setSkuId(item.getSkuId());
                fscOrderItemPO.setNum(new BigDecimal(item.getNum()));
                this.fscOrderItemMapper.updateOldAmountBySkuId(fscOrderItemPO);
                this.fscOrderItemMapper.updateBySkuId(fscOrderItemPO);
                returnBusiBO.setInspId(item.getAcceptOrderId());
                returnBusiBO.setSkuId(item.getSkuId());
                returnBusiBO.setCancelAmount(item.getCancelAmount());
                returnBusiBO.setNum(item.getNum());
                returnBusiBOList.add(returnBusiBO);
            }
            if (tempList.get(0).getIsWriteLog() == 1) continue;
            log.info("\u53d6\u6d88\u8ba2\u5355\uff0c\u7ed3\u7b97\u5355\u66f4\u65b0\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)updateDeductionAmountPO));
            int updateDeductionAmountResultCount = this.fscOrderMapper.updateDeductionAmount(updateDeductionAmountPO);
            FscShouldPayPO set = new FscShouldPayPO();
            set.setShouldPayAmount(updateDeductionAmountPO.getCancelAmount());
            set.setToPayAmount(updateDeductionAmountPO.getCancelAmount());
            set.setOriginalAmount(updateDeductionAmountPO.getCancelAmount());
            set.setFscOrderId(updateDeductionAmountPO.getFscOrderId());
            log.info("\u53d6\u6d88\u8ba2\u5355\uff0c\u5e94\u4ed8\u66f4\u65b0\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)set));
            int updateDeductionAmountShouldPayResultCount = this.fscShouldPayMapper.updateDeductionAmount(set);
            if (ObjectUtil.isEmpty((Object)tempList.get(0).getPayOrderId())) continue;
            FscOrderPO fscOrderPo = new FscOrderPO();
            fscOrderPo.setFscOrderId(tempList.get(0).getPayOrderId());
            if ((fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo)).getOrderState().equals(FscConstants.FscPayOrderState.PAIED)) continue;
            FscOrderPO updatePayOrdertPO = new FscOrderPO();
            updatePayOrdertPO.setFscOrderId(tempList.get(0).getPayOrderId());
            updatePayOrdertPO.setCancelAmount(updateDeductionAmountPO.getCancelAmount());
            updatePayOrdertPO.setCancelOrderId(updateDeductionAmountPO.getCancelOrderId());
            updatePayOrdertPO.setOrderNum(updateDeductionAmountPO.getOrderNum());
            updatePayOrdertPO.setCancelOrderType(updateDeductionAmountPO.getCancelOrderType());
            updatePayOrdertPO.setInvStatus(Integer.valueOf(1));
            log.info("\u53d6\u6d88\u8ba2\u5355\uff0c\u4ed8\u6b3e\u5355\u66f4\u65b0\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)updateDeductionAmountPO));
            int resultCount = this.fscOrderMapper.updateDeductionAmount(updatePayOrdertPO);
            FscOrderCancelPO fscOrderCancelPO1 = new FscOrderCancelPO();
            fscOrderCancelPO1.setFscOrderId(tempList.get(0).getPayOrderId());
            fscOrderCancelPO1.setOrderId(Long.valueOf(Long.parseLong(updateDeductionAmountPO.getCancelOrderId())));
            fscOrderCancelPO1.setOperId(reqBO.getUserId().toString());
            fscOrderCancelPO1.setOperName(reqBO.getName());
            fscOrderCancelPO1.setOrderTotalCharge(updateDeductionAmountPO.getCancelAmount());
            fscOrderCancelPO1.setCreateTime(new Date());
            fscOrderCancelPO1.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderCancelPO1.setSysTenantId(reqBO.getSysTenantId());
            fscOrderCancelPO1.setSysTenantName(reqBO.getSysTenantName());
            logList.add(fscOrderCancelPO1);
        }
        if (!ObjectUtil.isEmpty(fscGoodsDeductionRecordItemPOList)) {
            this.fscGoodsDeductionRecordItemMapper.insertBatch(fscGoodsDeductionRecordItemPOList);
        }
        if (!ObjectUtil.isEmpty(logList)) {
            this.fscOrderCancelMapper.insertBatch(logList);
        }
        rspBO.setFscCancelOrderBySkuReturnBOList(returnBusiBOList);
        return rspBO;
    }
}

