/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscAccountCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscCreditBalanceInsertAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAccountAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAccountAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscCreditBalanceInsertAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscCreditBalanceInsertAtomRspBO;
import com.tydic.fsc.common.busi.api.FscMerchantCreateBusiService;
import com.tydic.fsc.common.busi.bo.FscMerchantCreateBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscMerchantCreateBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscSkuCategoryMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscSkuCategoryPO;
import com.tydic.umc.supplier.ability.api.UmcSupSignContractAbilityService;
import com.tydic.umc.supplier.ability.bo.UmcSupSalesCategoryListAbilityReqBO;
import com.tydic.umc.supplier.ability.bo.UmcSupSalesCategoryListAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="fscMerchantCreateBusiService")
public class FscMerchantCreateBusiServiceImpl
implements FscMerchantCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantCreateBusiServiceImpl.class);
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscSkuCategoryMapper fscSkuCategoryMapper;
    @Autowired
    private FscAccountCreateAtomService fscAccountCreateAtomService;
    @Autowired
    private FscCreditBalanceInsertAtomService fscCreditBalanceInsertAtomService;
    @Autowired
    private UmcSupSignContractAbilityService umcSupSignContractAbilityService;

    @Override
    public FscMerchantCreateBusiRspBo dealCreate(FscMerchantCreateBusiReqBO reqBo) {
        int result;
        FscMerchantPO merchantPo;
        FscMerchantCreateBusiRspBo retBo = new FscMerchantCreateBusiRspBo();
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        Date nowTime = this.fscMerchantMapper.getDBDate();
        FscMerchantPO queryReqBo = new FscMerchantPO();
        queryReqBo.setOrgId(reqBo.getOrgId());
        queryReqBo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        queryReqBo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
        FscMerchantPO mainMerchant = this.fscMerchantMapper.getModelBy(queryReqBo);
        FscAccountAtomReqBO accountAtomReqBo = new FscAccountAtomReqBO();
        accountAtomReqBo.setAccountName(reqBo.getOrgName());
        accountAtomReqBo.setAccountCategory(StringUtils.isEmpty((Object)reqBo.getMerchantCategory()) ? mainMerchant.getMerchantCategory() : reqBo.getMerchantCategory());
        accountAtomReqBo.setOrgId(reqBo.getOrgId());
        accountAtomReqBo.setOrgName(reqBo.getOrgName());
        accountAtomReqBo.setStatus(FscConstants.AccountStatus.VALID);
        accountAtomReqBo.setCreateMethod(FscConstants.AccountOpenMethod.AUTO);
        accountAtomReqBo.setCreateTime(nowTime);
        accountAtomReqBo.setCreateOperId(reqBo.getUserId().toString());
        FscAccountAtomRspBO accountAtomRetBo = this.fscAccountCreateAtomService.createAccount(accountAtomReqBo);
        if (!"0000".equals(accountAtomRetBo.getRespCode())) {
            throw new FscBusinessException("193120", "\u521b\u5efa\u8d26\u6237\u4fe1\u606f\u5931\u8d25\uff1a" + accountAtomRetBo.getRespDesc());
        }
        retBo.setId(Long.parseLong(accountAtomRetBo.getAccountId()));
        if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(reqBo.getExceptionFlag())) {
            if (null == mainMerchant) {
                throw new FscBusinessException("193120", "\u521b\u5efa\u4f8b\u5916\u4fe1\u606f\u5931\u8d25\uff1a\u6b64\u673a\u6784\u672a\u914d\u7f6e\u6709\u6548\u7684\u4e3b\u5546\u6237");
            }
            if ((FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_PAY.equals(reqBo.getExceptionCategory()) || FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MIX.equals(reqBo.getExceptionCategory())) && FscConstants.MerchantAllowException.NO.equals(mainMerchant.getPayAllowExceptionFlag())) {
                throw new FscBusinessException("193120", "\u6b64\u5546\u6237\u652f\u4ed8\u914d\u7f6e\u4e0d\u5141\u8bb8\u4f8b\u5916");
            }
            if ((FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MODEL.equals(reqBo.getExceptionCategory()) || FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MIX.equals(reqBo.getExceptionCategory())) && FscConstants.MerchantAllowException.NO.equals(mainMerchant.getModelAllowExceptionFlag())) {
                throw new FscBusinessException("193120", "\u6b64\u5546\u6237\u7ed3\u7b97\u6a21\u5f0f\u914d\u7f6e\u4e0d\u5141\u8bb8\u4f8b\u5916");
            }
            FscMerchantPO qryException = new FscMerchantPO();
            qryException.setOrgId(reqBo.getOrgId());
            qryException.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
            if (FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_PAY.equals(reqBo.getExceptionCategory())) {
                qryException.setPayObjId(reqBo.getPayObjId());
            } else if (FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MODEL.equals(reqBo.getExceptionCategory())) {
                qryException.setModelObjId(reqBo.getModelObjId());
            } else {
                qryException.setPayObjId(reqBo.getPayObjId());
                qryException.setModelObjId(reqBo.getModelObjId());
            }
            if (null != reqBo.getModelSceneRange()) {
                if (FscConstants.MerchantAllowException.NO.equals(mainMerchant.getModelAllowExceptionFlag())) {
                    throw new FscBusinessException("193120", "\u6b64\u5546\u6237\u7ed3\u7b97\u6a21\u5f0f\u914d\u7f6e\u4e0d\u5141\u8bb8\u4f8b\u5916");
                }
                qryException.setModelObjId(reqBo.getModelObjId());
            }
            if ((merchantPo = this.fscMerchantMapper.getModelBy(qryException)) != null) {
                merchantPo.setPayMerchantId(mainMerchant.getPayMerchantId());
            }
        } else {
            merchantPo = mainMerchant;
        }
        if (merchantPo != null) {
            if (!FscConstants.MerchantStatus.DRAFT.equals(merchantPo.getStatus())) {
                log.info("\u5df2\u5b58\u5728\u6709\u6548\u5546\u6237\uff1a\u673a\u6784ID:{}", (Object)reqBo.getOrgId());
                retBo.setRespCode("193120");
                retBo.setRespDesc("\u5df2\u5b58\u5728\u6709\u6548\u5546\u6237");
                return retBo;
            }
            if (FscConstants.MerchantStatus.DRAFT.equals(merchantPo.getStatus())) {
                int result2;
                BeanUtils.copyProperties((Object)((Object)reqBo), (Object)merchantPo);
                merchantPo.setUpdateOperId(reqBo.getUserId().toString());
                merchantPo.setUpdateOperName(reqBo.getName());
                merchantPo.setUpdateTime(nowTime);
                merchantPo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
                if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(merchantPo.getExceptionFlag()) && FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MODEL.equals(merchantPo.getExceptionCategory())) {
                    if (FscConstants.MerchantModelSceneRange.CATEGORY.equals(merchantPo.getModelSceneRange())) {
                        this.updateCategory(merchantPo.getMerchantId(), reqBo.getCategoryTrees(), reqBo);
                        merchantPo.setModelContractNo("-");
                        merchantPo.setModelContractName("-");
                    } else if (FscConstants.MerchantModelSceneRange.CONTRACT.equals(merchantPo.getModelSceneRange())) {
                        UmcSupSalesCategoryListAbilityReqBO umcSupSalesCategoryListAbilityReqBO = new UmcSupSalesCategoryListAbilityReqBO();
                        umcSupSalesCategoryListAbilityReqBO.setGetDetail(Integer.valueOf(1));
                        umcSupSalesCategoryListAbilityReqBO.setPageSize(Integer.valueOf(-1));
                        umcSupSalesCategoryListAbilityReqBO.setSignContractId(reqBo.getModelContractId());
                        UmcSupSalesCategoryListAbilityRspBO salesCategoryList = this.umcSupSignContractAbilityService.getSalesCategoryList(umcSupSalesCategoryListAbilityReqBO);
                        List<String> commodityTypeIds = salesCategoryList.getRows().stream().map(e -> e.getItemCatId().toString()).collect(Collectors.toList());
                        this.updateCategory(merchantPo.getMerchantId(), commodityTypeIds, reqBo);
                    }
                }
                if ((result2 = this.fscMerchantMapper.updateById(merchantPo)) < 1) {
                    throw new FscBusinessException("193120", "\u5546\u6237\u4fe1\u606f\u5165\u8868\u5931\u8d25");
                }
                retBo.setMerchantId(merchantPo.getMerchantId());
                if (null != merchantPo.getPayCreditAmount()) {
                    this.dealCreditBalance(merchantPo, reqBo);
                }
                return retBo;
            }
        }
        Long merchantId = Sequence.getInstance().nextId();
        String merchantNo = reqBo.getMerchantNo();
        if (StringUtils.isEmpty((Object)reqBo.getMerchantNo())) {
            String merchantIdStr = merchantId.toString();
            merchantNo = merchantIdStr.substring(merchantIdStr.length() - 4);
        }
        merchantPo = new FscMerchantPO();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)merchantPo);
        merchantPo.setMerchantId(merchantId);
        merchantPo.setMerchantNo(merchantNo);
        merchantPo.setCreateOperId(reqBo.getUserId().toString());
        merchantPo.setCreateOperName(reqBo.getName());
        merchantPo.setCreateTime(nowTime);
        merchantPo.setStatus(FscConstants.MerchantStatus.DRAFT);
        merchantPo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
        merchantPo.setAccountId(Long.valueOf(accountAtomRetBo.getAccountId()));
        if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(reqBo.getExceptionFlag()) && !StringUtils.isEmpty((Object)mainMerchant.getPayMerchantId())) {
            merchantPo.setPayMerchantId(mainMerchant.getPayMerchantId());
        }
        if ((result = this.fscMerchantMapper.insert(merchantPo)) < 1) {
            throw new FscBusinessException("193120", "\u5546\u6237\u4fe1\u606f\u5165\u8868\u5931\u8d25");
        }
        if (FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION.equals(merchantPo.getExceptionFlag()) && FscConstants.MerchantExceptionType.MERCHANT_EXCEPTION_TYPE_MODEL.equals(merchantPo.getExceptionCategory())) {
            if (FscConstants.MerchantModelSceneRange.CATEGORY.equals(merchantPo.getModelSceneRange())) {
                this.updateCategory(merchantId, reqBo.getCategoryTrees(), reqBo);
                merchantPo.setModelContractNo("-");
                merchantPo.setModelContractName("-");
            } else if (FscConstants.MerchantModelSceneRange.CONTRACT.equals(merchantPo.getModelSceneRange())) {
                UmcSupSalesCategoryListAbilityReqBO umcSupSalesCategoryListAbilityReqBO = new UmcSupSalesCategoryListAbilityReqBO();
                umcSupSalesCategoryListAbilityReqBO.setGetDetail(Integer.valueOf(1));
                umcSupSalesCategoryListAbilityReqBO.setPageSize(Integer.valueOf(-1));
                umcSupSalesCategoryListAbilityReqBO.setSignContractId(reqBo.getModelContractId());
                UmcSupSalesCategoryListAbilityRspBO salesCategoryList = this.umcSupSignContractAbilityService.getSalesCategoryList(umcSupSalesCategoryListAbilityReqBO);
                List<String> commodityTypeIds = salesCategoryList.getRows().stream().map(e -> e.getItemCatId().toString()).collect(Collectors.toList());
                this.updateCategory(merchantId, commodityTypeIds, reqBo);
            }
        }
        retBo.setMerchantId(merchantId);
        return retBo;
    }

    private void deleteCategory(Long merchantId) {
        FscSkuCategoryPO categoryPo = new FscSkuCategoryPO();
        categoryPo.setMerchantId(merchantId);
        this.fscSkuCategoryMapper.deleteBy(categoryPo);
    }

    private void updateCategory(Long merchantId, List<String> categoryTrees, FscMerchantCreateBusiReqBO reqBO) {
        FscSkuCategoryPO categoryPo = new FscSkuCategoryPO();
        categoryPo.setMerchantId(merchantId);
        this.fscSkuCategoryMapper.deleteBy(categoryPo);
        AtomicInteger result = new AtomicInteger();
        ArrayList list = new ArrayList();
        categoryTrees.forEach(item -> {
            FscSkuCategoryPO temp = new FscSkuCategoryPO();
            temp.setMerchantId(merchantId);
            temp.setCategoryTreePath(item);
            temp.setSysTenantId(reqBO.getSysTenantId());
            temp.setSysTenantName(reqBO.getSysTenantName());
            list.add(temp);
        });
        this.fscSkuCategoryMapper.insertBatch(list);
    }

    private void dealCreditBalance(FscMerchantPO merchantPo, FscMerchantCreateBusiReqBO reqBO) {
        FscCreditBalanceInsertAtomReqBO creditBalanceInsertAtomReqBO = new FscCreditBalanceInsertAtomReqBO();
        creditBalanceInsertAtomReqBO.setMerchantId(merchantPo.getMerchantId());
        creditBalanceInsertAtomReqBO.setPayCreditAmount(merchantPo.getPayCreditAmount());
        creditBalanceInsertAtomReqBO.setUsedAmount(BigDecimal.ZERO);
        creditBalanceInsertAtomReqBO.setUpdateOper(reqBO.getName());
        FscCreditBalanceInsertAtomRspBO rspBO = this.fscCreditBalanceInsertAtomService.dealCreditBalanceInsert(creditBalanceInsertAtomReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new FscBusinessException("193120", "\u5904\u7406\u6388\u4fe1\u51fa\u9519");
        }
    }
}

