/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.tydic.fsc.bo.FscMerchantPayeeBO;
import com.tydic.fsc.bo.FscMerchantPayeeChannelDataBO;
import com.tydic.fsc.busibase.atom.api.FscMerchantPayeeChannelAtomService;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeChannelAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscMerchantPayeeChannelAtomRspBO;
import com.tydic.fsc.busibase.external.api.pay.FscPayTransPayInsService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsReqBo;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsRspBo;
import com.tydic.fsc.common.ability.api.FscMerchantDetailQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscMerchantDetailQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscMerchantDetailQryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.dao.FscMerchantPayeeMapper;
import com.tydic.fsc.po.FscDicDictionaryPO;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.po.FscMerchantPayeePO;
import com.tydic.fsc.util.FscRspUtil;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscMerchantDetailQryAbilityService"})
public class FscMerchantDetailQryAbilityServiceImpl
implements FscMerchantDetailQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantDetailQryAbilityServiceImpl.class);
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private FscMerchantPayeeMapper fscMerchantPayeeMapper;
    @Autowired
    private FscMerchantPayeeChannelAtomService fscMerchantPayeeChannelAtomService;
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;
    @Autowired
    private FscPayTransPayInsService fscPayTransPayInsService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Value(value="${enabled.pingAn.account:true}")
    private Boolean enabledPingAnAccount;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryMerchantDetail"})
    public FscMerchantDetailQryAbilityRspBO qryMerchantDetail(@RequestBody FscMerchantDetailQryAbilityReqBO reqBO) {
        FscMerchantDetailQryAbilityRspBO retBo = (FscMerchantDetailQryAbilityRspBO)FscRspUtil.getRspBo((String)"191128", (String)"\u5931\u8d25", FscMerchantDetailQryAbilityRspBO.class);
        if (null == reqBO.getMerchantId() && null == reqBO.getMerchantOrgId()) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5546\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a\u5546\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
            return retBo;
        }
        FscMerchantPO merchantPo = new FscMerchantPO();
        merchantPo.setMerchantId(reqBO.getMerchantId());
        if (null != reqBO.getMerchantOrgId()) {
            merchantPo.setOrgId(reqBO.getMerchantOrgId());
            merchantPo.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
            merchantPo.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        }
        if (null == (merchantPo = this.fscMerchantMapper.getModelBy(merchantPo))) {
            log.error("\u6839\u636e\u5165\u53c2\uff1a{}\uff0c\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f", (Object)JSON.toJSONString((Object)reqBO));
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u6237\u4fe1\u606f");
            return retBo;
        }
        this.transMerchantInfo(retBo, merchantPo);
        FscMerchantPayeePO payeePo = new FscMerchantPayeePO();
        payeePo.setMerchantId(merchantPo.getMerchantId());
        ArrayList<String> accountNoTypeList = new ArrayList<String>();
        accountNoTypeList.add("3");
        if (this.enabledPingAnAccount.booleanValue()) {
            accountNoTypeList.add("2");
        } else {
            accountNoTypeList.add("1");
        }
        payeePo.setAccountNoTypeList(accountNoTypeList);
        payeePo = this.fscMerchantPayeeMapper.getModelBy(payeePo);
        if (null != payeePo) {
            FscMerchantPayeeBO payeeBo = new FscMerchantPayeeBO();
            BeanUtils.copyProperties((Object)payeePo, (Object)payeeBo);
            retBo.setPayeeInfo(payeeBo);
        }
        ArrayList<FscMerchantPayeeChannelDataBO> channels = new ArrayList();
        FscMerchantPayeeChannelAtomReqBO channelAtomReqBo = new FscMerchantPayeeChannelAtomReqBO();
        channelAtomReqBo.setMerchantId(merchantPo.getMerchantId());
        FscMerchantPayeeChannelAtomRspBO channelAtomRetBo = this.fscMerchantPayeeChannelAtomService.queryPayChannel(channelAtomReqBo);
        if ("0000".equals(channelAtomRetBo.getRespCode()) && !CollectionUtils.isEmpty((Collection)channelAtomRetBo.getPayChannels())) {
            channels = channelAtomRetBo.getPayChannels();
            this.transChannel(channels);
        }
        retBo.setMainChannels(channels);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        this.dealResult(retBo);
        return retBo;
    }

    private void dealResult(FscMerchantDetailQryAbilityRspBO retBo) {
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(retBo.getPayType())) {
            if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(retBo.getPayRule())) {
                retBo.setPayNodeAccountDays(null);
                retBo.setPayNodeRule(null);
                retBo.setPayNodeRuleStr(null);
            }
            if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(retBo.getPayRule())) {
                retBo.setPayAccountDay(null);
                retBo.setPayAccountDayRule(null);
                retBo.setPayAccountDayRuleStr(null);
            }
        } else {
            retBo.setPayCreditAmount(null);
            retBo.setPayBreakScale(null);
            retBo.setPayRuleStr(null);
            retBo.setPayRule(null);
            retBo.setPayAccountDay(null);
            retBo.setPayAccountDayRuleStr(null);
            retBo.setPayAccountDayRule(null);
            retBo.setPayNodeAccountDays(null);
            retBo.setPayNodeRuleStr(null);
            retBo.setPayNodeRule(null);
        }
    }

    private void transChannel(List<FscMerchantPayeeChannelDataBO> channels) {
        List paymentInsId = channels.stream().map(item -> Long.valueOf(item.getPayChannel())).collect(Collectors.toList());
        FscPayTransPayInsReqBo transReqBo = new FscPayTransPayInsReqBo();
        transReqBo.setPaymentInsId(paymentInsId);
        FscPayTransPayInsRspBo transRetBo = this.fscPayTransPayInsService.tranPayIns(transReqBo);
        if (!"0000".equals(transRetBo.getRespCode())) {
            return;
        }
        Map payInsMap = transRetBo.getPayInsMap();
        Map payMethodMap = transRetBo.getPayMethodMap();
        channels.forEach(channel -> {
            channel.setPayChannelStr((String)payInsMap.get(channel.getPayChannel()));
            String[] payMethodStr = channel.getPayMethod().split(",");
            StringBuilder payMethodBuilder = new StringBuilder();
            for (int i = 0; i < payMethodStr.length; ++i) {
                payMethodBuilder.append((String)payMethodMap.get(payMethodStr[i]));
                if (i == payMethodStr.length - 1) continue;
                payMethodBuilder.append(",");
            }
            channel.setPayMethodStr(payMethodBuilder.toString());
        });
    }

    private void transMerchantInfo(FscMerchantDetailQryAbilityRspBO retBo, FscMerchantPO merchantPo) {
        BeanUtils.copyProperties((Object)merchantPo, (Object)retBo);
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        retBo.setStatusStr(dicMap.get("MERCHANT_STATUS").get(retBo.getStatus().toString()));
        if (null != retBo.getMerchantCategory()) {
            retBo.setMerchantCategoryStr(dicMap.get("MERCHANT_CATEGORY").get(retBo.getMerchantCategory().toString()));
            retBo.setMerchantTypeStr(dicMap.get("MERCHANT_TYPE").get(retBo.getMerchantType().toString()));
        }
        if (null != retBo.getExceptionUserLatitude()) {
            retBo.setExceptionUserLatitudeStr(dicMap.get("MERCHANT_EXCEPTION_LATITUDE").get(retBo.getExceptionUserLatitude().toString()));
        }
        if (!StringUtils.isEmpty((Object)retBo.getPayBusiSceneRange())) {
            String[] range = retBo.getPayBusiSceneRange().split(",");
            StringBuilder rangeStr = new StringBuilder();
            for (int i = 0; i < range.length; ++i) {
                rangeStr.append(dicMap.get("MERCHANT_BUSI_SCENE").get(range[i]));
                if (i == range.length - 1) continue;
                rangeStr.append(",");
            }
            retBo.setPayBusiSceneRangeStr(rangeStr.toString());
            if (null != retBo.getPayUserIdentity()) {
                retBo.setPayUserIdentityStr(dicMap.get("MERCHANT_IDENTITY").get(retBo.getPayUserIdentity().toString()));
            }
            if (null != retBo.getPayAllowExceptionFlag()) {
                retBo.setPayAllowExceptionFlagStr(dicMap.get("MERCHANT_ALLOW_EXCEPTION").get(retBo.getPayAllowExceptionFlag().toString()));
            }
            retBo.setPayTypeStr(dicMap.get("MERCHANT_PAY_TYPE").get(retBo.getPayType().toString()));
            if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(retBo.getPayType())) {
                retBo.setPayRuleStr(dicMap.get("MERCHANT_PAY_RULE").get(retBo.getPayRule().toString()));
                if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(retBo.getPayRule())) {
                    retBo.setPayAccountDayRuleStr(dicMap.get("MERCHANT_DAY_RULE").get(retBo.getPayAccountDayRule().toString()));
                }
                if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(retBo.getPayRule())) {
                    retBo.setPayNodeRuleStr(dicMap.get("MERCHANT_NODE_RULE").get(retBo.getPayNodeRule().toString()));
                }
            }
        }
        if (null != retBo.getModelSceneRange()) {
            retBo.setModelSceneRangeStr(dicMap.get("MERCHANT_SCENE_RANGE").get(retBo.getModelSceneRange().toString()));
            if (null != retBo.getModelUserIdentity()) {
                retBo.setModelUserIdentityStr(dicMap.get("MERCHANT_MODEL_IDENTITY").get(retBo.getModelUserIdentity().toString()));
                retBo.setModelAllowExceptionFlagStr(dicMap.get("MERCHANT_MODEL_ALLOW_EXCEPTION").get(retBo.getModelAllowExceptionFlag().toString()));
            }
            retBo.setModelSettleStr(dicMap.get("MERCHANT_MODEL_SETTLE").get(retBo.getModelSettle().toString()));
        }
    }

    private Map<String, Map<String, String>> getDicMap() {
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("MERCHANT_STATUS");
        codes.add("MERCHANT_CATEGORY");
        codes.add("MERCHANT_TYPE");
        codes.add("MERCHANT_BUSI_SCENE");
        codes.add("MERCHANT_IDENTITY");
        codes.add("MERCHANT_ALLOW_EXCEPTION");
        codes.add("MERCHANT_PAY_TYPE");
        codes.add("MERCHANT_PAY_RULE");
        codes.add("MERCHANT_DAY_RULE");
        codes.add("MERCHANT_NODE_RULE");
        codes.add("MERCHANT_SCENE_RANGE");
        codes.add("MERCHANT_MODEL_IDENTITY");
        codes.add("MERCHANT_MODEL_ALLOW_EXCEPTION");
        codes.add("MERCHANT_MODEL_SETTLE");
        codes.add("MERCHANT_EXCEPTION_LATITUDE");
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        FscDicDictionaryPO queryPo = new FscDicDictionaryPO();
        queryPo.setSysCode("FSC");
        for (String pCode : codes) {
            queryPo.setPCode(pCode);
            List dicDictionaryPos = this.fscDicDictionaryMapper.getListByCondition(queryPo);
            Map<String, String> map = dicDictionaryPos.stream().collect(Collectors.toMap(FscDicDictionaryPO::getCode, fscDicDictionaryPO -> fscDicDictionaryPO.getTitle()));
            dicMap.put(pCode, map);
        }
        return dicMap;
    }
}

