/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CrcQryPaymentBehalfAbilityService;
import com.tydic.cfc.ability.bo.CfcPaymentBehalfBO;
import com.tydic.cfc.ability.bo.CrcQryPaymentBehalfAbilityReqBO;
import com.tydic.cfc.ability.bo.CrcQryPaymentBehalfAbilityRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityReqBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscAuditMergeWriteOffBankFileBusiService;
import com.tydic.fsc.common.busi.bo.FscAuditMergeWriteOffBankFileBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscAuditMergeWriteOffBankFileBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscAuditMergeWriteOffBankFileBusiServiceImpl
implements FscAuditMergeWriteOffBankFileBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAuditMergeWriteOffBankFileBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscWriteOffItemMapper fscWriteOffItemMapper;
    @Autowired
    private CrcQryPaymentBehalfAbilityService crcQryPaymentBehalfAbilityService;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Value(value="${opertionWithdrawalOrgId}")
    private Long opertionWithdrawalOrgId;

    @Override
    public FscAuditMergeWriteOffBankFileBusiRspBO auditMergeWriteOffBankFile(FscAuditMergeWriteOffBankFileBusiReqBO reqBO) {
        FscAuditMergeWriteOffBankFileBusiRspBO rspBO = new FscAuditMergeWriteOffBankFileBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<String> payRequestClaimNoList = reqBO.getPayRequestClaimNoList();
        ArrayList<FscBalancePO> fscBalancePOList = new ArrayList<FscBalancePO>();
        ArrayList<FscWriteOffItemPO> writeOffItemPOList = new ArrayList<FscWriteOffItemPO>();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        ArrayList<FscOrderPO> batchUpdateFscOrderPOList = new ArrayList<FscOrderPO>();
        for (String string : payRequestClaimNoList) {
            log.info("\u5f53\u524d\u4ed8\u6b3e\u5355ppm\u5355\u53f7:{}", (Object)string);
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setPayRequestClaimNo(string);
            List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
            if (ObjectUtil.isEmpty((Object)fscOrderPOList)) {
                log.info("\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u6570\u636e\uff1appm\u5355\u53f7\uff1a{}", (Object)string);
                continue;
            }
            BigDecimal totalCharge = fscOrderPOList.stream().map(FscOrderPO::getTotalCharge).reduce(BigDecimal.ZERO, BigDecimal::add);
            List<Long> toPayPayerIds = this.getPaymentBehalf(((FscOrderPO)fscOrderPOList.get(0)).getPayerId(), ((FscOrderPO)fscOrderPOList.get(0)).getSecondOrgId());
            Long payerId = ((FscOrderPO)fscOrderPOList.get(0)).getPayerId();
            String payerName = ((FscOrderPO)fscOrderPOList.get(0)).getPayerName();
            String payeeName = ((FscOrderPO)fscOrderPOList.get(0)).getPayeeName();
            String payeeAccountName = ((FscOrderPO)fscOrderPOList.get(0)).getPayeeAccountName();
            Long payeeId = ((FscOrderPO)fscOrderPOList.get(0)).getPayeeId();
            toPayPayerIds.add(payerId);
            FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
            fscBankCheckFileItemPO.setPayerIds(toPayPayerIds);
            fscBankCheckFileItemPO.setPayeeId(payeeId);
            fscBankCheckFileItemPO.setTradeAmt(totalCharge);
            fscBankCheckFileItemPO.setWriteOffFlag("0");
            List fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getList(fscBankCheckFileItemPO);
            if (ObjectUtil.isEmpty((Object)fscBankCheckFileItemPOList)) {
                log.info("\u672a\u67e5\u8be2\u5230\u94f6\u884c\u6d41\u6c34\u6570\u636e\uff1appm\u5355\u53f7\uff1a{}", (Object)string);
                continue;
            }
            FscBankCheckFileItemPO fileItemPO = (FscBankCheckFileItemPO)fscBankCheckFileItemPOList.get(0);
            for (FscOrderPO item2 : fscOrderPOList) {
                FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
                fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
                fscWriteOffItemPO.setFscOrderId(item2.getFscOrderId());
                fscWriteOffItemPO.setBankCheckId(fileItemPO.getBankCheckId());
                fscWriteOffItemPO.setWriteOffType(FscConstants.FSC_WRITE_OFF_TYPE.PAY_ORDER);
                fscWriteOffItemPO.setCreateTime(new Date());
                fscWriteOffItemPO.setCreateOperUserId(Long.valueOf(0L));
                fscWriteOffItemPO.setCreateOperUserName("admin");
                fscWriteOffItemPO.setSysTenantId(reqBO.getSysTenantId());
                fscWriteOffItemPO.setSysTenantName(reqBO.getSysTenantName());
                if (payerId.equals(((FscBankCheckFileItemPO)fscBankCheckFileItemPOList.get(0)).getPayerId())) {
                    fscWriteOffItemPO.setMemo("\u81ea\u52a8\u6838\u9500\uff08\u4ed8\u6b3e\u5355\u5408\u5e76\u4ed8\u6b3e\uff09");
                } else {
                    fscWriteOffItemPO.setMemo("\u81ea\u52a8\u6838\u9500\uff08\u4ed8\u6b3e\u5355\u5408\u5e76\u4ed8\u6b3e\uff09\uff0c\u4ee3\u4ed8\u6b3e");
                }
                writeOffItemPOList.add(fscWriteOffItemPO);
                fscOrderIds.add(item2.getFscOrderId());
                FscOrderPO updateOrderPo = new FscOrderPO();
                updateOrderPo.setFscOrderId(item2.getFscOrderId());
                if (null != reqBO.getUserId()) {
                    updateOrderPo.setPayOperId(reqBO.getUserId().toString());
                }
                updateOrderPo.setPayOperName(reqBO.getName());
                updateOrderPo.setPayTime(new Date());
                updateOrderPo.setPayState(FscConstants.PayOrderPayStatus.PAIED);
                updateOrderPo.setOrderState(FscConstants.FscPayOrderState.PAIED);
                updateOrderPo.setActualAmount(item2.getTotalCharge());
                updateOrderPo.setUpdateTime(new Date());
                updateOrderPo.setUpdateOperId("0");
                updateOrderPo.setUpdateOperName("admin");
                log.info("\u66f4\u65b0\u4ed8\u6b3e\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)updateOrderPo));
                batchUpdateFscOrderPOList.add(updateOrderPo);
            }
            if (this.opertionWithdrawalOrgId.equals(payeeId)) continue;
            FscBalancePO fscBalancePO = new FscBalancePO();
            fscBalancePO.setBalanceId(Long.valueOf(Sequence.getInstance().nextId()));
            fscBalancePO.setBankCheckId(fileItemPO.getBankCheckId());
            fscBalancePO.setOrgId(payeeId);
            fscBalancePO.setOrgCode("");
            fscBalancePO.setOrgName(payeeName);
            fscBalancePO.setSubAccountNo(fileItemPO.getPayeeAccountNo());
            fscBalancePO.setPayerOrgId(payerId);
            fscBalancePO.setPayerOrgName(payerName);
            fscBalancePO.setPayerOrgCode(null);
            fscBalancePO.setPayerSubAccountNo(null);
            fscBalancePO.setFrozenEndTime(this.getConfiguration(payeeId.toString()));
            fscBalancePO.setCreateTime(new Date());
            fscBalancePO.setPayAmount(totalCharge);
            if (fscBalancePO.getFrozenEndTime().compareTo(new Date()) <= 0) {
                fscBalancePO.setFrozenAmount(new BigDecimal(0));
                fscBalancePO.setUsableAmount(totalCharge);
                fscBalancePO.setThawOperTime(new Date());
            } else {
                fscBalancePO.setFrozenAmount(totalCharge);
                fscBalancePO.setUsableAmount(new BigDecimal(0));
            }
            fscBalancePO.setUsedAmount(new BigDecimal(0));
            fscBalancePO.setSysTenantId(reqBO.getSysTenantId());
            fscBalancePO.setSysTenantName(reqBO.getSysTenantName());
            fscBalancePOList.add(fscBalancePO);
        }
        if (!CollectionUtils.isEmpty(writeOffItemPOList)) {
            this.fscWriteOffItemMapper.insertBatch(writeOffItemPOList);
        }
        if (!ObjectUtil.isEmpty(fscOrderIds)) {
            int row = this.fscOrderMapper.batchUpdate(batchUpdateFscOrderPOList);
            for (Long id : fscOrderIds) {
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(id);
                fscComOrderListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
                fscComOrderListSyncAbilityReqBO.setSysTenantName(reqBO.getSysTenantName());
                this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
                this.syncOrderStatus(id, reqBO.getSysTenantId());
            }
        }
        if (!CollectionUtils.isEmpty(writeOffItemPOList)) {
            List bankCheckItemIds = writeOffItemPOList.stream().map(FscWriteOffItemPO::getBankCheckId).collect(Collectors.toList());
            FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
            fscBankCheckFileItemPO.setWriteOffFlag("1");
            fscBankCheckFileItemPO.setUpdateTime(new Date());
            fscBankCheckFileItemPO.setBankCheckIdS(bankCheckItemIds);
            this.fscBankCheckFileItemMapper.updateWriteOffFlagByBankCheckIds(fscBankCheckFileItemPO);
        }
        if (!CollectionUtils.isEmpty(fscBalancePOList)) {
            List list = fscBalancePOList.stream().collect(Collectors.toMap(FscBalancePO::getBankCheckId, item -> item, (oldValue, newValue) -> oldValue)).values().stream().collect(Collectors.toList());
            log.info("\u53bb\u91cd\u540e\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(list));
            this.fscBalanceMapper.insertBatch(list);
        }
        return rspBO;
    }

    private List<Long> getPaymentBehalf(Long purId, Long subId) {
        ArrayList<Long> toPayPayerIds = new ArrayList<Long>();
        CrcQryPaymentBehalfAbilityReqBO crcQryPaymentBehalfAbilityReqBO = new CrcQryPaymentBehalfAbilityReqBO();
        crcQryPaymentBehalfAbilityReqBO.setCorporationId(purId);
        crcQryPaymentBehalfAbilityReqBO.setOrgIdWeb(subId);
        log.info("\u67e5\u8be2\u4ee3\u4ed8\u914d\u7f6e\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)crcQryPaymentBehalfAbilityReqBO));
        CrcQryPaymentBehalfAbilityRspBO crcQryPaymentBehalfAbilityRspBO = this.crcQryPaymentBehalfAbilityService.qryPaymentBehalf(crcQryPaymentBehalfAbilityReqBO);
        log.info("\u67e5\u8be2\u4ee3\u4ed8\u914d\u7f6e\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)crcQryPaymentBehalfAbilityRspBO));
        if (!"0000".equals(crcQryPaymentBehalfAbilityRspBO.getRespCode())) {
            throw new FscBusinessException("193203", "\u67e5\u8be2\u4ee3\u4ed8\u914d\u7f6e\u9519\u8bef");
        }
        if (!ObjectUtil.isEmpty((Object)crcQryPaymentBehalfAbilityRspBO.getCfcPaymentBehalfBOS())) {
            List cfcPaymentBehalfBOS = crcQryPaymentBehalfAbilityRspBO.getCfcPaymentBehalfBOS().stream().filter(o -> o.getFreezeFlag().equals(FscConstants.CONFIG_STATUS_TO_PAY.NO)).collect(Collectors.toList());
            List paymentIds = cfcPaymentBehalfBOS.stream().map(CfcPaymentBehalfBO::getPaymentId).collect(Collectors.toList());
            toPayPayerIds.addAll(paymentIds);
        }
        return toPayPayerIds;
    }

    private Date getConfiguration(String relId) {
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(new Date());
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("cash_withdrawal");
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(relId);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        Integer advanceUnfreezeDays = 0;
        Integer paymentDays = 0;
        Integer advanceWarningDays = 0;
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays())) {
            advanceUnfreezeDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays())) {
            paymentDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays())) {
            advanceWarningDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays());
        }
        curDate.add(5, paymentDays - advanceUnfreezeDays);
        return curDate.getTime();
    }

    private void syncOrderStatus(Long fscPayOrderId, Long sysTenantId) {
        List fscShouldPayPOList = this.fscShouldPayMapper.getByFscOrderId(fscPayOrderId, sysTenantId);
        Map<Long, FscShouldPayPO> fscShouldPayPOMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getObjectId, FscShouldPayPO2 -> FscShouldPayPO2));
        if (CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            return;
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderIds(fscShouldPayPOList.stream().map(FscShouldPayPO::getObjectId).collect(Collectors.toList()));
        List orderList = this.fscOrderMapper.getList(fscOrderPo);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return;
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderIds(orderList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList()));
        List fscOrderRelationPOs = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (!CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            FscUocProOrderPaymentCallbackAbilityReqBO fscUocProOrderPaymentCallbackAbilityReqBO = new FscUocProOrderPaymentCallbackAbilityReqBO();
            fscUocProOrderPaymentCallbackAbilityReqBO.setUocPaymentCallbackBOS(fscOrderRelationPOs.stream().map(fscPaySuccessCallBackOrderBO -> {
                FscUocProOrderPaymentCallbackAbilityBO fscUocProOrderPaymentCallbackAbilityBO = new FscUocProOrderPaymentCallbackAbilityBO();
                fscUocProOrderPaymentCallbackAbilityBO.setSaleOrderId(fscPaySuccessCallBackOrderBO.getOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setObjectId(fscPaySuccessCallBackOrderBO.getAcceptOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setPayerType(FscConstants.FscOrderReceiveType.PURCHASE.equals(((FscOrderPO)orderList.get(0)).getReceiveType()) ? "pur" : "pro");
                fscUocProOrderPaymentCallbackAbilityBO.setPayMod(Integer.valueOf(30));
                fscUocProOrderPaymentCallbackAbilityBO.setPayResult(Boolean.valueOf(true));
                fscUocProOrderPaymentCallbackAbilityBO.setShouldPayMoney(fscPaySuccessCallBackOrderBO.getOrderTotalCharge());
                fscUocProOrderPaymentCallbackAbilityBO.setFscShouldPayId(((FscShouldPayPO)fscShouldPayPOMap.get(fscPaySuccessCallBackOrderBO.getFscOrderId())).getShouldPayId());
                return fscUocProOrderPaymentCallbackAbilityBO;
            }).collect(Collectors.toList()));
            this.fscUocProOrderPaymentCallbackAbilityService.dealOrderPaymentCallback(fscUocProOrderPaymentCallbackAbilityReqBO);
        }
    }
}

