/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankWithdrawCashService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankBindBankAccountRspBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankWithdrawCashReqBO;
import com.tydic.fsc.common.busi.api.FscComBalanceWithdrawalBusiService;
import com.tydic.fsc.common.busi.bo.FscComBalanceWithdrawalBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComBalanceWithdrawalBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.dao.FscWithdrawalLogItemMapper;
import com.tydic.fsc.dao.FscWithdrawalLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscLegalCompanyPO;
import com.tydic.fsc.po.FscWithdrawalLogItemPO;
import com.tydic.fsc.po.FscWithdrawalLogPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class FscComBalanceWithdrawalBusiServiceImpl
implements FscComBalanceWithdrawalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComBalanceWithdrawalBusiServiceImpl.class);
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;
    @Autowired
    private FscWithdrawalLogMapper fscWithdrawalLogMapper;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscBToBPingAnBankWithdrawCashService fscBToBPingAnBankWithdrawCashService;
    @Autowired
    private FscWithdrawalLogItemMapper fscWithdrawalLogItemMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FscComBalanceWithdrawalBusiRspBO balanceWithdrawal(FscComBalanceWithdrawalBusiReqBO reqBO) {
        FscBalancePO selectFscBalancePO = new FscBalancePO();
        selectFscBalancePO.setOrgId(reqBO.getOrgId());
        if (!ObjectUtil.isEmpty((Object)reqBO.getRecvSubLedgerAcctNo())) {
            selectFscBalancePO.setSubAccountNo(reqBO.getRecvSubLedgerAcctNo().toString());
        }
        selectFscBalancePO.setBankCheckIds(reqBO.getBankCheckIds());
        Long orgId = reqBO.getOrgId();
        log.debug("\u67e5\u8be2\u8d26\u6237\u673a\u6784id\u4e3a:{}", (Object)orgId);
        log.info("\u67e5\u8be2\u8be5\u8d26\u6237\u4f59\u989d\u5165\u53c2\u4e3a:{}", (Object)JSON.toJSONString((Object)selectFscBalancePO));
        List fscBalancePOList = this.fscBalanceMapper.getByOrgIdAnPayeeAccount(selectFscBalancePO);
        log.debug("\u67e5\u8be2\u5230\u7684\u4f59\u989d\u4fe1\u606f\u4e3a:{}", (Object)fscBalancePOList);
        if (CollectionUtils.isEmpty((Collection)fscBalancePOList)) {
            throw new FscBusinessException("198888", "\u8be5\u8d26\u6237\u76ee\u524d\u6ca1\u6709\u4f59\u989d\u4fe1\u606f\u6570\u636e");
        }
        FscAccountPO queryAccount = new FscAccountPO();
        queryAccount.setAccountNo(reqBO.getAccountNo());
        if (!ObjectUtil.isEmpty((Object)reqBO.getRecvSubLedgerAcctNo())) {
            queryAccount.setRecvSubLedgerAcctNo(reqBO.getRecvSubLedgerAcctNo().toString());
        }
        queryAccount.setOrgId(orgId);
        queryAccount.setStatus(FscConstants.AccountStatus.VALID);
        FscAccountPO fscAccountPO = this.fscAccountMapper.getModelBy(queryAccount);
        log.debug("\u67e5\u8be2\u7684\u8d26\u6237\u4fe1\u606f\u4e3a:{}", (Object)fscAccountPO);
        if (fscAccountPO == null) {
            throw new FscBusinessException("191103", "\u63d0\u73b0\u8d26\u6237\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
        }
        if (!FscConstants.AccountStatus.FAIL.equals(fscAccountPO.getB2bStatus())) {
            throw new FscBusinessException("198888", "\u63d0\u73b0\u8d26\u6237\u72b6\u6001\u5f02\u5e38,\u8bf7\u5f00\u901a\u6536\u6b3e\u529f\u80fd");
        }
        FscLegalCompanyPO fscLegalCompanyPO = this.fscLegalCompanyMapper.getById(orgId);
        log.debug("\u5b50\u8d26\u6237\u4fe1\u606f\u67e5\u8be2\u7ed3\u679c\u4e3a:{}", (Object)fscLegalCompanyPO);
        if (fscLegalCompanyPO == null) {
            throw new FscBusinessException("198888", "\u63d0\u73b0\u5b50\u8d26\u6237\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        Integer status = fscLegalCompanyPO.getStatus();
        if (!FscConstants.MerchantStatus.VALID.equals(status)) {
            throw new FscBusinessException("198888", "\u63d0\u73b0\u5b50\u8d26\u6237\u8d26\u53f7\u72b6\u6001\u5f02\u5e38");
        }
        BigDecimal totalUsableAmount = BigDecimal.ZERO;
        for (FscBalancePO fscBalancePO : fscBalancePOList) {
            totalUsableAmount = totalUsableAmount.add(fscBalancePO.getUsableAmount());
        }
        BigDecimal reqUseAmount = reqBO.getUseAmount();
        if (reqUseAmount.compareTo(totalUsableAmount) != 0) {
            throw new FscBusinessException("198888", "\u63d0\u73b0\u91d1\u989d\u8d85\u51fa\u9650\u5236,\u6700\u5927\u53ef\u91d1\u989d\u4e3a:" + totalUsableAmount + "\u5143");
        }
        Date dateTime = new Date();
        log.debug("\u5f53\u524d\u65f6\u95f4\u4e3a:{}", (Object)dateTime);
        FscBalancePO set = new FscBalancePO();
        set.setOperId(reqBO.getUserId());
        set.setOperName(reqBO.getName());
        set.setWithdrawalTime(dateTime);
        this.fscBalanceMapper.updateUsedAmountByBankId(fscBalancePOList, set);
        log.info("\u5f00\u59cb\u8c03\u53d6\u94f6\u884c\u63d0\u73b0\u63a5\u53e3!");
        FscBToBPingAnBankWithdrawCashReqBO bankWithdrawCashReqBO = new FscBToBPingAnBankWithdrawCashReqBO();
        bankWithdrawCashReqBO.setTranWebName(reqBO.getOrgName());
        bankWithdrawCashReqBO.setSubAcctNo(fscLegalCompanyPO.getSubAccountNo());
        bankWithdrawCashReqBO.setMemberGlobalType(fscAccountPO.getLegalCertType() == null ? "" : fscAccountPO.getLegalCertType() + "");
        bankWithdrawCashReqBO.setMemberGlobalId(fscAccountPO.getLegalCertNo());
        bankWithdrawCashReqBO.setTranNetMemberCode(reqBO.getOrgId() == null ? "" : reqBO.getOrgId() + "");
        bankWithdrawCashReqBO.setMemberName(fscAccountPO.getLegalName());
        bankWithdrawCashReqBO.setTakeCashAcctNo(fscAccountPO.getAccountNo());
        bankWithdrawCashReqBO.setOutAmtAcctName(fscAccountPO.getAccountName());
        bankWithdrawCashReqBO.setCcy("RMB");
        bankWithdrawCashReqBO.setCashAmt(reqBO.getUseAmount() + "");
        log.debug("\u8c03\u53d6\u94f6\u884c\u63d0\u73b0\u4e1a\u52a1\u5165\u53c2:{}", (Object)bankWithdrawCashReqBO);
        FscBToBPingAnBankBindBankAccountRspBO bankBindBankAccountRspBO = this.fscBToBPingAnBankWithdrawCashService.withdrawCash(bankWithdrawCashReqBO);
        if (!"0000".equals(bankBindBankAccountRspBO.getRespCode())) {
            throw new FscBusinessException("198888", bankBindBankAccountRspBO.getRespDesc());
        }
        log.debug("\u8c03\u53d6\u94f6\u884c\u63d0\u73b0\u64cd\u4f5c\u7ed3\u679c\u4e3a:{}", (Object)bankBindBankAccountRspBO);
        String frontSeqNo = null;
        if (bankWithdrawCashReqBO != null) {
            frontSeqNo = bankBindBankAccountRspBO.getFrontSeqNo();
        }
        log.info("\u8c03\u53d6\u94f6\u884c\u63d0\u73b0\u63a5\u53e3\u7ed3\u675f!");
        FscWithdrawalLogPO fscWithdrawalLogPO = new FscWithdrawalLogPO();
        Long cnsmrSeqNo = Sequence.getInstance().nextId();
        Long thirdVoucher = Sequence.getInstance().nextId();
        fscWithdrawalLogPO.setId(cnsmrSeqNo).setOrgId(reqBO.getOrgId()).setOrgName(reqBO.getOrgName()).setAccountId(fscAccountPO.getId()).setAccountNo(fscAccountPO.getAccountNo()).setAccountName(fscAccountPO.getAccountName()).setSubAccountNo(fscLegalCompanyPO.getSubAccountNo()).setDepositBankName(fscAccountPO.getDepositBankName()).setUsedAmount(reqBO.getUseAmount()).setFrontSeqNo(frontSeqNo).setCreateTime(dateTime).setAccountNoType(fscAccountPO.getAccountNoType()).setTransferFee(new BigDecimal("0")).setOperId(reqBO.getUserId()).setOperName(reqBO.getName());
        fscWithdrawalLogPO.setSysTenantId(reqBO.getSysTenantId());
        fscWithdrawalLogPO.setSysTenantName(reqBO.getSysTenantName());
        log.debug("\u5373\u5c06\u6dfb\u52a0\u63d0\u73b0\u8bb0\u5f55:{}", (Object)fscWithdrawalLogPO);
        int insertRows = this.fscWithdrawalLogMapper.insert(fscWithdrawalLogPO);
        if (insertRows != 1) {
            throw new FscBusinessException("198888", "\u7cfb\u7edf\u5f02\u5e38,\u63d0\u73b0\u8bb0\u5f55\u6570\u636e\u6dfb\u52a0\u5f02\u5e38!");
        }
        ArrayList<FscWithdrawalLogItemPO> logItemPOlist = new ArrayList<FscWithdrawalLogItemPO>();
        for (FscBalancePO fscBalancePO : fscBalancePOList) {
            FscWithdrawalLogItemPO withdrawalLogItemPO = new FscWithdrawalLogItemPO();
            withdrawalLogItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            withdrawalLogItemPO.setWithdrawalLogId(cnsmrSeqNo);
            withdrawalLogItemPO.setBankCheckId(fscBalancePO.getBankCheckId());
            withdrawalLogItemPO.setOrgId(fscBalancePO.getOrgId());
            withdrawalLogItemPO.setAccountNo(reqBO.getAccountNo());
            withdrawalLogItemPO.setUsedAmount(fscBalancePO.getUsableAmount());
            withdrawalLogItemPO.setTransferFee(BigDecimal.ZERO);
            withdrawalLogItemPO.setCreateTime(dateTime);
            withdrawalLogItemPO.setOperId(reqBO.getUserId());
            withdrawalLogItemPO.setOperName(reqBO.getName());
            withdrawalLogItemPO.setSysTenantId(reqBO.getSysTenantId());
            withdrawalLogItemPO.setSysTenantName(reqBO.getSysTenantName());
            logItemPOlist.add(withdrawalLogItemPO);
        }
        this.fscWithdrawalLogItemMapper.insertBatch(logItemPOlist);
        FscComBalanceWithdrawalBusiRspBO rspBO = new FscComBalanceWithdrawalBusiRspBO();
        rspBO.setFrontSeqNo(frontSeqNo);
        rspBO.setRespCode("0000");
        rspBO.setBankCheckIds(reqBO.getBankCheckIds());
        rspBO.setRespDesc("\u63d0\u73b0\u64cd\u4f5c\u6210\u529f!");
        return rspBO;
    }
}

