/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscAuditOrderCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscGeneralBusiRuleExecAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscGeneralBusiRuleExecAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscGeneralBusiRuleExecAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayShouldPayCreateAtomRspBO;
import com.tydic.fsc.common.busi.api.FscComOrderConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderConfirmBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderAdjustProcessMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderAdjustProcessPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscComOrderConfirmBusiServiceImpl
implements FscComOrderConfirmBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderConfirmBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscPayShouldPayCreateAtomService fscPayShouldPayCreateAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderAdjustProcessMapper fscOrderAdjustProcessMapper;
    @Autowired
    private FscGeneralBusiRuleExecAtomService fscGeneralBusiRuleExecAtomService;
    @Autowired
    private FscAuditOrderCreateAtomService fscAuditOrderCreateAtomService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    @Value(value="${no.need.audit.key :noNeedAudit}")
    private String noNeedAudit;
    @Value(value="${process.sysCode}")
    private String processSysCode;
    public static final String BUSI_NAME = "\u4e3b\u5355\u786e\u8ba4";
    public static final String BUSI_CODE = "1005";

    @Override
    public FscComOrderConfirmBusiRspBO dealOrderConfirm(FscComOrderConfirmBusiReqBO reqBO) {
        FscOrderPO where;
        FscOrderPO set;
        if (!"0".equals(reqBO.getIsprofess()) && !"2".equals(reqBO.getIsprofess())) {
            throw new FscBusinessException("193110", "\u65e0\u64cd\u4f5c\u6743\u9650\uff01");
        }
        if (null == reqBO.getAdjustAmount()) {
            reqBO.setAdjustAmount(BigDecimal.ZERO);
        }
        if (null == reqBO.getCreditAmount()) {
            reqBO.setCreditAmount(BigDecimal.ZERO);
        }
        FscOrderPO qry = new FscOrderPO();
        qry.setFscOrderId(reqBO.getOrderId());
        qry = this.fscOrderMapper.getModelBy(qry);
        if (null == qry.getCreditAmount()) {
            qry.setCreditAmount(BigDecimal.ZERO);
        }
        if (reqBO.getTotalCharge().compareTo(qry.getCreditAmount().add(reqBO.getCreditAmount()).subtract(reqBO.getAdjustAmount())) < 0) {
            throw new FscBusinessException("193110", "\u8c03\u6574\u540e\u91d1\u989d\u5c0f\u4e8e0\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\uff01");
        }
        FscOrderAdjustProcessPO fscOrderAdjustProcessPo = new FscOrderAdjustProcessPO();
        fscOrderAdjustProcessPo.setAdjustProcessId(Long.valueOf(Sequence.getInstance().nextId()));
        fscOrderAdjustProcessPo.setFscOrderId(reqBO.getOrderId());
        fscOrderAdjustProcessPo.setAdjustType("0".equals(reqBO.getIsprofess()) ? FscConstants.AdjustType.PRO : FscConstants.AdjustType.SUPPLIER);
        fscOrderAdjustProcessPo.setAdjustResult(reqBO.getAdjustResult());
        fscOrderAdjustProcessPo.setAdjustAmount(reqBO.getAdjustAmount());
        fscOrderAdjustProcessPo.setCreditAmount(reqBO.getCreditAmount());
        fscOrderAdjustProcessPo.setAdjustRemark(reqBO.getAdjustRemark());
        fscOrderAdjustProcessPo.setCreateOperId(reqBO.getUserId());
        fscOrderAdjustProcessPo.setCreateOperName(reqBO.getName());
        fscOrderAdjustProcessPo.setCreateTime(new Date());
        fscOrderAdjustProcessPo.setCreateOrgId(reqBO.getOrgId());
        fscOrderAdjustProcessPo.setCreateOrgName(reqBO.getOrgName());
        fscOrderAdjustProcessPo.setSysTenantId(reqBO.getSysTenantId());
        fscOrderAdjustProcessPo.setSysTenantName(reqBO.getSysTenantName());
        this.fscOrderAdjustProcessMapper.insert(fscOrderAdjustProcessPo);
        if (ObjectUtil.isNotEmpty(reqBO.getAttachmentBOList())) {
            ArrayList<FscAttachmentPO> attachmentBoList = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : reqBO.getAttachmentBOList()) {
                FscAttachmentPO attachmentPO = new FscAttachmentPO();
                attachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentPO.setFscOrderId(reqBO.getOrderId());
                attachmentPO.setObjId(fscOrderAdjustProcessPo.getAdjustProcessId());
                attachmentPO.setObjType(FscConstants.AttachmentObjType.SERVICE_FEE);
                attachmentPO.setAttachmentUrl(attachmentBO.getAttachmentUrl());
                attachmentPO.setAttachmentName(attachmentBO.getAttachmentName());
                attachmentPO.setAttachmentType(FscConstants.AttachmentType.SERVICE_FEE_ADJUST);
                attachmentPO.setAttachmentUrlSource("0");
                attachmentPO.setSysTenantId(reqBO.getSysTenantId());
                attachmentPO.setSysTenantName(reqBO.getSysTenantName());
                attachmentBoList.add(attachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(attachmentBoList);
        }
        String createEvaProcessKey = "";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        if ("0".equals(reqBO.getIsprofess())) {
            if (null != reqBO.getCreditAmount() && reqBO.getCreditAmount().compareTo(BigDecimal.ZERO) > 0) {
                paramMap.put("auditFlag", "6");
                set = new FscOrderPO();
                set.setCreditAmount(reqBO.getCreditAmount());
                set.setActualAmount(reqBO.getTotalCharge().subtract(reqBO.getCreditAmount()).add(null != qry.getAdjustAmount() ? qry.getAdjustAmount() : BigDecimal.ZERO));
                where = new FscOrderPO();
                where.setFscOrderId(reqBO.getOrderId());
                this.fscOrderMapper.updateBy(set, where);
            } else if ("pass".equals(reqBO.getAdjustResult())) {
                paramMap.put("auditFlag", "5");
                createEvaProcessKey = this.getAuditKey(reqBO);
                if (ObjectUtil.isEmpty((Object)createEvaProcessKey) || this.noNeedAudit.equals(createEvaProcessKey)) {
                    paramMap.put("skigFlag", "5");
                }
                if (qry.getTotalCharge().compareTo(null == qry.getCreditAmount() ? BigDecimal.ZERO : qry.getCreditAmount()) == 0) {
                    log.info("\u5168\u989d\u51cf\u514d\uff0c\u76f4\u63a5\u7ed3\u675f");
                    paramMap.put("orderFinish", FscConstants.ProcessParam.orderFinish);
                }
            } else {
                paramMap.put("auditFlag", "6");
            }
        } else if ("2".equals(reqBO.getIsprofess())) {
            set = new FscOrderPO();
            set.setOrderConfirmId(reqBO.getUserName());
            set.setOrderConfirmName(reqBO.getName());
            set.setOrderConfirmTime(new Date());
            set.setPayState(FscConstants.FscServiceOrderState.TO_PAY);
            if (null != reqBO.getAdjustAmount()) {
                set.setAdjustAmount(reqBO.getAdjustAmount());
                set.setActualAmount(qry.getTotalCharge().subtract(null != qry.getCreditAmount() ? qry.getCreditAmount() : BigDecimal.ZERO).add(reqBO.getAdjustAmount()));
            }
            where = new FscOrderPO();
            where.setFscOrderId(reqBO.getOrderId());
            this.fscOrderMapper.updateBy(set, where);
            if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(reqBO.getOrderFlow()) || FscConstants.OrderFlow.PL_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
                this.createShouldPay(reqBO.getFscShouldPayBOS(), reqBO);
            }
            if (!FscConstants.OrderFlow.PL_SERVICE_FEE.equals(reqBO.getOrderFlow())) {
                this.updateOrderInvoice(reqBO);
            }
        }
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(reqBO.getOrderId());
        flowAtomReqBO.setCurStatus(FscBillStatus.TO_BE_CONFIRM.getCode());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        flowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193110", flowAtomRspBO.getRespDesc());
        }
        if (ObjectUtil.isNotEmpty((Object)createEvaProcessKey) && !this.noNeedAudit.equals(createEvaProcessKey)) {
            try {
                this.invokeUacNoTaskAndStatusStart(reqBO, createEvaProcessKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new FscComOrderConfirmBusiRspBO();
    }

    private void createShouldPay(List<FscShouldPayBO> fscShouldPayBOS, FscComOrderConfirmBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty(fscShouldPayBOS)) {
            FscPayShouldPayCreateAtomReqBO fscPayShouldPayCreateAtomReqBO = new FscPayShouldPayCreateAtomReqBO();
            fscPayShouldPayCreateAtomReqBO.setFscShouldPayBOS(fscShouldPayBOS);
            fscPayShouldPayCreateAtomReqBO.setUserId(reqBO.getUserId());
            fscPayShouldPayCreateAtomReqBO.setName(reqBO.getName());
            fscPayShouldPayCreateAtomReqBO.setUserName(reqBO.getUserName());
            fscPayShouldPayCreateAtomReqBO.setCompanyId(reqBO.getCompanyId());
            fscPayShouldPayCreateAtomReqBO.setCompanyName(reqBO.getCompanyName());
            fscPayShouldPayCreateAtomReqBO.setOrgId(reqBO.getOrgId());
            fscPayShouldPayCreateAtomReqBO.setOrgName(reqBO.getOrgName());
            FscPayShouldPayCreateAtomRspBO fscPayShouldPayCreateAtomRspBO = this.fscPayShouldPayCreateAtomService.dealShouldPayCreate(fscPayShouldPayCreateAtomReqBO);
            if (!"0000".equals(fscPayShouldPayCreateAtomRspBO.getRespCode())) {
                throw new FscBusinessException("193110", fscPayShouldPayCreateAtomRspBO.getRespDesc());
            }
        }
    }

    private void updateOrderInvoice(FscComOrderConfirmBusiReqBO busiReqBO) {
        FscOrderInvoicePO fscOrderInvoicePO = (FscOrderInvoicePO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), FscOrderInvoicePO.class);
        fscOrderInvoicePO.setFscOrderId(busiReqBO.getOrderId());
        if (null != busiReqBO.getUserId()) {
            fscOrderInvoicePO.setBillOperId(busiReqBO.getUserId().toString());
        }
        fscOrderInvoicePO.setBillOperName(busiReqBO.getUserName());
        fscOrderInvoicePO.setBillTime(new Date());
        fscOrderInvoicePO.setBillInvoiceId(busiReqBO.getInvoiceId());
        fscOrderInvoicePO.setInvoiceType(busiReqBO.getInvoiceType());
        fscOrderInvoicePO.setInvoiceCategory(busiReqBO.getInvoiceCategory());
        FscOrderInvoicePO wherePO = new FscOrderInvoicePO();
        wherePO.setFscOrderId(busiReqBO.getOrderId());
        int insert = this.fscOrderInvoiceMapper.updateBy(fscOrderInvoicePO, wherePO);
    }

    private String getAuditKey(FscComOrderConfirmBusiReqBO busiReqBO) {
        String createEvaProcessKey = "";
        FscGeneralBusiRuleExecAtomReqBO fscGeneralBusiRuleExecAtomReqBO = new FscGeneralBusiRuleExecAtomReqBO();
        fscGeneralBusiRuleExecAtomReqBO.setServiceCode("FSC001");
        fscGeneralBusiRuleExecAtomReqBO.setParamJsonStr(JSON.toJSONString((Object)((Object)busiReqBO)));
        FscGeneralBusiRuleExecAtomRspBO fscGeneralBusiRuleExecAtomRspBO = this.fscGeneralBusiRuleExecAtomService.dealGeneralBusiRuleExec(fscGeneralBusiRuleExecAtomReqBO);
        if (!StringUtils.hasText((String)fscGeneralBusiRuleExecAtomRspBO.getBusiRuleExecResult())) {
            throw new FscBusinessException("193208", "\u6ca1\u6709\u914d\u7f6e\u670d\u52a1\u51cf\u514d\u5ba1\u6279\u6d41\u89c4\u5219");
        }
        JSONObject callRuleRspJsonObj = JSON.parseObject((String)fscGeneralBusiRuleExecAtomRspBO.getBusiRuleExecResult());
        createEvaProcessKey = callRuleRspJsonObj.getString("processKey");
        return createEvaProcessKey;
    }

    private void invokeUacNoTaskAndStatusStart(FscComOrderConfirmBusiReqBO busiReqBO, String createEvaProcessKey) {
        HashMap paramMap = new HashMap(4);
        log.info("busiReqBO === :{}", (Object)busiReqBO);
        FscAuditOrderCreateAtomReqBO fscAuditOrderCreateAtomReqBO = new FscAuditOrderCreateAtomReqBO();
        fscAuditOrderCreateAtomReqBO.setOrderId(busiReqBO.getOrderId());
        fscAuditOrderCreateAtomReqBO.setObjId(busiReqBO.getOrderId());
        fscAuditOrderCreateAtomReqBO.setObjType(FscConstants.OBJ_TYPE.FSC_ORDER);
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_PROCESS_APPROVAL);
        }
        if (FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
        }
        if (FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
        }
        if (FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(busiReqBO.getOrderFlow())) {
            fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.SERVICE_CHARGE_APPROVAL);
        }
        fscAuditOrderCreateAtomReqBO.setUserId(busiReqBO.getUserId());
        fscAuditOrderCreateAtomReqBO.setUserName(busiReqBO.getName());
        FscAuditOrderCreateAtomRspBO atomRspBO = this.fscAuditOrderCreateAtomService.dealAuditOrderCreate(fscAuditOrderCreateAtomReqBO);
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = (EacStartProjectAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)busiReqBO)), EacStartProjectAbilityReqBO.class);
        eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
        eacStartProjectAbilityReqBO.setProcDefKey(createEvaProcessKey);
        eacStartProjectAbilityReqBO.setPartitionKey(busiReqBO.getOrderId().toString());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("auditId", atomRspBO.getAuditOrderId());
        variables.put("todoOrderNo", busiReqBO.getFscOrderNo());
        eacStartProjectAbilityReqBO.setVariables(variables);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(busiReqBO.getOrderId().toString());
        eacStartProjectAbilityReqBO.setBusinessIdList(strings);
        log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
        log.info("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
        }
    }
}

