/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.busi.api.FscOrderStatusFlowBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.ability.bo.FscAccountAttachmentBO;
import com.tydic.fsc.common.busi.api.FscCheckWriteOffDateBusiService;
import com.tydic.fsc.common.busi.api.FscPayBillWriteOffBusiService;
import com.tydic.fsc.common.busi.bo.FscPayBillWriteOffBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscPayBillWriteOffBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import com.tydic.umc.general.ability.api.UmcDycEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryDetailAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class FscPayBillWriteOffBusiServiceImpl
implements FscPayBillWriteOffBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscPayBillWriteOffBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscOrderStatusFlowBusiService fscOrderStatusFlowBusiService;
    @Autowired
    private FscWriteOffItemMapper fscWriteOffItemMapper;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private UmcDycEnterpriseOrgQryDetailAbilityService umcDycEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private FscCheckWriteOffDateBusiService fscCheckWriteOffDateBusiService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FscPayBillWriteOffBusiRspBO payBillWriteOff(FscPayBillWriteOffBusiReqBO reqBO) {
        FscPayBillWriteOffBusiRspBO retBo = new FscPayBillWriteOffBusiRspBO();
        FscBankCheckFileItemPO fscBankCheckFileItemPOQry = new FscBankCheckFileItemPO();
        fscBankCheckFileItemPOQry.setWriteOffFlag("0".toString());
        fscBankCheckFileItemPOQry.setBankCheckIdS(reqBO.getBankCheckIds());
        List FscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getList(fscBankCheckFileItemPOQry);
        if (CollectionUtils.isEmpty((Collection)FscBankCheckFileItemPOList) || reqBO.getBankCheckIds().size() != FscBankCheckFileItemPOList.size()) {
            throw new FscBusinessException("198888", "\u672a\u6838\u9500\u72b6\u6001\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u540e\u518d\u8bd5");
        }
        FscOrderPO fscOrderPOQry = new FscOrderPO();
        fscOrderPOQry.setFscOrderIds(reqBO.getFscOrderId());
        List fscOrderPOList = this.fscOrderMapper.getList(fscOrderPOQry);
        String payeeBankAccount = ((FscOrderPO)fscOrderPOList.get(0)).getPayeeBankAccount();
        Set payeeIds = FscBankCheckFileItemPOList.stream().map(FscBankCheckFileItemPO::getPayeeId).collect(Collectors.toSet());
        Set supplierIds = fscOrderPOList.stream().map(FscOrderPO::getPayeeId).collect(Collectors.toSet());
        Set orderStateS = fscOrderPOList.stream().map(FscOrderPO::getOrderState).collect(Collectors.toSet());
        if (payeeIds.size() != supplierIds.size() || payeeIds.size() > 1) {
            throw new FscBusinessException("198888", "\u6536\u6b3e\u5355\u4f4d\u5fc5\u987b\u76f8\u540c");
        }
        Collection disjunctionList = CollectionUtil.disjunction(payeeIds, supplierIds);
        if (!ObjectUtils.isEmpty((Object)disjunctionList) && disjunctionList.size() > 0) {
            throw new FscBusinessException("198888", "\u6536\u6b3e\u5355\u4f4d\u5fc5\u987b\u76f8\u540c");
        }
        BigDecimal totalTradeAmt = FscBankCheckFileItemPOList.stream().map(FscBankCheckFileItemPO::getTradeAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalChange = fscOrderPOList.stream().map(FscOrderPO::getTotalCharge).reduce(BigDecimal.ZERO, BigDecimal::add);
        Map<Object, Object> fscPaidBankCheckFileItemPOListMap = new HashMap();
        if (FscConstants.FscPayOrderState.TO_PAY.equals(((FscOrderPO)fscOrderPOList.get(0)).getOrderState()) && orderStateS.size() == 1) {
            if (totalTradeAmt.compareTo(totalChange) != 0) {
                throw new FscBusinessException("198888", "\u6838\u9500\u91d1\u989d\u5fc5\u987b\u4e00\u81f4");
            }
        } else {
            FscBankCheckFileItemPO queryFscPaidBankCheckFileItem = new FscBankCheckFileItemPO();
            queryFscPaidBankCheckFileItem.setFscOrderIds(reqBO.getFscOrderId());
            List fscPaidBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.queryPaidBankCheckFileItemList(queryFscPaidBankCheckFileItem);
            if (ObjectUtil.isNotEmpty((Object)fscPaidBankCheckFileItemPOList)) {
                fscPaidBankCheckFileItemPOListMap = fscPaidBankCheckFileItemPOList.stream().collect(Collectors.groupingBy(FscBankCheckFileItemPO::getFscOrderId));
            }
            this.validatePayBillWriteOff(reqBO, fscPaidBankCheckFileItemPOList);
        }
        ArrayList<FscWriteOffItemPO> fscWriteOffItemPOList = new ArrayList<FscWriteOffItemPO>();
        ArrayList<Long> writeOffBankId = new ArrayList<Long>();
        for (FscOrderPO fscOrderPOFor : fscOrderPOList) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(fscOrderPOFor.getFscOrderId());
            if (null != reqBO.getUserId()) {
                fscOrderPO.setPayOperId(reqBO.getUserId().toString());
            }
            fscOrderPO.setPayOperName(reqBO.getName());
            fscOrderPO.setPayTime(new Date());
            fscOrderPO.setPayState(FscConstants.PayOrderPayStatus.PAIED);
            fscOrderPO.setActualAmount(fscOrderPOFor.getTotalCharge());
            fscOrderPO.setOrderState(FscConstants.FscPayOrderState.PAIED);
            int row = this.fscOrderMapper.updateById(fscOrderPO);
            if (row < 1) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
            Object writeOffTradeAmt = BigDecimal.ZERO;
            if (ObjectUtil.isNotEmpty(fscPaidBankCheckFileItemPOListMap) && ObjectUtil.isNotEmpty((Object)fscPaidBankCheckFileItemPOListMap.get(fscOrderPOFor.getFscOrderId()))) {
                writeOffTradeAmt = ((List)fscPaidBankCheckFileItemPOListMap.get(fscOrderPOFor.getFscOrderId())).stream().map(FscBankCheckFileItemPO::getTradeAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            Boolean writeOffFkd = false;
            for (FscBankCheckFileItemPO fscBankCheckFileItemPOFor : FscBankCheckFileItemPOList) {
                if (writeOffBankId.contains(fscBankCheckFileItemPOFor.getBankCheckId()) || writeOffFkd.booleanValue()) continue;
                if (fscOrderPOFor.getTotalCharge().subtract((BigDecimal)writeOffTradeAmt).compareTo(fscBankCheckFileItemPOFor.getTradeAmt()) == 0) {
                    if (ObjectUtil.isNotEmpty(fscWriteOffItemPOList)) {
                        fscWriteOffItemPOList.removeAll(fscWriteOffItemPOList.stream().filter(bo -> bo.getBankCheckId().equals(fscBankCheckFileItemPOFor.getBankCheckId()) || bo.getFscOrderId().equals(fscOrderPOFor.getFscOrderId())).collect(Collectors.toList()));
                    }
                    writeOffBankId.add(fscBankCheckFileItemPOFor.getBankCheckId());
                    writeOffFkd = true;
                }
                FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
                String memo = reqBO.getMemo() + (!ObjectUtil.isEmpty((Object)reqBO.getNewMemo()) ? "&\u539f\u56e0\u8bf4\u660e\uff1a&" + reqBO.getNewMemo() : "");
                fscWriteOffItemPO.setMemo(memo);
                fscWriteOffItemPO.setFscOrderId(fscOrderPOFor.getFscOrderId());
                fscWriteOffItemPO.setBankCheckId(fscBankCheckFileItemPOFor.getBankCheckId());
                fscWriteOffItemPO.setWriteOffItemId(Long.valueOf(Sequence.getInstance().nextId()));
                fscWriteOffItemPO.setCreateTime(new Date());
                fscWriteOffItemPO.setCreateOperUserName(reqBO.getUserName());
                fscWriteOffItemPO.setCreateOperUserId(reqBO.getUserId());
                fscWriteOffItemPO.setSysTenantId(reqBO.getSysTenantId());
                fscWriteOffItemPO.setSysTenantName(reqBO.getSysTenantName());
                fscWriteOffItemPOList.add(fscWriteOffItemPO);
            }
        }
        if (!CollectionUtils.isEmpty(fscWriteOffItemPOList)) {
            this.fscWriteOffItemMapper.insertBatch(fscWriteOffItemPOList);
        }
        FscBankCheckFileItemPO itemSet = new FscBankCheckFileItemPO();
        itemSet.setWriteOffFlag("2".toString());
        FscBankCheckFileItemPO itemWhere = new FscBankCheckFileItemPO();
        itemWhere.setBankCheckIdS(reqBO.getBankCheckIds());
        int rows = this.fscBankCheckFileItemMapper.updateBy(itemSet, itemWhere);
        if (rows < 1) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u6838\u9500\u72b6\u6001\u5931\u8d25,\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        ArrayList<FscBalancePO> fscBalancePOList = new ArrayList<FscBalancePO>();
        for (FscBankCheckFileItemPO fscBankCheckFileItemPOFor : FscBankCheckFileItemPOList) {
            UmcDycEnterpriseOrgQryDetailAbilityReqBO umcDycEnterpriseOrgQryDetailAbilityReqBO = new UmcDycEnterpriseOrgQryDetailAbilityReqBO();
            umcDycEnterpriseOrgQryDetailAbilityReqBO.setOrgIdWeb(fscBankCheckFileItemPOFor.getPayeeId());
            log.info("\u67e5\u8be2\u6536\u6b3e\u5355\u4f4d\u662f\u5426\u662f\u8fd0\u8425\u5165\u53c2:{}", (Object)umcDycEnterpriseOrgQryDetailAbilityReqBO);
            UmcDycEnterpriseOrgQryDetailAbilityRspBO rspBO = this.umcDycEnterpriseOrgQryDetailAbilityService.qryEnterpriseOrgDetail(umcDycEnterpriseOrgQryDetailAbilityReqBO);
            log.info("\u67e5\u8be2\u6536\u6b3e\u5355\u4f4d\u662f\u5426\u662f\u8fd0\u8425\u51fa\u53c2:{}", (Object)rspBO);
            if (!ObjectUtils.isEmpty((Object)rspBO.getEnterpriseOrgBO()) && rspBO.getEnterpriseOrgBO().getIsProfessionalOrg().equals("0")) continue;
            FscBalancePO fscBalancePO = new FscBalancePO();
            fscBalancePO.setBalanceId(Long.valueOf(Sequence.getInstance().nextId()));
            fscBalancePO.setBankCheckId(fscBankCheckFileItemPOFor.getBankCheckId());
            fscBalancePO.setOrgId(fscBankCheckFileItemPOFor.getPayeeId());
            fscBalancePO.setOrgCode("");
            fscBalancePO.setOrgName(fscBankCheckFileItemPOFor.getPayeeName());
            fscBalancePO.setSubAccountNo(fscBankCheckFileItemPOFor.getPayeeAccountNo());
            fscBalancePO.setPayerOrgId(((FscOrderPO)fscOrderPOList.get(0)).getPayerId());
            fscBalancePO.setPayerOrgName(((FscOrderPO)fscOrderPOList.get(0)).getPayerName());
            fscBalancePO.setPayerOrgCode(null);
            fscBalancePO.setPayerSubAccountNo(null);
            fscBalancePO.setFrozenEndTime(this.getConfiguration(((FscOrderPO)fscOrderPOList.get(0)).getPayeeId().toString()));
            fscBalancePO.setCreateTime(new Date());
            fscBalancePO.setPayAmount(fscBankCheckFileItemPOFor.getTradeAmt());
            if (fscBalancePO.getFrozenEndTime().compareTo(new Date()) <= 0) {
                fscBalancePO.setFrozenAmount(new BigDecimal(0));
                fscBalancePO.setUsableAmount(fscBankCheckFileItemPOFor.getTradeAmt());
                fscBalancePO.setThawOperTime(new Date());
            } else {
                fscBalancePO.setFrozenAmount(fscBankCheckFileItemPOFor.getTradeAmt());
                fscBalancePO.setUsableAmount(new BigDecimal(0));
            }
            fscBalancePO.setUsedAmount(new BigDecimal(0));
            fscBalancePO.setCreateTime(new Date());
            fscBalancePO.setSysTenantId(reqBO.getSysTenantId());
            fscBalancePO.setSysTenantName(reqBO.getSysTenantName());
            fscBalancePOList.add(fscBalancePO);
        }
        if (!CollectionUtils.isEmpty(fscBalancePOList)) {
            this.fscBalanceMapper.insertBatch(fscBalancePOList);
        }
        if (!ObjectUtil.isEmpty(reqBO.getFscAccountAttachmentBOList())) {
            ArrayList<FscAttachmentPO> fscAttachmentPOS = new ArrayList<FscAttachmentPO>();
            for (FscAccountAttachmentBO fscAccountAttachmentBO : reqBO.getFscAccountAttachmentBOList()) {
                FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
                fscAttachmentPO.setObjId(reqBO.getBankCheckIds().get(0));
                fscAttachmentPO.setFscOrderId(reqBO.getFscOrderId().get(0));
                fscAttachmentPO.setObjType(Integer.valueOf(0));
                fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                fscAttachmentPO.setAttachmentName(fscAccountAttachmentBO.getAttachmentName());
                fscAttachmentPO.setAttachmentUrl(fscAccountAttachmentBO.getAttachmentUrl());
                fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.WRITE_OFF_FILE);
                fscAttachmentPO.setSysTenantId(reqBO.getSysTenantId());
                fscAttachmentPO.setSysTenantName(reqBO.getSysTenantName());
                fscAttachmentPOS.add(fscAttachmentPO);
            }
            if (!ObjectUtil.isEmpty(fscAttachmentPOS)) {
                this.fscAttachmentMapper.insertBatch(fscAttachmentPOS);
            }
        }
        return retBo;
    }

    private Date getConfiguration(String relId) {
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(new Date());
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("cash_withdrawal");
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(relId);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        Integer advanceUnfreezeDays = 0;
        Integer paymentDays = 0;
        Integer advanceWarningDays = 0;
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays())) {
            advanceUnfreezeDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays())) {
            paymentDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays())) {
            advanceWarningDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays());
        }
        curDate.add(5, paymentDays - advanceUnfreezeDays);
        return curDate.getTime();
    }

    private void validatePayBillWriteOff(FscPayBillWriteOffBusiReqBO reqBO, List<FscBankCheckFileItemPO> fscPaidBankCheckFileItemPOList) {
        FscOrderPO queryFscOrderPO = new FscOrderPO();
        queryFscOrderPO.setFscOrderIds(reqBO.getFscOrderId());
        List fscOrderPOList = this.fscOrderMapper.getList(queryFscOrderPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderPOList)) {
            throw new FscBusinessException("198888", "\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728");
        }
        Map<Integer, Long> orderStateCountMap = fscOrderPOList.stream().collect(Collectors.groupingBy(FscOrderPO::getOrderState, Collectors.counting()));
        if (FscConstants.WRITE_OFF_DATA_FLAG.PAY.equals(reqBO.getWriteOffDataFlag())) {
            if (orderStateCountMap.size() != 1 || orderStateCountMap.values().iterator().next() != (long)fscOrderPOList.size()) {
                throw new FscBusinessException("198888", "\u5df2\u4ed8\u6b3e\u7684\u4ed8\u6b3e\u5355\u4e0d\u80fd\u6838\u9500");
            }
            return;
        }
        if (FscConstants.WRITE_OFF_DATA_FLAG.NO_PAY_AND_PAY.equals(reqBO.getWriteOffDataFlag()) && ObjectUtil.isNotEmpty((Object)orderStateCountMap.get(FscConstants.FscPayOrderState.PAIED))) {
            List paidFscOrderIdList = fscOrderPOList.stream().filter(po -> FscConstants.FscPayOrderState.PAIED.equals(po.getOrderState())).map(FscOrderPO::getFscOrderId).collect(Collectors.toList());
            BigDecimal paidTotalCharge = fscOrderPOList.stream().map(FscOrderPO::getTotalCharge).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal writeOffAmount = new BigDecimal("0");
            if (!CollectionUtils.isEmpty(fscPaidBankCheckFileItemPOList)) {
                writeOffAmount = fscPaidBankCheckFileItemPOList.stream().map(FscBankCheckFileItemPO::getTradeAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            BigDecimal unWriteOffAmount = paidTotalCharge.subtract(writeOffAmount);
            FscBankCheckFileItemPO queryFscBankCheckFileItem = new FscBankCheckFileItemPO();
            queryFscBankCheckFileItem.setBankCheckIdS(reqBO.getBankCheckIds());
            List fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getList(queryFscBankCheckFileItem);
            BigDecimal tradeAmtSum = new BigDecimal("0");
            if (!CollectionUtils.isEmpty((Collection)fscBankCheckFileItemPOList)) {
                tradeAmtSum = fscBankCheckFileItemPOList.stream().map(FscBankCheckFileItemPO::getTradeAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
            if (unWriteOffAmount.compareTo(tradeAmtSum) < 0) {
                throw new FscBusinessException("198888", "\u4ed8\u6b3e\u5355\u6838\u9500\u603b\u91d1\u989d\u5c0f\u4e8e\u94f6\u884c\u6d41\u6c34\u603b\u91d1\u989d");
            }
        }
    }
}

