/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.fsc.common.busi.api.FscUpdateMemberInfoBusiService;
import com.tydic.fsc.common.busi.bo.FscUpdateMemberInfoBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscUpdateMemberInfoBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscLegalCompanyMapper;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscLegalCompanyPO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscUpdateMemberInfoBusiServiceImpl
implements FscUpdateMemberInfoBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscUpdateMemberInfoBusiServiceImpl.class);
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscLegalCompanyMapper fscLegalCompanyMapper;

    @Override
    public FscUpdateMemberInfoBusiRspBO updateMemberInfo(FscUpdateMemberInfoBusiReqBO reqBO) {
        FscUpdateMemberInfoBusiRspBO rspBO = new FscUpdateMemberInfoBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getUpdateType().equals(1)) {
            FscAccountPO set = new FscAccountPO();
            FscAccountPO where = new FscAccountPO();
            set.setTransactorPhone(reqBO.getNewMobile());
            where.setOrgId(reqBO.getMemberId());
            where.setTransactorPhone(reqBO.getOldMobile());
            int resultCount = this.fscAccountMapper.updateBy(set, where);
            if (resultCount <= 0) {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u66f4\u65b0\u4f1a\u5458\u7ed1\u5b9a\u624b\u673a\u53f7\u5931\u8d25");
            }
        } else if (reqBO.getUpdateType().equals(2)) {
            FscAccountPO set = new FscAccountPO();
            FscAccountPO where = new FscAccountPO();
            set.setStatus(FscConstants.AccountStatus.INVALID);
            where.setOrgId(reqBO.getMemberId());
            where.setAccountNo(reqBO.getMemberAcctNo());
            where.setSysTenantId(reqBO.getSysTenantId());
            int resultCount = this.fscAccountMapper.updateBy(set, where);
            if (resultCount <= 0) {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u66f4\u65b0\u4f1a\u5458\u7ed1\u5b9a\u624b\u673a\u53f7\u5931\u8d25");
            }
        } else if (reqBO.getUpdateType().equals(3)) {
            if (!ObjectUtil.isEmpty((Object)reqBO.getAccountId())) {
                FscAccountPO set = new FscAccountPO();
                set.setAccountName(reqBO.getCompanyName());
                set.setOrgName(reqBO.getCompanyName());
                set.setLegalName(reqBO.getReprName());
                set.setLegalCertNo(reqBO.getReprGlobalId());
                FscAccountPO where = new FscAccountPO();
                where.setId(reqBO.getAccountId());
                where.setSysTenantId(reqBO.getSysTenantId());
                int resultCount = this.fscAccountMapper.updateBy(set, where);
                if (resultCount <= 0) {
                    rspBO.setRespCode("190000");
                    rspBO.setRespDesc("\u4fee\u6539\u4f1a\u5458\u4fe1\u606f\u5931\u8d25");
                }
                FscLegalCompanyPO fscLegalCompanyPO = new FscLegalCompanyPO();
                fscLegalCompanyPO.setOrgId(reqBO.getMemberId());
                fscLegalCompanyPO.setOrgName(reqBO.getCompanyName());
                this.fscLegalCompanyMapper.updateByOrgId(fscLegalCompanyPO);
            }
        } else if (reqBO.getUpdateType().equals(4) && !ObjectUtil.isEmpty((Object)reqBO.getAccountId())) {
            FscAccountPO set = new FscAccountPO();
            set.setDepositBankName(reqBO.getAcctOpenBranchName());
            set.setSuperLineNumber(reqBO.getEiconBankBranchId());
            set.setSizeLineNumber(reqBO.getCnapsBranchId());
            FscAccountPO where = new FscAccountPO();
            where.setId(reqBO.getAccountId());
            where.setSysTenantId(reqBO.getSysTenantId());
            int resultCount = this.fscAccountMapper.updateBy(set, where);
            if (resultCount <= 0) {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u4fee\u6539\u7ed1\u5b9a\u4fe1\u606f\u5931\u8d25");
            }
        }
        return rspBO;
    }
}

