/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.common.busi.api.FscWriteOffEntityAccountAuditBusiService;
import com.tydic.fsc.common.busi.bo.FscWriteOffEntityAccountAuditBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscWriteOffEntityAccountAuditBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscWriteOffEntityAccountHistoryMapper;
import com.tydic.fsc.dao.FscWriteOffEntityAccountMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscWriteOffEntityAccountHistoryPO;
import com.tydic.fsc.po.FscWriteOffEntityAccountPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscWriteOffEntityAccountAuditBusiServiceImpl
implements FscWriteOffEntityAccountAuditBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscWriteOffEntityAccountAuditBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscWriteOffEntityAccountMapper fscWriteOffEntityAccountMapper;
    @Autowired
    private FscWriteOffEntityAccountHistoryMapper fscWriteOffEntityAccountHistoryMapper;

    @Override
    public FscWriteOffEntityAccountAuditBusiRspBO writeOffEntityAccountAudit(FscWriteOffEntityAccountAuditBusiReqBO reqBO) {
        FscWriteOffEntityAccountAuditBusiRspBO rspBO = new FscWriteOffEntityAccountAuditBusiRspBO();
        this.validateWriteOffEntityAccountAudit(reqBO);
        FscWriteOffEntityAccountPO fscWriteOffEntityAccountInfo = this.getWriteOffEntityAccountInfo(reqBO);
        this.validateWriteOffEntityAccountInfo(fscWriteOffEntityAccountInfo);
        this.auditWriteOffEntityAccount(reqBO);
        this.auditFscOrderReject(reqBO.getAuditType(), fscWriteOffEntityAccountInfo.getFscOrderId());
        this.addWriteOffEntityAccountHistoryInfo(reqBO);
        rspBO.setFscOrderId(fscWriteOffEntityAccountInfo.getFscOrderId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void validateWriteOffEntityAccountAudit(FscWriteOffEntityAccountAuditBusiReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBO))) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getAuditType())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[\u5ba1\u6838\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!FscConstants.WriteOffEntityAccountAuditType.REJECT.equals(reqBO.getAuditType()) && !FscConstants.WriteOffEntityAccountAuditType.PASS.equals(reqBO.getAuditType())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[\u5ba1\u6838\u7c7b\u578b]\u4e0d\u5408\u6cd5");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getApplyId())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[\u7533\u8bf7ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateWriteOffEntityAccountInfo(FscWriteOffEntityAccountPO fscWriteOffEntityAccount) {
        if (!FscConstants.WriteOffEntityAccountApplyStatus.APPLY.equals(fscWriteOffEntityAccount.getApplyStatus())) {
            throw new FscBusinessException("190000", "\u5b9e\u4f53\u6237\u6838\u9500\u7533\u8bf7\u72b6\u6001\u4e0d\u5408\u6cd5");
        }
    }

    private FscWriteOffEntityAccountPO getWriteOffEntityAccountInfo(FscWriteOffEntityAccountAuditBusiReqBO reqBO) {
        FscWriteOffEntityAccountPO queryFscWriteOffEntityAccount = new FscWriteOffEntityAccountPO();
        queryFscWriteOffEntityAccount.setApplyId(reqBO.getApplyId());
        FscWriteOffEntityAccountPO fscWriteOffEntityAccount = this.fscWriteOffEntityAccountMapper.getModelBy(queryFscWriteOffEntityAccount);
        if (ObjectUtil.isEmpty((Object)fscWriteOffEntityAccount)) {
            throw new FscBusinessException("190000", "\u5b9e\u4f53\u6237\u6838\u9500\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        return fscWriteOffEntityAccount;
    }

    private void auditWriteOffEntityAccount(FscWriteOffEntityAccountAuditBusiReqBO reqBO) {
        FscWriteOffEntityAccountPO fscWriteOffEntityAccountSet = new FscWriteOffEntityAccountPO();
        fscWriteOffEntityAccountSet.setApplyStatus(FscConstants.WriteOffEntityAccountAuditType.PASS.equals(reqBO.getAuditType()) ? FscConstants.WriteOffEntityAccountApplyStatus.PASS : FscConstants.WriteOffEntityAccountApplyStatus.REJECT);
        fscWriteOffEntityAccountSet.setAuditRemark(reqBO.getAuditRemark());
        fscWriteOffEntityAccountSet.setUpdateUserId(reqBO.getUserId());
        fscWriteOffEntityAccountSet.setUpdateUserName(reqBO.getName());
        fscWriteOffEntityAccountSet.setUpdateTime(new Date());
        FscWriteOffEntityAccountPO fscWriteOffEntityAccountWhere = new FscWriteOffEntityAccountPO();
        fscWriteOffEntityAccountWhere.setApplyId(reqBO.getApplyId());
        this.fscWriteOffEntityAccountMapper.updateBy(fscWriteOffEntityAccountSet, fscWriteOffEntityAccountWhere);
    }

    private void auditFscOrderReject(Integer auditType, Long fscOrderId) {
        if (FscConstants.WriteOffEntityAccountAuditType.REJECT.equals(auditType)) {
            FscOrderPO fscOrderSet = new FscOrderPO();
            fscOrderSet.setOrderState(FscConstants.FscPayOrderState.TO_PAY);
            FscOrderPO fscOrderWhere = new FscOrderPO();
            fscOrderWhere.setFscOrderId(fscOrderId);
            this.fscOrderMapper.updateBy(fscOrderSet, fscOrderWhere);
        }
    }

    private void addWriteOffEntityAccountHistoryInfo(FscWriteOffEntityAccountAuditBusiReqBO reqBO) {
        FscWriteOffEntityAccountPO queryFscWriteOffEntityAccount = new FscWriteOffEntityAccountPO();
        queryFscWriteOffEntityAccount.setApplyId(reqBO.getApplyId());
        FscWriteOffEntityAccountPO fscWriteOffEntityAccount = this.fscWriteOffEntityAccountMapper.getModelBy(queryFscWriteOffEntityAccount);
        if (ObjectUtil.isEmpty((Object)fscWriteOffEntityAccount)) {
            throw new FscBusinessException("190000", "\u5b9e\u4f53\u6237\u6838\u9500\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        FscWriteOffEntityAccountHistoryPO fscWriteOffEntityAccountHistoryPO = new FscWriteOffEntityAccountHistoryPO();
        BeanUtils.copyProperties((Object)fscWriteOffEntityAccount, (Object)fscWriteOffEntityAccountHistoryPO);
        fscWriteOffEntityAccountHistoryPO.setHistoryId(Long.valueOf(Sequence.getInstance().nextId()));
        fscWriteOffEntityAccountHistoryPO.setObjId(fscWriteOffEntityAccount.getApplyId());
        this.fscWriteOffEntityAccountHistoryMapper.insert(fscWriteOffEntityAccountHistoryPO);
    }
}

