/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.busibase.atom.api.FscSendInvoiceMessageAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendMessageAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.SendMessageBO;
import com.tydic.fsc.busibase.atom.bo.SendMessageReceiverBO;
import com.tydic.fsc.busibase.busi.api.FscBillOrderCreatePdfToEmailBusiService;
import com.tydic.fsc.busibase.busi.bo.FscBillOrderCreatePdfToEmailBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscBillOrderCreatePdfToEmailBusiRspBO;
import com.tydic.fsc.common.consumer.bo.FscInvoiceTimeoutReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.umc.general.ability.api.UmcDycMemberQryDetailAbilityService;
import com.tydic.umc.general.ability.api.UmcDycMemberQryListPageAbilityService;
import com.tydic.umc.general.ability.api.UmcQrySupplierLinkManAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycMemberQryDetailAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycMemberQryDetailAbilityRspBO;
import com.tydic.umc.general.ability.bo.UmcQrySupplierLinkManAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcQrySupplierLinkManAbilityRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class FscInvoiceTimeoutServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscInvoiceTimeoutServiceConsumer.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${task.invoice.timeout}")
    private Integer dayTime;
    @Autowired
    private FscBillOrderCreatePdfToEmailBusiService fscBillOrderCreatePdfToEmailBusiService;
    @Autowired
    private UmcDycMemberQryDetailAbilityService umcDycMemberQryDetailAbilityService;
    @Autowired
    private FscSendInvoiceMessageAtomService fscSendInvoiceMessageAtomService;
    @Autowired
    private UmcDycMemberQryListPageAbilityService umcDycMemberQryListPageAbilityService;
    @Autowired
    private UmcQrySupplierLinkManAbilityService umcQrySupplierLinkManAbilityService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        FscInvoiceTimeoutReqBO fscInvoiceSyncReqBO = (FscInvoiceTimeoutReqBO)JSON.parseObject((String)message.getContent(), (TypeReference)new TypeReference<FscInvoiceTimeoutReqBO>(){}, (Feature[])new Feature[0]);
        log.info("\u8d85\u671f\u5f00\u7968\u901a\u77e5\u6d88\u8d39\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscInvoiceSyncReqBO));
        try {
            this.sendMessage(fscInvoiceSyncReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ProxyConsumerStatus.RECONSUME_LATER;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void sendMessage(FscInvoiceTimeoutReqBO fscInvoiceSyncReqBO) {
        String code = fscInvoiceSyncReqBO.getTaskCode();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
        fscOrderPO.setSupplierId(fscInvoiceSyncReqBO.getSupplierId());
        fscOrderPO.setSwapUserId(fscInvoiceSyncReqBO.getCreateUserId());
        fscOrderPO.setOrderStates(Arrays.asList(FscConstants.FscServiceOrderState.BILLED_INVOICE, FscConstants.FscServiceOrderState.TO_BE_APPROVAL));
        Calendar now = Calendar.getInstance();
        now.add(5, Math.negateExact(this.dayTime));
        fscOrderPO.setCreateTimeEnd(now.getTime());
        List fscOrderPOList = this.fscOrderMapper.getInvoiceTimeoutOrder(fscOrderPO);
        List fscOrderIds = fscOrderPOList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList());
        FscBillOrderCreatePdfToEmailBusiReqBO fscBillOrderCreatePdfToEmailBusiReqBO = new FscBillOrderCreatePdfToEmailBusiReqBO();
        fscBillOrderCreatePdfToEmailBusiReqBO.setFscOrderIds(fscOrderIds);
        FscBillOrderCreatePdfToEmailBusiRspBO fscBillOrderCreatePdfToEmailBusiRspBO = this.fscBillOrderCreatePdfToEmailBusiService.orderCreatePdfToEmail(fscBillOrderCreatePdfToEmailBusiReqBO);
        log.info("\u53d1\u9001\u90ae\u4ef6\u901a\u77e5\u4f9b\u5e94\u5546\u5f00\u7968\u7533\u8bf7, \u9644\u4ef6\u5730\u5740: {}", (Object)JSON.toJSONString((Object)fscBillOrderCreatePdfToEmailBusiRspBO));
        FscSendMessageAtomReqBO fscSendMessageAtomReqBO = new FscSendMessageAtomReqBO();
        ArrayList<SendMessageBO> sendMessageBOList = new ArrayList<SendMessageBO>();
        SendMessageBO sendMessageBO = new SendMessageBO();
        sendMessageBO.setNowDate(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"));
        if (!ObjectUtil.isEmpty((Object)fscInvoiceSyncReqBO.getSupplierId())) {
            sendMessageBO.setOverSize(Integer.valueOf(fscOrderPOList.size()));
        }
        sendMessageBO.setFileUrl(fscBillOrderCreatePdfToEmailBusiRspBO.getUrl());
        sendMessageBO.setTaskCode(code);
        sendMessageBO.setSendId("1");
        sendMessageBO.setSendName("\u7cfb\u7edf\u7ba1\u7406\u5458");
        String receiverId = "";
        String email = "";
        String createOperName = "";
        if (!ObjectUtil.isEmpty((Object)fscInvoiceSyncReqBO.getCreateUserId())) {
            receiverId = fscInvoiceSyncReqBO.getCreateUserId().toString();
            createOperName = ((FscOrderPO)fscOrderPOList.get(0)).getCreateOperName();
            UmcDycMemberQryDetailAbilityReqBO umcDycMemberQryDetailAbilityReqBO = new UmcDycMemberQryDetailAbilityReqBO();
            umcDycMemberQryDetailAbilityReqBO.setMemId(Long.valueOf(receiverId));
            UmcDycMemberQryDetailAbilityRspBO umcDycMemberQryDetailAbilityRspBO = this.umcDycMemberQryDetailAbilityService.qryMemberDetail(umcDycMemberQryDetailAbilityReqBO);
            email = umcDycMemberQryDetailAbilityRspBO.getMemberBO().getRegEmail();
        } else {
            UmcQrySupplierLinkManAbilityReqBO umcReqBo = new UmcQrySupplierLinkManAbilityReqBO();
            umcReqBo.setSupplierId(Long.valueOf(fscOrderPO.getSupplierId()));
            log.info("\u67e5\u8be2\u4f9b\u5e94\u5546\u4f1a\u5458\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcReqBo));
            UmcQrySupplierLinkManAbilityRspBO umcRspBo = this.umcQrySupplierLinkManAbilityService.qrySupplierLinkMan(umcReqBo);
            log.info("\u67e5\u8be2\u4f9b\u5e94\u5546\u4f1a\u5458\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcRspBo));
            if (ObjectUtil.isNotEmpty((Object)umcRspBo) && !ObjectUtil.isEmpty((Object)umcRspBo.getUmcMemberBO())) {
                receiverId = String.valueOf(umcRspBo.getUmcMemberBO().getMemId());
                createOperName = umcRspBo.getUmcMemberBO().getMemName2();
                email = umcRspBo.getUmcMemberBO().getRegEmail();
            }
        }
        if (!ObjectUtil.isEmpty((Object)email)) {
            ArrayList<SendMessageReceiverBO> sendMessageReceiverBOList = new ArrayList<SendMessageReceiverBO>();
            SendMessageReceiverBO sendMessageReceiverBO = new SendMessageReceiverBO();
            sendMessageReceiverBO.setReceiverId(receiverId);
            sendMessageReceiverBO.setReceiverName(createOperName);
            sendMessageReceiverBO.setEMail(email);
            sendMessageReceiverBOList.add(sendMessageReceiverBO);
            sendMessageBO.setReceiverBOList(sendMessageReceiverBOList);
            sendMessageBOList.add(sendMessageBO);
            fscSendMessageAtomReqBO.setSendMessageBOList(sendMessageBOList);
            log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscSendMessageAtomReqBO));
            this.fscSendInvoiceMessageAtomService.sendMessageAtomService(fscSendMessageAtomReqBO);
        } else {
            log.info("\u672a\u67e5\u8be2\u5230\u90ae\u7bb1:\u63d2\u5165\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscInvoiceSyncReqBO));
        }
    }
}

