/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.FscBatchSyncOrderAbilityService;
import com.tydic.fsc.common.ability.api.FscComBankItemSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscBatchSyncOrderAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscBatchSyncOrderAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscBatchSyncEsRecordCreateBusiService;
import com.tydic.fsc.common.busi.bo.FscBatchSyncEsRecordCreateBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.FscRu;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscBatchSyncOrderAbilityService"})
public class FscBatchSyncOrderAbilityServiceImpl
implements FscBatchSyncOrderAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBatchSyncOrderAbilityServiceImpl.class);
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscComBankItemSyncAbilityService fscComBankItemSyncAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscBatchSyncEsRecordCreateBusiService fscBatchSyncEsRecordCreateBusiService;

    @PostMapping(value={"batchSyncOrder"})
    public FscBatchSyncOrderAbilityRspBO batchSyncOrder(@RequestBody FscBatchSyncOrderAbilityReqBO reqBO) {
        FscBatchSyncEsRecordCreateBusiReqBO recordCreateBusiReqBO = (FscBatchSyncEsRecordCreateBusiReqBO)((Object)FscRu.js((Object)reqBO, FscBatchSyncEsRecordCreateBusiReqBO.class));
        this.fscBatchSyncEsRecordCreateBusiService.batchSyncEsRecord(recordCreateBusiReqBO);
        FscBatchSyncOrderAbilityRspBO rspBO = new FscBatchSyncOrderAbilityRspBO();
        Long syncNum = 0L;
        if (ObjectUtil.isEmpty((Object)reqBO.getFscOrderIds()) && ObjectUtil.isEmpty((Object)reqBO.getBankCheckIdList())) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setPurchaserId(reqBO.getPurchaserId());
            if (null != reqBO.getSupplierId() && FscConstants.OrderFlow.PAY.equals(reqBO.getType())) {
                fscOrderPO.setPayeeId(reqBO.getSupplierId());
            } else {
                fscOrderPO.setSupplierId(reqBO.getSupplierId());
            }
            fscOrderPO.setSecondOrgId(reqBO.getSecondOrgId());
            fscOrderPO.setOrderNo(reqBO.getOrderNo());
            fscOrderPO.setCreateTimeStart(reqBO.getCreateTimeStart());
            fscOrderPO.setCreateTimeEnd(reqBO.getCreateTimeEnd());
            fscOrderPO.setOrderState(reqBO.getOrderState());
            fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
            if (reqBO.getAllDate().equals(0)) {
                switch (reqBO.getType()) {
                    case 10: {
                        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE_APPROVAL);
                        break;
                    }
                    case 0: {
                        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.INVOICE);
                        break;
                    }
                    case 1: {
                        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
                        break;
                    }
                    case 2: {
                        fscOrderPO.setOrderFlow(FscConstants.OrderFlow.MONTH_SERVICE_FEE);
                        break;
                    }
                }
            }
            int pageSize = 1000;
            int pageNo = 1;
            while (pageSize >= 1000) {
                Page page = new Page(pageNo, 1000);
                List fscOrderPOList = this.fscOrderMapper.getListPage(fscOrderPO, page);
                log.info("\u9875\u7801\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)page));
                pageSize = ObjectUtil.isEmpty((Object)fscOrderPOList) ? 0 : fscOrderPOList.size();
                ++pageNo;
                syncNum = syncNum + (long)fscOrderPOList.size();
                for (FscOrderPO fscOrder : fscOrderPOList) {
                    this.syncOrder(fscOrder.getFscOrderId(), reqBO.getSysTenantId());
                }
            }
        } else if (ObjectUtil.isNotEmpty((Object)reqBO.getFscOrderIds())) {
            for (Long fscOrderId : reqBO.getFscOrderIds()) {
                this.syncOrder(fscOrderId, reqBO.getSysTenantId());
            }
        }
        if (ObjectUtil.isNotEmpty((Object)reqBO.getBankCheckIdList())) {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setBankCheckIdList(reqBO.getBankCheckIdList());
            fscComOrderListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
            this.fscComBankItemSyncAbilityService.dealBankCheckItemSyncEs(fscComOrderListSyncAbilityReqBO);
        }
        rspBO.setSyncNum(syncNum);
        return rspBO;
    }

    private void syncOrder(Long fscOrderId, Long sysTenantId) {
        try {
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
            fscComOrderListSyncAbilityReqBO.setSysTenantId(sysTenantId);
            this.fscComOrderSyncAbilityService.dealComOrderCopySyncEs(fscComOrderListSyncAbilityReqBO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

