/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.FscCashierDataBO;
import com.tydic.fsc.bo.FscCashierRelDataBo;
import com.tydic.fsc.common.ability.api.FscCashierDetailQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscCashierDetailQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCashierDetailQryAbilityRspBO;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDicDictionaryPO;
import com.tydic.fsc.util.FscRspUtil;
import com.tydic.payment.pay.atom.CashierPayMethodRelAtomService;
import com.tydic.payment.pay.atom.PayMethodAtomService;
import com.tydic.payment.pay.atom.PaymentInsAtomService;
import com.tydic.payment.pay.dao.CashierTemplateMapper;
import com.tydic.payment.pay.dao.po.CashierPayMethodRelPageReqPO;
import com.tydic.payment.pay.dao.po.CashierPayMethodRelPo;
import com.tydic.payment.pay.dao.po.CashierTemplatePo;
import com.tydic.payment.pay.dao.po.PayMethodPo;
import com.tydic.payment.pay.dao.po.PaymentInsPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscCashierDetailQryAbilityService"})
public class FscCashierDetailQryAbilityServiceImpl
implements FscCashierDetailQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscCashierDetailQryAbilityServiceImpl.class);
    @Autowired
    private CashierTemplateMapper cashierTemplateMapper;
    @Autowired
    private CashierPayMethodRelAtomService cashierPayMethodRelAtomService;
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;
    @Autowired
    private PayMethodAtomService payMethodAtomService;
    @Autowired
    private PaymentInsAtomService paymentInsAtomService;

    @PostMapping(value={"queryCashierDetail"})
    public FscCashierDetailQryAbilityRspBO queryCashierDetail(@RequestBody FscCashierDetailQryAbilityReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("=========\u6536\u94f6\u53f0\u8be6\u60c5\u67e5\u8be2\u5f00\u59cb\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        if (null == reqBO.getCashierTemplate()) {
            throw new FscBusinessException("191112", "\u6536\u94f6\u53f0\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscCashierDetailQryAbilityRspBO retBo = (FscCashierDetailQryAbilityRspBO)FscRspUtil.getSuccessRspBo(FscCashierDetailQryAbilityRspBO.class);
        FscCashierDataBO cashierDataBo = new FscCashierDataBO();
        List<Object> rows = new ArrayList();
        retBo.setRows(rows);
        retBo.setCashierBaseInfo(cashierDataBo);
        retBo.setPageNo(reqBO.getPageNo());
        CashierTemplatePo cashierPo = this.cashierTemplateMapper.queryCashierTemplateById(reqBO.getCashierTemplate());
        if (cashierPo == null) {
            throw new FscBusinessException("191112", "\u672a\u67e5\u8be2\u5230\u6a21\u677f\u4fe1\u606f");
        }
        Map<String, Map<String, String>> dicMap = this.getDicMap(reqBO);
        BeanUtils.copyProperties((Object)cashierPo, (Object)cashierDataBo);
        cashierDataBo.setReqWayDesc(dicMap.get("CASHIER_REQ_WAY").get(cashierPo.getReqWay()));
        cashierDataBo.setFlagDesc(dicMap.get("CASHIER_TEMPLATE_FLAG").get(cashierPo.getFlag()));
        cashierDataBo.setCreateOperName(cashierPo.getCreateOperId());
        cashierDataBo.setUpdateOperName(cashierPo.getUpdateOperId());
        Page<CashierPayMethodRelPageReqPO> page = this.getPage(reqBO);
        CashierPayMethodRelPageReqPO relPayMethodPo = new CashierPayMethodRelPageReqPO();
        relPayMethodPo.setCashierTemplate(reqBO.getCashierTemplate());
        List relPayMethods = this.cashierPayMethodRelAtomService.queryPayMethodRelCashierWithPage(page, relPayMethodPo);
        if (CollectionUtils.isEmpty((Collection)relPayMethods)) {
            log.info("=========\u6ca1\u6709\u67e5\u8be2\u5230\u6536\u94f6\u53f0[{}]\u5173\u8054\u7684\u652f\u4ed8\u65b9\u5f0f", (Object)reqBO.getCashierTemplate());
            return retBo;
        }
        rows = this.assignRows(relPayMethods);
        retBo.setRows(rows);
        retBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        retBo.setTotal(Integer.valueOf(page.getTotalPages()));
        if (log.isDebugEnabled()) {
            log.debug("=========\u6536\u94f6\u53f0\u8be6\u60c5\u67e5\u8be2\u7ed3\u675f\uff1a{}", (Object)JSON.toJSONString((Object)retBo));
        }
        return retBo;
    }

    private List<FscCashierRelDataBo> assignRows(List<CashierPayMethodRelPo> relPayMethods) {
        ArrayList<FscCashierRelDataBo> rows = new ArrayList<FscCashierRelDataBo>();
        List payMethods = relPayMethods.stream().map(item -> item.getPayMethod()).collect(Collectors.toList());
        List payMethodPos = this.payMethodAtomService.queryPayMethodByMethods(payMethods);
        if (CollectionUtils.isEmpty((Collection)payMethodPos)) {
            return rows;
        }
        Map<Long, String> payMethodMap = payMethodPos.stream().collect(Collectors.toMap(PayMethodPo::getPayMethod, PayMethodPo::getPayMethodName));
        Map<Long, Long> relPayMethodInsMap = payMethodPos.stream().collect(Collectors.toMap(PayMethodPo::getPayMethod, PayMethodPo::getPaymentInsId));
        List paymentIns = payMethodPos.stream().map(item -> item.getPaymentInsId()).collect(Collectors.toList());
        List paymentInsPos = this.paymentInsAtomService.queryPaymentInfByInss(paymentIns);
        Map<Long, String> paymentInsMap = paymentInsPos.stream().collect(Collectors.toMap(PaymentInsPo::getPaymentInsId, item -> item.getPaymentInsName()));
        if (CollectionUtils.isEmpty(relPayMethodInsMap)) {
            return rows;
        }
        for (CashierPayMethodRelPo relPo : relPayMethods) {
            FscCashierRelDataBo dataBO = new FscCashierRelDataBo();
            BeanUtils.copyProperties((Object)relPo, (Object)dataBO);
            dataBO.setPayMethodName(payMethodMap.get(relPo.getPayMethod()));
            dataBO.setPaymentInsId(relPayMethodInsMap.get(relPo.getPayMethod()));
            dataBO.setPaymentInsName(paymentInsMap.get(relPayMethodInsMap.get(relPo.getPayMethod())));
            rows.add(dataBO);
        }
        return rows;
    }

    private Page<CashierPayMethodRelPageReqPO> getPage(FscCashierDetailQryAbilityReqBO reqBO) {
        Page page;
        if (reqBO.getPageNo() > 1) {
            page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBO, (Object)page);
            if (page.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (page.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        return page;
    }

    private Map<String, Map<String, String>> getDicMap(FscCashierDetailQryAbilityReqBO reqBO) {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> dicPCodes = new ArrayList<String>();
        dicPCodes.add("CASHIER_REQ_WAY");
        dicPCodes.add("CASHIER_TEMPLATE_FLAG");
        FscDicDictionaryPO queryPo = new FscDicDictionaryPO();
        queryPo.setSysCode("FSC");
        queryPo.setSysTenantId(reqBO.getSysTenantId());
        for (String pCode : dicPCodes) {
            queryPo.setPCode(pCode);
            queryPo.setSysTenantId(reqBO.getSysTenantId());
            List dicDictionaryPos = this.fscDicDictionaryMapper.getListByCondition(queryPo);
            Map<String, String> map = dicDictionaryPos.stream().collect(Collectors.toMap(FscDicDictionaryPO::getCode, fscDicDictionaryPO -> fscDicDictionaryPO.getTitle()));
            dicMap.put(pCode, map);
        }
        return dicMap;
    }
}

