/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.FscCheckBankItemToEsTaskAbilityService;
import com.tydic.fsc.common.ability.api.FscCheckBankItemToEsTaskChangeDataSourceAbilityService;
import com.tydic.fsc.common.ability.api.FscComBankItemSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscCheckBankItemToEsTaskAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCheckBankItemToEsTaskAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.util.DateUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscCheckBankItemToEsTaskAbilityService"})
public class FscCheckBankItemToEsTaskAbilityServiceImpl
implements FscCheckBankItemToEsTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscCheckBankItemToEsTaskAbilityServiceImpl.class);
    @Autowired
    private FscCheckBankItemToEsTaskChangeDataSourceAbilityService fscCheckBankItemToEsTaskChangeDataSourceAbilityService;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscComBankItemSyncAbilityService fscComBankItemSyncAbilityService;
    @Value(value="${crc.sys.tenant.id:305775845729763327}")
    private Long crcSysTenantId;

    @PostMapping(value={"checkBankItemToEsTask"})
    public FscCheckBankItemToEsTaskAbilityRspBO checkBankItemToEsTask(@RequestBody FscCheckBankItemToEsTaskAbilityReqBO reqBO) {
        FscCheckBankItemToEsTaskAbilityRspBO rspBO = new FscCheckBankItemToEsTaskAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.fscCheckBankItemToEsTaskChangeDataSourceAbilityService.checkBankItemToEsTask(reqBO);
        if (ObjectUtil.isEmpty((Object)reqBO.getSysTenantId()) || !this.crcSysTenantId.equals(reqBO.getSysTenantId())) {
            return rspBO;
        }
        LocalDateTime startOfDay = LocalDateTime.now().minusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        LocalDateTime endOfDay = startOfDay.withHour(23).withMinute(59).withSecond(59).withNano(999999999);
        ZoneId zone = ZoneId.of("Asia/Shanghai");
        Date startDate = ObjectUtil.isEmpty((Object)reqBO.getStartDate()) ? Date.from(startOfDay.atZone(zone).toInstant()) : DateUtil.strToDate((String)reqBO.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss");
        Date endDate = ObjectUtil.isEmpty((Object)reqBO.getEndDate()) ? Date.from(endOfDay.atZone(zone).toInstant()) : DateUtil.strToDate((String)reqBO.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss");
        FscBalancePO fscBalancePO = new FscBalancePO();
        fscBalancePO.setWithdrawalTimeStar(startDate);
        fscBalancePO.setWithdrawalTimeEnd(endDate);
        fscBalancePO.setSysTenantId(reqBO.getSysTenantId());
        int pageSize = 100;
        int pageNo = 1;
        while (pageSize >= 100) {
            Page page = new Page(pageNo, 100);
            List balancePOList = this.fscBalanceMapper.getCheckList(fscBalancePO, page);
            pageSize = ObjectUtil.isEmpty((Object)balancePOList) ? 0 : balancePOList.size();
            ++pageNo;
            if (ObjectUtil.isEmpty((Object)balancePOList)) continue;
            Map<Long, List<FscBalancePO>> fscBalanceList = balancePOList.stream().collect(Collectors.groupingBy(FscBalancePO::getSourceSysTenantId));
            for (Map.Entry<Long, List<FscBalancePO>> entry : fscBalanceList.entrySet()) {
                List<FscBalancePO> tempList = entry.getValue();
                log.info("\u4f59\u989d\u6d41\u6c34\u79df\u6237id:{},\u6570\u636e\uff1a{}", (Object)entry.getKey(), (Object)JSON.toJSONString(tempList));
                List bankCheckIds = tempList.stream().map(FscBalancePO::getBankCheckId).collect(Collectors.toList());
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setBankCheckIdList(bankCheckIds);
                fscComOrderListSyncAbilityReqBO.setSysTenantId(Long.getLong(((Object)entry.getKey()).toString()));
                this.fscComBankItemSyncAbilityService.dealBankCheckItemSyncEs(fscComOrderListSyncAbilityReqBO);
            }
        }
        return rspBO;
    }
}

