/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComBankItemSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.consumer.bo.FscSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import java.util.Collection;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComBankItemSyncAbilityServiceImpl
implements FscComBankItemSyncAbilityService {
    @Resource(name="fscSyncBankItemMqServiceProvider")
    private ProxyMessageProducer fscSyncBankItemMqServiceProvider;
    @Value(value="${es.FSC_SYNC_BANK_ITEM_TOPIC}")
    private String bankTopic;
    @Value(value="${es.FSC_SYNC_BANK_ITEM_TAG}")
    private String bankTag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    private void writeFailLog(FscComOrderListSyncAbilityReqBO reqBO, Long objId, String errDesc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(objId);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(errDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_BANK_CHECK_ITEM_SYNC_ES);
        fscOrderFailLogUpdateBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderFailLogUpdateBusiReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    public void dealBankCheckItemSyncEs(FscComOrderListSyncAbilityReqBO reqBO) {
        if (null != reqBO.getBankCheckId()) {
            FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
            fscSyncReqBO.setBankCheckId(reqBO.getBankCheckId());
            fscSyncReqBO.setSysTenantId(reqBO.getSysTenantId());
            ProxySendResult proxySendResult = this.fscSyncBankItemMqServiceProvider.send(new ProxyMessage(this.bankTopic, this.bankTag, JSONObject.toJSONString((Object)fscSyncReqBO)));
            if (!"SEND_OK".equals(proxySendResult.getStatus())) {
                this.writeFailLog(reqBO, reqBO.getBankCheckId(), JSONObject.toJSONString((Object)proxySendResult));
            }
        } else if (!CollectionUtils.isEmpty((Collection)reqBO.getBankCheckIdList())) {
            for (Long bankCheckId : reqBO.getBankCheckIdList()) {
                FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
                fscSyncReqBO.setBankCheckId(bankCheckId);
                fscSyncReqBO.setSysTenantId(reqBO.getSysTenantId());
                ProxySendResult proxySendResult = this.fscSyncBankItemMqServiceProvider.send(new ProxyMessage(this.bankTopic, this.bankTag, JSONObject.toJSONString((Object)fscSyncReqBO)));
                if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
                this.writeFailLog(reqBO, bankCheckId, JSONObject.toJSONString((Object)proxySendResult));
            }
        }
    }
}

