/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.base.FscRspBaseBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.api.FscUocOrderRelUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscUocOrderRelUpdateBusiReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderSyncCheckStatusReqBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocOrderSyncCheckStatusAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncRetransAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderSyncRetransAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderSyncRetransAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscBillMailSyncEsBusiService;
import com.tydic.fsc.common.busi.api.FscComInvoiceListSyncEsBusiService;
import com.tydic.fsc.common.busi.api.FscComOrderSyncEsBusiService;
import com.tydic.fsc.common.busi.api.FscEsSyncBillMailBusiService;
import com.tydic.fsc.common.busi.api.FscEsSyncComInvoiceBusiService;
import com.tydic.fsc.common.busi.api.FscEsSyncComOrderListBusiService;
import com.tydic.fsc.common.busi.bo.FscBillMailDetailBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscBillMailSyncRspBO;
import com.tydic.fsc.common.busi.bo.FscComInvoiceListEsSyncRspBO;
import com.tydic.fsc.common.busi.bo.FscComInvoiceListQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComInvoiceListSyncRspBO;
import com.tydic.fsc.common.busi.bo.FscComOrderListEsSyncRspBO;
import com.tydic.fsc.common.busi.bo.FscComOrderListQueryBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderSyncRspBO;
import com.tydic.fsc.common.consumer.bo.FscInvoiceSyncReqBO;
import com.tydic.fsc.common.consumer.bo.FscSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.FscOrderFailLogMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscCheckResultPO;
import com.tydic.fsc.po.FscOrderFailLogPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderSyncRetransAbilityService"})
public class FscComOrderSyncRetransAbilityServiceImpl
implements FscComOrderSyncRetransAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderSyncRetransAbilityServiceImpl.class);
    @Autowired
    private FscComOrderSyncEsBusiService fscComOrderSyncEsBusiService;
    @Autowired
    private FscEsSyncComOrderListBusiService fscEsSyncComOrderListBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderFailLogMapper fscOrderFailLogMapper;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscEsSyncComInvoiceBusiService fscEsSyncComInvoiceBusiService;
    @Autowired
    private FscComInvoiceListSyncEsBusiService fscComInvoiceListSyncEsBusiService;
    @Autowired
    private FscUocOrderRelUpdateBusiService fscUocOrderRelUpdateBusiService;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscUocOrderSyncCheckStatusAbilityService fscUocOrderSyncCheckStatusAbilityService;
    @Autowired
    private FscEsSyncBillMailBusiService fscEsSyncBillMailBusiService;
    @Autowired
    private FscBillMailSyncEsBusiService fscBillMailSyncEsBusiService;
    private static final String RESULT_NULL_QRY_ACCOUNT_CHECK = "\u67e5\u8be2\u5bf9\u8d26\u4fe1\u606f\u4e3a\u7a7a";

    @PostMapping(value={"dealRetrans"})
    public FscComOrderSyncRetransAbilityRspBO dealRetrans(@RequestBody FscComOrderSyncRetransAbilityReqBO reqBO) {
        FscOrderFailLogPO fscOrderFailLogPO = (FscOrderFailLogPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderFailLogPO.class);
        fscOrderFailLogPO.setDealStatus(FscConstants.FscOrderFailRetransDealStatus.WAIT_DEAL);
        ArrayList<Integer> busiTypes = new ArrayList<Integer>();
        busiTypes.add(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ES);
        busiTypes.add(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ORD);
        busiTypes.add(FscConstants.FscOrderFailRetansBusiType.ORDER_CHECK_STATUS_SYNC);
        busiTypes.add(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_INVOICE_SYNC_ES);
        fscOrderFailLogPO.setBusiTypes(busiTypes);
        List fscOrderFailLogPOS = this.fscOrderFailLogMapper.getList(fscOrderFailLogPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderFailLogPOS)) {
            for (FscOrderFailLogPO fscOrderFailLog : fscOrderFailLogPOS) {
                this.updateStatus(FscConstants.FscOrderFailRetransDealStatus.DEALLING, fscOrderFailLog.getId(), null, reqBO.getSysTenantId());
                FscRspBaseBO fscRspBaseBO = null;
                if (FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ES.equals(fscOrderFailLog.getBusiType())) {
                    fscRspBaseBO = this.dealFscOrderSyncEs(fscOrderFailLog);
                }
                if (FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_INVOICE_SYNC_ES.equals(fscOrderFailLog.getBusiType())) {
                    fscRspBaseBO = this.dealInvoiceSyncEs(fscOrderFailLog);
                }
                if (FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ORD.equals(fscOrderFailLog.getBusiType())) {
                    fscRspBaseBO = this.dealOrderSync(fscOrderFailLog);
                }
                if (FscConstants.FscOrderFailRetansBusiType.ORDER_CHECK_STATUS_SYNC.equals(fscOrderFailLog.getBusiType())) {
                    fscRspBaseBO = this.dealOrderCheckSync(fscOrderFailLog);
                }
                if (FscConstants.FscOrderFailRetansBusiType.FSC_INVOICE_MAIL_FAIL.equals(fscOrderFailLog.getBusiType())) {
                    fscRspBaseBO = this.dealOrderMailSync(fscOrderFailLog);
                }
                if (null != fscRspBaseBO) {
                    this.updateStatus(this.getDealStatus(fscRspBaseBO), fscOrderFailLog.getId(), fscRspBaseBO.getRespDesc(), reqBO.getSysTenantId());
                    continue;
                }
                this.updateStatus(FscConstants.FscOrderFailRetransDealStatus.WAIT_DEAL, fscOrderFailLog.getId(), null, reqBO.getSysTenantId());
            }
        }
        return new FscComOrderSyncRetransAbilityRspBO();
    }

    private void updateStatus(Integer status, Long id, String desc, Long sysTenantId) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setId(id);
        fscOrderFailLogUpdateBusiReqBO.setDealStatus(status);
        fscOrderFailLogUpdateBusiReqBO.setDealResultDesc(desc);
        fscOrderFailLogUpdateBusiReqBO.setSysTenantId(sysTenantId);
        this.fscOrderFailLogUpdateBusiService.dealUpdate(fscOrderFailLogUpdateBusiReqBO);
    }

    private Integer getDealStatus(FscRspBaseBO fscRspBaseBO) {
        if ("0000".equals(fscRspBaseBO.getRespCode())) {
            return FscConstants.FscOrderFailRetransDealStatus.SUCCESS;
        }
        return FscConstants.FscOrderFailRetransDealStatus.FAIL;
    }

    private FscRspBaseBO dealFscOrderSyncEs(FscOrderFailLogPO fscOrderFailLog) {
        if (null == fscOrderFailLog.getObjId()) {
            return null;
        }
        FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
        fscSyncReqBO.setFscOrderId(fscOrderFailLog.getObjId());
        fscSyncReqBO.setSysTenantId(fscOrderFailLog.getSysTenantId());
        FscComOrderListQueryBusiReqBO fscComOrderListQueryBusiReqBO = (FscComOrderListQueryBusiReqBO)JSON.parseObject((String)JSON.toJSONString((Object)fscSyncReqBO), FscComOrderListQueryBusiReqBO.class);
        FscComOrderSyncRspBO fscComOrderSyncRspBO = this.fscComOrderSyncEsBusiService.dealComOrderSyncEs(fscComOrderListQueryBusiReqBO);
        if (!"0000".equals(fscComOrderSyncRspBO.getRespCode())) {
            return fscComOrderSyncRspBO;
        }
        fscComOrderSyncRspBO.getFscComOrderListEsSyncReqBO().setSysTenantId(fscOrderFailLog.getSysTenantId());
        FscComOrderListEsSyncRspBO fscComOrderListEsSyncRspBO = this.fscEsSyncComOrderListBusiService.esSyncComOrderList(fscComOrderSyncRspBO.getFscComOrderListEsSyncReqBO());
        return fscComOrderListEsSyncRspBO;
    }

    private FscRspBaseBO dealInvoiceSyncEs(FscOrderFailLogPO fscOrderFailLog) {
        if (null == fscOrderFailLog.getObjId()) {
            return null;
        }
        FscInvoiceSyncReqBO fscInvoiceSyncReqBO = new FscInvoiceSyncReqBO();
        fscInvoiceSyncReqBO.setFscOrderId(fscOrderFailLog.getObjId());
        fscInvoiceSyncReqBO.setSysTenantId(fscOrderFailLog.getSysTenantId());
        FscComInvoiceListQueryBusiReqBO fscComInvoiceListQueryBusiReqBO = (FscComInvoiceListQueryBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)fscInvoiceSyncReqBO), FscComInvoiceListQueryBusiReqBO.class));
        FscComInvoiceListSyncRspBO fscComInvoiceListSyncRspBO = this.fscComInvoiceListSyncEsBusiService.dealBillInvoiceListSyncEs(fscComInvoiceListQueryBusiReqBO);
        if (!"0000".equals(fscComInvoiceListSyncRspBO.getRespCode())) {
            return fscComInvoiceListSyncRspBO;
        }
        fscComInvoiceListSyncRspBO.getFscOrderInvoiceEsSyncReqBOList().forEach(fscOrderInvoiceEsSyncReqBO -> fscOrderInvoiceEsSyncReqBO.setSysTenantId(fscOrderFailLog.getSysTenantId()));
        FscComInvoiceListEsSyncRspBO fscComInvoiceListEsSyncRspBO = this.fscEsSyncComInvoiceBusiService.esSyncBillInvoiceList(fscComInvoiceListSyncRspBO.getFscOrderInvoiceEsSyncReqBOList());
        return fscComInvoiceListEsSyncRspBO;
    }

    private FscRspBaseBO dealOrderSync(FscOrderFailLogPO fscOrderFailLog) {
        FscUocOrderRelUpdateBusiReqBO fscUocOrderRelUpdateBusiReqBO = new FscUocOrderRelUpdateBusiReqBO();
        fscUocOrderRelUpdateBusiReqBO.setFscOrderId(fscOrderFailLog.getObjId());
        fscUocOrderRelUpdateBusiReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        fscUocOrderRelUpdateBusiReqBO.setSyncOrderFlag(FscConstants.FscOrderFailRetansFlag.YES);
        fscUocOrderRelUpdateBusiReqBO.setSysTenantId(fscOrderFailLog.getSysTenantId());
        return this.fscUocOrderRelUpdateBusiService.dealRelUpdate(fscUocOrderRelUpdateBusiReqBO);
    }

    private FscRspBaseBO dealOrderCheckSync(FscOrderFailLogPO fscOrderFailLog) {
        FscCheckResultPO fscCheckResultPO = new FscCheckResultPO();
        fscCheckResultPO.setAcceptOrderId(fscOrderFailLog.getObjId());
        fscCheckResultPO.setSysTenantId(fscOrderFailLog.getSysTenantId());
        fscCheckResultPO = this.fscCheckResultMapper.getModelBy(fscCheckResultPO);
        if (null == fscCheckResultPO) {
            FscRspBaseBO fscRspBaseBO = new FscRspBaseBO();
            fscRspBaseBO.setRespCode("191136");
            fscRspBaseBO.setRespDesc(RESULT_NULL_QRY_ACCOUNT_CHECK);
            return fscRspBaseBO;
        }
        FscUocOrderSyncCheckStatusReqBO fscUocOrderSyncCheckStatusReqBO = new FscUocOrderSyncCheckStatusReqBO();
        fscUocOrderSyncCheckStatusReqBO.setCheckState(ObjectUtils.nullSafeEquals((Object)fscCheckResultPO.getAmount(), (Object)fscCheckResultPO.getOtherAmount()) ? FscConstants.BillCheck.EQUALS : FscConstants.BillCheck.NOT_EQUALS);
        fscUocOrderSyncCheckStatusReqBO.setInspectionVoucherId(fscCheckResultPO.getAcceptOrderId());
        fscUocOrderSyncCheckStatusReqBO.setOrderId(fscCheckResultPO.getOrderId());
        fscUocOrderSyncCheckStatusReqBO.setSysTenantId(fscOrderFailLog.getSysTenantId());
        return this.fscUocOrderSyncCheckStatusAbilityService.dealSyncCheckStatus(fscUocOrderSyncCheckStatusReqBO);
    }

    private FscRspBaseBO dealOrderMailSync(FscOrderFailLogPO fscOrderFailLog) {
        FscBillMailDetailBusiReqBO fscBillMailDetailBusiReqBO = new FscBillMailDetailBusiReqBO();
        fscBillMailDetailBusiReqBO.setFscOrderId(fscOrderFailLog.getObjId());
        fscBillMailDetailBusiReqBO.setSysTenantId(fscOrderFailLog.getSysTenantId());
        FscBillMailSyncRspBO fscBillMailSyncRspBO = this.fscBillMailSyncEsBusiService.dealBillMailSyncEs(fscBillMailDetailBusiReqBO);
        if (!"0000".equals(fscBillMailSyncRspBO.getRespCode())) {
            return fscBillMailSyncRspBO;
        }
        return this.fscEsSyncBillMailBusiService.esSyncBillMailList(fscBillMailSyncRspBO);
    }
}

