/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.fsc.busibase.external.api.pay.FscBToBPingAnBankCheckoutFuncService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankBindBankAccountRspBO;
import com.tydic.fsc.busibase.external.api.pay.bo.FscBToBPingAnBankCheckoutFuncReqBO;
import com.tydic.fsc.common.ability.bo.FscAccountAttachmentBO;
import com.tydic.fsc.common.busi.api.FscOpenMerchantPayeeBusiService;
import com.tydic.fsc.common.busi.api.FscQueryAccountFuncDetailBusiService;
import com.tydic.fsc.common.busi.bo.FscOpenMerchantPayeeBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscOpenMerchantPayeeBusiRspBO;
import com.tydic.fsc.common.busi.bo.FscQueryAccountFuncDetailBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscQueryAccountFuncDetailBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMemberAttachmentMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMemberAttachmentPO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscOpenMerchantPayeeBusiServiceImpl
implements FscOpenMerchantPayeeBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscOpenMerchantPayeeBusiServiceImpl.class);
    @Value(value="${PING_AN_BANK_UPLOAD_FILE_PATH:/bankUploadFile/}")
    private String PING_AN_BANK_UPLOAD_FILE_PATH;
    @Autowired
    private FscMemberAttachmentMapper fscMemberAttachmentMapper;
    @Autowired
    private FscBToBPingAnBankCheckoutFuncService fscBToBPingAnBankCheckoutFuncService;
    @Autowired
    private FscQueryAccountFuncDetailBusiService fscQueryAccountFuncDetailBusiService;
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FileClient fileClient;

    @Override
    public FscOpenMerchantPayeeBusiRspBO openMerchantPayee(FscOpenMerchantPayeeBusiReqBO reqBO) {
        FscOpenMerchantPayeeBusiRspBO rspBO = new FscOpenMerchantPayeeBusiRspBO();
        Long accountId = reqBO.getId();
        List<FscAccountAttachmentBO> attachmentList = reqBO.getAttachmentList();
        if (attachmentList.isEmpty()) {
            rspBO.setRespCode("0000");
            rspBO.setRespCode("\u672a\u4f20\u5165\u9644\u4ef6\u4fe1\u606f!");
            log.warn("\u5f00\u901a\u6536\u6b3e\u529f\u80fd\u672a\u4f20\u5165\u9644\u4ef6\u4fe1\u606f!");
            return rspBO;
        }
        for (FscAccountAttachmentBO fscAccountAttachmentBO : attachmentList) {
            int row;
            FscMemberAttachmentPO fscMemberAttachmentPO = new FscMemberAttachmentPO();
            fscMemberAttachmentPO.setAccountId(accountId);
            fscMemberAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            fscMemberAttachmentPO.setAttachmentName(fscAccountAttachmentBO.getAttachmentName());
            Integer attachmentType = fscAccountAttachmentBO.getAttachmentType();
            fscMemberAttachmentPO.setAttachmentType(attachmentType);
            String attachmentUrl = fscAccountAttachmentBO.getAttachmentUrl();
            fscMemberAttachmentPO.setAttachmentUrl(attachmentUrl);
            fscMemberAttachmentPO.setSysTenantId(reqBO.getSysTenantId());
            FscMemberAttachmentPO details = this.fscMemberAttachmentMapper.getDetailsByIdAndType(fscMemberAttachmentPO);
            if (attachmentType == 1) {
                this.downLoadFile(attachmentUrl, "001_B_yyzz.jpg", reqBO.getOrgId());
            }
            if (attachmentType == 2) {
                this.downLoadFile(attachmentUrl, "002_F_sfz.jpg", reqBO.getOrgId());
            }
            if (attachmentType == 3) {
                this.downLoadFile(attachmentUrl, "003_F_sfz.jpg", reqBO.getOrgId());
            }
            if (attachmentType == 4) {
                this.downLoadFile(attachmentUrl, "004_J_sfz.jpg", reqBO.getOrgId());
            }
            if (attachmentType == 5) {
                this.downLoadFile(attachmentUrl, "005_J_sfz.jpg", reqBO.getOrgId());
            }
            if (null == details) {
                fscMemberAttachmentPO.setSysTenantId(reqBO.getSysTenantId());
                fscMemberAttachmentPO.setSysTenantName(reqBO.getSysTenantName());
                row = this.fscMemberAttachmentMapper.insert(fscMemberAttachmentPO);
            } else {
                row = this.fscMemberAttachmentMapper.update(fscMemberAttachmentPO);
            }
            if (row >= 1) continue;
            throw new FscBusinessException("\u5931\u8d25", "\u7cfb\u7edf\u5f02\u5e38!");
        }
        FscBToBPingAnBankBindBankAccountRspBO fscBToBPingAnBankBindBankAccountRspBO = this.binkRelated(reqBO);
        if (!"0000".equals(fscBToBPingAnBankBindBankAccountRspBO.getRespCode())) {
            throw new FscBusinessException("193209", fscBToBPingAnBankBindBankAccountRspBO.getRespDesc());
        }
        FscAccountPO fscAccountPO = new FscAccountPO();
        fscAccountPO.setId(reqBO.getId());
        fscAccountPO.setB2bStatus(FscConstants.AccountBtoBStatus.OPENING);
        fscAccountPO.setFrontSeqNo(fscBToBPingAnBankBindBankAccountRspBO.getFrontSeqNo());
        fscAccountPO.setSysTenantId(reqBO.getSysTenantId());
        int i = this.fscAccountMapper.updateById(fscAccountPO);
        if (i < 1) {
            log.error("\u4fee\u6539\u8d26\u6237\u6536\u6b3e\u5f00\u901a\u529f\u80fd\u72b6\u6001\u5931\u8d25");
            throw new FscBusinessException("\u5931\u8d25", "\u7cfb\u7edf\u5f02\u5e38!\u63d2\u5165\u6216\u66f4\u65b0\u6587\u4ef6\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6536\u6b3e\u529f\u80fd\u5f00\u901a\u6210\u529f!");
        return rspBO;
    }

    public FscBToBPingAnBankBindBankAccountRspBO binkRelated(FscOpenMerchantPayeeBusiReqBO reqBO) {
        FscQueryAccountFuncDetailBusiReqBO bo = new FscQueryAccountFuncDetailBusiReqBO();
        bo.setId(reqBO.getId());
        bo.setSysTenantId(reqBO.getSysTenantId());
        FscQueryAccountFuncDetailBusiRspBO fscQueryAccountFuncDetailBusiRspBO = this.fscQueryAccountFuncDetailBusiService.queryAccountFuncDetail(bo);
        FscBToBPingAnBankCheckoutFuncReqBO fscBToBPingAnBankCheckoutFuncReqBO = new FscBToBPingAnBankCheckoutFuncReqBO();
        fscBToBPingAnBankCheckoutFuncReqBO.setMemberSubAcctNo(fscQueryAccountFuncDetailBusiRspBO.getSubAccountNo());
        fscBToBPingAnBankCheckoutFuncReqBO.setTranNetMemberCode(fscQueryAccountFuncDetailBusiRspBO.getLegalOrgId());
        fscBToBPingAnBankCheckoutFuncReqBO.setImageMaterialFlag("Y");
        fscBToBPingAnBankCheckoutFuncReqBO.setOrgId(reqBO.getOrgId());
        fscBToBPingAnBankCheckoutFuncReqBO.setSysTenantId(reqBO.getSysTenantId());
        FscBToBPingAnBankBindBankAccountRspBO fscBToBPingAnBankBindBankAccountRspBO = this.fscBToBPingAnBankCheckoutFuncService.checkoutFunc(fscBToBPingAnBankCheckoutFuncReqBO);
        if (!"0000".equals(fscBToBPingAnBankBindBankAccountRspBO.getRespCode())) {
            throw new FscBusinessException("193209", fscBToBPingAnBankBindBankAccountRspBO.getRespDesc());
        }
        return fscBToBPingAnBankBindBankAccountRspBO;
    }

    private void downLoadFile(String filePath, String name, Long orgId) {
        try {
            int L;
            log.debug("\u4e0b\u8f7d\u9644\u4ef6\u6587\u4ef6\uff1a{}", (Object)name);
            log.info("\u9644\u4ef6\u4e0b\u8f7d\u8def\u5f84\uff1a{}", (Object)filePath);
            String[] pad = filePath.split("group");
            filePath = "group" + pad[1].replaceFirst("/", ",");
            InputStream in = this.fileClient.downLoadToInputStream(filePath);
            File file = new File(this.PING_AN_BANK_UPLOAD_FILE_PATH + "/" + orgId + "/" + name);
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            log.info("\u6587\u4ef6\u8def\u5f84\u4e3a:{}", (Object)file.getPath());
            FileOutputStream fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((L = in.read(buffer)) != -1) {
                fos.write(buffer, 0, L);
            }
            in.close();
            fos.close();
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\u4fe1\u606f:" + e.getMessage());
            throw new FscBusinessException("\u5931\u8d25", "\u6587\u4ef6\u4e0b\u8f7d\u51fa\u9519!");
        }
    }
}

