/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.FscQueryRefundBankFilePageListAbilityService;
import com.tydic.fsc.common.ability.bo.FscBankCheckAbilityBO;
import com.tydic.fsc.common.ability.bo.FscQueryRefundBankFilePageListAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscQueryRefundBankFilePageListAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscOrderPO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscQueryRefundBankFilePageListAbilityService"})
public class FscQueryRefundBankFilePageListAbilityServiceImpl
implements FscQueryRefundBankFilePageListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscQueryRefundBankFilePageListAbilityServiceImpl.class);
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @PostMapping(value={"queryRefundBankFilePageList"})
    public FscQueryRefundBankFilePageListAbilityRspBO queryRefundBankFilePageList(@RequestBody FscQueryRefundBankFilePageListAbilityReqBO reqBO) {
        List fscOrderPOList;
        List fscBankCheckFileItemPOList;
        FscQueryRefundBankFilePageListAbilityRspBO rspBO = new FscQueryRefundBankFilePageListAbilityRspBO();
        List rows = new ArrayList();
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize().intValue());
        page.setPageNo(reqBO.getPageNo().intValue());
        FscBankCheckFileItemPO fscBankCheckFileItemPO = (FscBankCheckFileItemPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBankCheckFileItemPO.class);
        if (reqBO.getRefundStateList().contains(FscConstants.REFUND_STATE.COMPLETE)) {
            fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getFinishRefundBankFileItemList(fscBankCheckFileItemPO, page);
            if (!ObjectUtil.isEmpty((Object)fscBankCheckFileItemPOList)) {
                rows = JSON.parseArray((String)JSON.toJSONString((Object)fscBankCheckFileItemPOList), FscBankCheckAbilityBO.class);
            }
        } else {
            if (!ObjectUtil.isEmpty((Object)reqBO.getClaimNumber())) {
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setReimburseNo(reqBO.getClaimNumber());
                fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
                fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
                if (!ObjectUtil.isEmpty((Object)fscOrderPOList)) {
                    List orderNoList = fscOrderPOList.stream().map(FscOrderPO::getOrderNo).collect(Collectors.toList());
                    fscBankCheckFileItemPO.setOrderNoList(orderNoList);
                }
            }
            if (!ObjectUtil.isEmpty((Object)reqBO.getClaimLineNumber())) {
                FscBankCheckFileItemPO fscBankCheckFileItemPO1 = new FscBankCheckFileItemPO();
                fscBankCheckFileItemPO1.setPlanNo(reqBO.getClaimLineNumber());
                fscBankCheckFileItemPO1.setSysTenantId(reqBO.getSysTenantId());
                List fscBankCheckFileItemPOList2 = this.fscBankCheckFileItemMapper.getZdBankFileItemList(fscBankCheckFileItemPO1);
                if (!ObjectUtil.isEmpty((Object)fscBankCheckFileItemPOList2)) {
                    List bankCheckIds = fscBankCheckFileItemPOList2.stream().map(FscBankCheckFileItemPO::getBankCheckId).collect(Collectors.toList());
                    fscBankCheckFileItemPO.setBankCheckIdS(bankCheckIds);
                }
            }
            fscBankCheckFileItemPO.setRefundStateList(Arrays.asList(0));
            fscBankCheckFileItemPO.setSysTenantId(reqBO.getSysTenantId());
            fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getRefundBankFileItemList(fscBankCheckFileItemPO, page);
            if (!ObjectUtil.isEmpty((Object)fscBankCheckFileItemPOList)) {
                rows = JSON.parseArray((String)JSON.toJSONString((Object)fscBankCheckFileItemPOList), FscBankCheckAbilityBO.class);
            }
        }
        if (!ObjectUtil.isEmpty(rows)) {
            Set shouldPayNos = rows.stream().map(FscBankCheckAbilityBO::getShouldPayNo).collect(Collectors.toSet());
            fscOrderPOList = new ArrayList();
            if (!ObjectUtil.isEmpty(shouldPayNos)) {
                FscOrderPO fscOrderPO = new FscOrderPO();
                fscOrderPO.setOrderNos(new ArrayList(shouldPayNos));
                fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
                fscOrderPOList = this.fscOrderMapper.getList(fscOrderPO);
            }
            SimpleDateFormat inputFormat = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat outputFormat = new SimpleDateFormat("yyyy-MM-dd");
            block2: for (FscBankCheckAbilityBO item : rows) {
                item.setTradeAmt(item.getTradeAmt().setScale(2));
                if (ObjectUtil.isEmpty((Object)item.getPayeeBankName())) {
                    item.setPayeeBankName("\u5e73\u5b89\u94f6\u884c");
                }
                try {
                    Date date = inputFormat.parse(item.getTradeDate());
                    String formattedDate = outputFormat.format(date);
                    item.setTradeDate(formattedDate);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                if (ObjectUtil.isNotEmpty((Object)item.getShouldPayNo())) {
                    FscOrderPO fscOrderPO = new FscOrderPO();
                    fscOrderPO.setOrderNo(item.getShouldPayNo());
                    fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
                    fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
                    item.setClaimNumber(ObjectUtil.isEmpty((Object)fscOrderPO) ? "" : (ObjectUtil.isEmpty((Object)fscOrderPO.getReimburseNo()) ? "" : fscOrderPO.getReimburseNo()));
                }
                if (!ObjectUtil.isEmpty((Object)item.getSourceType()) && item.getSourceType().equals("1")) {
                    FscBankCheckFileItemPO fscBankCheckFileItemPO1 = new FscBankCheckFileItemPO();
                    fscBankCheckFileItemPO1.setBankCheckId(item.getBankCheckId());
                    fscBankCheckFileItemPO1.setSysTenantId(reqBO.getSysTenantId());
                    List fscBankCheckFileItemPOList3 = this.fscBankCheckFileItemMapper.getZdBankFileItemList(fscBankCheckFileItemPO1);
                    item.setClaimLineNumber(ObjectUtil.isEmpty((Object)fscBankCheckFileItemPOList3) ? "" : ((FscBankCheckFileItemPO)fscBankCheckFileItemPOList3.get(0)).getPlanNo());
                }
                if (ObjectUtil.isEmpty(fscOrderPOList) || ObjectUtil.isEmpty((Object)item.getShouldPayNo())) continue;
                for (FscOrderPO order : fscOrderPOList) {
                    if (!order.getOrderNo().equals(item.getShouldPayNo())) continue;
                    item.setFscOrderId(order.getFscOrderId());
                    item.setFscOrderNo(order.getOrderNo());
                    continue block2;
                }
            }
        }
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRows(rows);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

