/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscSyncSendTodoAbilityService;
import com.tydic.fsc.common.ability.bo.FscSyncSendTodoAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscSyncSendTodoAbilityServiceImpl
implements FscSyncSendTodoAbilityService {
    @Resource(name="fscSyncSendTodoServiceProvider")
    private ProxyMessageProducer fscSyncSendTodoServiceProvider;
    @Value(value="${FSC_SYNC_SEND_TODO_TOPIC:FSC_SYNC_SEND_TODO_TOPIC}")
    private String topic;
    @Value(value="${FSC_SYNC_SEND_TODO_TAG:FSC_SYNC_SEND_TODO_TAG}")
    private String tag;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    public void syncSendTodo(FscSyncSendTodoAbilityReqBO reqBO) {
        ProxySendResult proxySendResult = this.fscSyncSendTodoServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)reqBO)));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeFailLog(reqBO, JSONObject.toJSONString((Object)proxySendResult));
        }
    }

    private void writeFailLog(FscSyncSendTodoAbilityReqBO reqBO, String errDesc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(reqBO.getFscOrderId());
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(errDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ES);
        fscOrderFailLogUpdateBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderFailLogUpdateBusiReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

