/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscBalanceBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.common.ability.api.FscWillCreateFscBalanceQryAbilityService;
import com.tydic.fsc.common.ability.bo.FscWillCreateFscBalanceQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscWillCreateFscBalanceQryAbilityRspBO;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscWillCreateFscBalanceQryAbilityService"})
public class FscWillCreateFscBalanceQryAbilityServiceImpl
implements FscWillCreateFscBalanceQryAbilityService {
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;

    @PostMapping(value={"willCreateFscBalanceQry"})
    public FscWillCreateFscBalanceQryAbilityRspBO willCreateFscBalanceQry(@RequestBody FscWillCreateFscBalanceQryAbilityReqBO reqBO) {
        FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
        if (!ObjectUtils.isEmpty((Object)reqBO.getCreateTimeStart()) || !ObjectUtils.isEmpty((Object)reqBO.getCreateTimeEnd())) {
            fscBankCheckFileItemPO.setCreateTimeStart(reqBO.getCreateTimeStart());
            fscBankCheckFileItemPO.setCreateTimeEnd(reqBO.getCreateTimeEnd());
        } else {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -1);
            fscBankCheckFileItemPO.setCreateTimeStart(formatter.format(calendar.getTime()));
            fscBankCheckFileItemPO.setCreateTimeEnd(formatter.format(new Date(System.currentTimeMillis())));
        }
        List fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getSpecialList(fscBankCheckFileItemPO);
        ArrayList<FscBalanceBO> willfscBalanceList = new ArrayList<FscBalanceBO>();
        if (!CollectionUtils.isEmpty((Collection)fscBankCheckFileItemPOList)) {
            for (FscBankCheckFileItemPO each : fscBankCheckFileItemPOList) {
                FscBalanceBO fscBalanceBO = new FscBalanceBO();
                fscBalanceBO.setBalanceId(Long.valueOf(Sequence.getInstance().nextId()));
                fscBalanceBO.setBankCheckId(each.getBankCheckId());
                fscBalanceBO.setOrgId(each.getPayeeId());
                fscBalanceBO.setOrgCode("");
                fscBalanceBO.setOrgName(each.getPayeeName());
                fscBalanceBO.setSubAccountNo(each.getPayeeAccountNo());
                fscBalanceBO.setPayerOrgId(each.getPayerId());
                fscBalanceBO.setPayerOrgName(each.getPayerName());
                fscBalanceBO.setPayerOrgCode(null);
                fscBalanceBO.setPayerSubAccountNo(null);
                fscBalanceBO.setFrozenEndTime(this.getConfiguration(each.getPayeeId().toString(), each.getSysTenantId()));
                fscBalanceBO.setCreateTime(new Date());
                fscBalanceBO.setPayAmount(each.getTradeAmt());
                if (fscBalanceBO.getFrozenEndTime().compareTo(new Date()) <= 0) {
                    fscBalanceBO.setFrozenAmount(new BigDecimal(0));
                    fscBalanceBO.setUsableAmount(each.getTradeAmt());
                    fscBalanceBO.setThawOperTime(new Date());
                } else {
                    fscBalanceBO.setFrozenAmount(each.getTradeAmt());
                    fscBalanceBO.setUsableAmount(new BigDecimal(0));
                }
                fscBalanceBO.setUsedAmount(new BigDecimal(0));
                willfscBalanceList.add(fscBalanceBO);
            }
        }
        FscWillCreateFscBalanceQryAbilityRspBO rspBO = new FscWillCreateFscBalanceQryAbilityRspBO();
        rspBO.setWillfscBalanceList(willfscBalanceList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Date getConfiguration(String relId, Long sysTenantId) {
        Calendar curDate = Calendar.getInstance();
        curDate.setTime(new Date());
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("cash_withdrawal");
        fscCfcUniteParamQryListDetailExternalReqBO.setRelId(relId);
        fscCfcUniteParamQryListDetailExternalReqBO.setSysTenantId(sysTenantId);
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191014", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        Integer advanceUnfreezeDays = 0;
        Integer paymentDays = 0;
        Integer advanceWarningDays = 0;
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays())) {
            advanceUnfreezeDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceUnfreezeDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays())) {
            paymentDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getPaymentDays());
        }
        if (!StringUtils.isEmpty((Object)fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays())) {
            advanceWarningDays = Integer.parseInt(fscCfcUniteParamQryListDetailExternalRspBO.getAdvanceWarningDays());
        }
        curDate.add(5, paymentDays - advanceUnfreezeDays);
        return curDate.getTime();
    }
}

