/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.common.busi.api.FscCancelOrderByZdToSharedSendService;
import com.tydic.fsc.common.busi.bo.FscCancelOrderByZdToSharedSendReqBO;
import com.tydic.fsc.common.busi.bo.FscCancelOrderByZdToSharedSendRspBO;
import com.tydic.fsc.common.busi.bo.FscSendPaymentOrderByZdReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscOrderPO;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscCancelOrderByZdToSharedSendServiceImpl
implements FscCancelOrderByZdToSharedSendService {
    private static final Logger log = LoggerFactory.getLogger(FscCancelOrderByZdToSharedSendServiceImpl.class);
    @Value(value="${FSC_FINANCIAL_SHARED_SEND_TOPIC:FSC_FINANCIAL_SHARED_SEND_TOPIC}")
    private String FSC_FINANCIAL_SHARED_SEND_TOPIC;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${secondOrgId.zd}")
    private Long SECONDORGID_ZD;
    @Resource(name="fscFinancialSharedSendProducer")
    private ProxyMessageProducer fscFinancialSharedSendProducer;

    @Override
    public FscCancelOrderByZdToSharedSendRspBO cancelOrderByZdToSharedSend(FscCancelOrderByZdToSharedSendReqBO reqBO) {
        FscCancelOrderByZdToSharedSendRspBO rspBO = new FscCancelOrderByZdToSharedSendRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List fscOrderPOList = this.fscOrderMapper.getJSDbyFKDid(reqBO.getFscOrderId(), reqBO.getSysTenantId());
        if (ObjectUtil.isEmpty((Object)fscOrderPOList)) {
            rspBO.setRespDesc("\u4ed8\u6b3e\u5355\u67e5\u8be2\u7ed3\u7b97\u5355\u4e3a\u7a7a");
            return rspBO;
        }
        List secondOrgIds = fscOrderPOList.stream().map(FscOrderPO::getSecondOrgId).collect(Collectors.toList());
        List receiveTypeList = fscOrderPOList.stream().map(FscOrderPO::getReceiveType).collect(Collectors.toList());
        if (!secondOrgIds.contains(this.SECONDORGID_ZD)) {
            rspBO.setRespDesc("\u4ed8\u6b3e\u5355\u67e5\u8be2\u7ed3\u7b97\u5355\u4e0d\u5c5e\u4e8e\u7f6e\u5730");
            return rspBO;
        }
        if (!receiveTypeList.contains(FscConstants.FscOrderReceiveType.PURCHASE)) {
            rspBO.setRespDesc("\u4ed8\u6b3e\u5355\u67e5\u8be2\u7ed3\u7b97\u5355\u4e0d\u5c5e\u4e8e\u64ae\u5408\u6216\u8005\u91c7\u8d2d\u4e0a\u6e38\u7ed3\u7b97\u5355");
            return rspBO;
        }
        FscSendPaymentOrderByZdReqBO fscSendPaymentOrderByZdReqBO = new FscSendPaymentOrderByZdReqBO();
        fscSendPaymentOrderByZdReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscSendPaymentOrderByZdReqBO.setIsprofes("1");
        log.info("\u7f6e\u5730\u8ba2\u5355\u53d6\u6d88\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3mq\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)((Object)fscSendPaymentOrderByZdReqBO)));
        fscSendPaymentOrderByZdReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscSendPaymentOrderByZdReqBO.setSysTenantName(reqBO.getSysTenantName());
        ProxyMessage message = new ProxyMessage(this.FSC_FINANCIAL_SHARED_SEND_TOPIC, "*", JSON.toJSONString((Object)((Object)fscSendPaymentOrderByZdReqBO)));
        log.info("\u7f6e\u5730\u8ba2\u5355\u53d6\u6d88\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u4e2d\u5fc3mq\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)message));
        this.fscFinancialSharedSendProducer.send(message);
        return rspBO;
    }
}

