/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.common.busi.api.FscComBalanceTransferBusiService;
import com.tydic.fsc.common.busi.bo.FscComBalanceTransferBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComBalanceTransferBusiRspBO;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBalancePO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComBalanceTransferBusiServiceImpl
implements FscComBalanceTransferBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComBalanceTransferBusiServiceImpl.class);
    @Autowired
    private FscBalanceMapper fscBalanceMapper;

    @Override
    public FscComBalanceTransferBusiRspBO balanceTransfer(FscComBalanceTransferBusiReqBO reqBO) {
        log.debug("\u5224\u65ad\u662f\u5426\u8fd0\u8425\u5355\u4f4d:{}", (Object)reqBO.getIsprofess());
        if (!"0".equals(reqBO.getIsprofess())) {
            throw new FscBusinessException("198888", "\u60a8\u4e0d\u662f\u8fd0\u8425\u65b9,\u65e0\u6cd5\u6267\u884c\u5212\u8f6c\u8d44\u91d1\u64cd\u4f5c");
        }
        List fscBalancePOList = this.fscBalanceMapper.listByOrgId(reqBO.getTransferOrgId(), reqBO.getSysTenantId());
        log.debug("\u67e5\u8be2\u5230\u7684\u4f59\u989d\u4fe1\u606f\u4e3a:{}", (Object)fscBalancePOList);
        if (CollectionUtils.isEmpty((Collection)fscBalancePOList)) {
            throw new FscBusinessException("198888", "\u8be5\u8d26\u6237\u76ee\u524d\u6ca1\u6709\u4f59\u989d\u4fe1\u606f\u6570\u636e");
        }
        BigDecimal transferAmount = reqBO.getTransferAmount();
        BigDecimal totalFrozenAmount = this.fscBalanceMapper.sumAmount(reqBO.getTransferOrgId(), reqBO.getSysTenantId());
        log.debug("\u51bb\u7ed3\u8d44\u91d1\u603b\u8ba1\u4e3a:{}", (Object)totalFrozenAmount);
        if (BigDecimal.ZERO.equals(totalFrozenAmount) || transferAmount.compareTo(totalFrozenAmount) == 1) {
            throw new FscBusinessException("198888", "\u53ef\u5212\u8f6c\u8d44\u91d1\u4e0d\u8db3!");
        }
        FscBalancePO set = new FscBalancePO();
        for (FscBalancePO fscBalancePO : fscBalancePOList) {
            int updateRows;
            BigDecimal frozenAmount = fscBalancePO.getFrozenAmount();
            log.debug("\u5f53\u524d\u8bb0\u5f55\u51bb\u7ed3\u8d44\u91d1\u4e3a:{}", (Object)frozenAmount);
            if (transferAmount.compareTo(frozenAmount) == 1) {
                set.setFrozenAmount(BigDecimal.ZERO);
                set.setUsableAmount(fscBalancePO.getUsableAmount().add(frozenAmount));
                set.setOperId(reqBO.getUserId());
                set.setOperName(reqBO.getName());
                set.setThawOperTime(new Date());
                log.debug("\u4fee\u6539\u4f59\u989d\u6570\u636e\u4f20\u5165:{}", (Object)set);
                updateRows = this.fscBalanceMapper.updateBy(set, fscBalancePO);
                log.debug("\u4fee\u6539\u7684\u6570\u636e\u884c\u6570\u4e3a:{}", (Object)updateRows);
                transferAmount = transferAmount.subtract(frozenAmount);
                if (updateRows == 1) continue;
                throw new FscBusinessException("198888", "\u7cfb\u7edf\u5f02\u5e38,\u4f59\u989d\u7ba1\u7406\u6570\u636e\u4fee\u6539\u5f02\u5e38!");
            }
            set.setFrozenAmount(frozenAmount.subtract(transferAmount));
            set.setUsableAmount(fscBalancePO.getUsableAmount().add(transferAmount));
            set.setOperId(reqBO.getUserId());
            set.setOperName(reqBO.getName());
            set.setThawOperTime(new Date());
            log.debug("\u4fee\u6539\u4f59\u989d\u6570\u636e\u4f20\u5165:{}", (Object)set);
            updateRows = this.fscBalanceMapper.updateBy(set, fscBalancePO);
            log.debug("\u4fee\u6539\u7684\u6570\u636e\u884c\u6570\u4e3a:{}", (Object)updateRows);
            if (updateRows == 1) break;
            throw new FscBusinessException("198888", "\u7cfb\u7edf\u5f02\u5e38,\u4f59\u989d\u7ba1\u7406\u6570\u636e\u4fee\u6539\u5f02\u5e38!");
        }
        FscComBalanceTransferBusiRspBO rspBO = new FscComBalanceTransferBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5212\u8f6c\u8d44\u91d1\u6210\u529f!");
        return rspBO;
    }
}

