/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.fsc.common.busi.api.FscQueryCollectionFuncListBusiService;
import com.tydic.fsc.common.busi.bo.FscAccountAttachmentBO;
import com.tydic.fsc.common.busi.bo.FscQueryCollectionFuncListBO;
import com.tydic.fsc.common.busi.bo.FscQueryCollectionFuncListBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscQueryCollectionFuncListBusiRspBO;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.umc.general.ability.api.UmcQryMemLegalOrgInfoAbilityService;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceReqBO;
import com.tydic.umc.general.ability.bo.UmcQryMemLegalOrgInfoAbilityServiceRspBO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscQueryCollectionFuncListBusiServiceImpl
implements FscQueryCollectionFuncListBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscQueryCollectionFuncListBusiServiceImpl.class);
    @Autowired
    private UmcQryMemLegalOrgInfoAbilityService umcQryMemLegalOrgInfoAbilityService;
    @Autowired
    private FscAccountMapper fscAccountMapper;

    @Override
    public FscQueryCollectionFuncListBusiRspBO queryCollectionFuncList(FscQueryCollectionFuncListBusiReqBO reqBO) {
        String isprofess = reqBO.getIsprofess();
        FscQueryCollectionFuncListBusiRspBO rspBO = new FscQueryCollectionFuncListBusiRspBO();
        if ("0".equals(isprofess)) {
            List<FscQueryCollectionFuncListBO> detailsList = this.getDetailsList(null);
            rspBO.setAccountList(detailsList);
        } else if ("1".equals(isprofess) || "2".equals(isprofess)) {
            Long userId = reqBO.getUserId();
            UmcQryMemLegalOrgInfoAbilityServiceReqBO memLegalOrgInfo = new UmcQryMemLegalOrgInfoAbilityServiceReqBO();
            memLegalOrgInfo.setMemId(userId);
            memLegalOrgInfo.setCorporationId(reqBO.getOrgId());
            if (!ObjectUtil.isEmpty((Object)reqBO.getCorporationId())) {
                memLegalOrgInfo.setCorporationId(reqBO.getCorporationId());
            }
            log.info("\u8c03\u7528\u67e5\u8be2\u6cd5\u4eba\u4fe1\u606f\u670d\u52a1,\u5165\u53c2:{}", (Object)memLegalOrgInfo);
            UmcQryMemLegalOrgInfoAbilityServiceRspBO memLegalOrgInfoRspBO = this.umcQryMemLegalOrgInfoAbilityService.qryMemLegalOrgInfo(memLegalOrgInfo);
            log.info("\u8c03\u7528\u67e5\u8be2\u6cd5\u4eba\u4fe1\u606f\u670d\u52a1,\u51fa\u53c2:{}", (Object)memLegalOrgInfoRspBO);
            if (!"0000".equals(memLegalOrgInfoRspBO.getRespCode())) {
                throw new FscBusinessException(memLegalOrgInfoRspBO.getRespCode(), memLegalOrgInfoRspBO.getRespDesc());
            }
            if (null == memLegalOrgInfoRspBO) {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc("\u901a\u8fc7\u7528\u6237id(" + userId + ")\u672a\u67e5\u8be2\u5230\u6cd5\u4eba\u76f8\u5173\u4fe1\u606f");
                log.debug(rspBO.getRespDesc());
                return rspBO;
            }
            Long orgId = memLegalOrgInfoRspBO.getLegalOrgInfo().getOrgId();
            FscAccountPO fscAccountPO = new FscAccountPO();
            fscAccountPO.setOrgId(orgId);
            fscAccountPO.setSysTenantId(reqBO.getSysTenantId());
            List<FscQueryCollectionFuncListBO> detailsList = this.getDetailsList(fscAccountPO);
            rspBO.setAccountList(detailsList);
        }
        return rspBO;
    }

    private List<FscQueryCollectionFuncListBO> getDetailsList(FscAccountPO fscAccountPO) {
        ArrayList<FscQueryCollectionFuncListBO> accountList = new ArrayList<FscQueryCollectionFuncListBO>();
        List result = this.fscAccountMapper.getDetailsList(fscAccountPO);
        result.forEach(fscAccountDetailsPO -> {
            FscQueryCollectionFuncListBO fscQueryCollectionFuncListBO = new FscQueryCollectionFuncListBO();
            BeanUtils.copyProperties((Object)fscAccountDetailsPO, (Object)((Object)fscQueryCollectionFuncListBO));
            fscQueryCollectionFuncListBO.setAccountBtobStatus(fscAccountDetailsPO.getAccountBtobStatus() + "");
            ArrayList attachmentList = new ArrayList();
            List attachmentResultList = fscAccountDetailsPO.getAttachmentList();
            if (null != attachmentResultList) {
                attachmentResultList.forEach(fscMemberAttachmentPO -> {
                    FscAccountAttachmentBO fscAccountAttachmentBO = new FscAccountAttachmentBO();
                    fscAccountAttachmentBO.setAttachmentId(fscMemberAttachmentPO.getAttachmentId() + "");
                    BeanUtils.copyProperties((Object)fscMemberAttachmentPO, (Object)((Object)fscAccountAttachmentBO));
                    attachmentList.add(fscAccountAttachmentBO);
                    fscQueryCollectionFuncListBO.setAttachmentList(attachmentList);
                });
            }
            accountList.add(fscQueryCollectionFuncListBO);
        });
        return accountList;
    }
}

