/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocProOrderPaymentCallbackAbilityReqBO;
import com.tydic.fsc.busibase.external.api.uoc.FscUocProOrderPaymentCallbackAbilityService;
import com.tydic.fsc.common.busi.api.FscRollbackBankCheckFileItemBusiService;
import com.tydic.fsc.common.busi.bo.FscRollbackBankCheckFileItemBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscRollbackBankCheckFileItemBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscBankFileItemRollbackLogMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.FscWriteOffItemMapper;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscBankFileItemRollbackLogPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.po.FscWriteOffItemPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscRollbackBankCheckFileItemBusiServiceImpl
implements FscRollbackBankCheckFileItemBusiService {
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscWriteOffItemMapper fscWriteOffItemMapper;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscBankFileItemRollbackLogMapper fscBankFileItemRollbackLogMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscUocProOrderPaymentCallbackAbilityService fscUocProOrderPaymentCallbackAbilityService;

    @Override
    public FscRollbackBankCheckFileItemBusiRspBO rollbackBankCheckFileItem(FscRollbackBankCheckFileItemBusiReqBO reqBO) {
        FscOrderPO orderSetPO;
        FscRollbackBankCheckFileItemBusiRspBO rspBO = new FscRollbackBankCheckFileItemBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        this.val(reqBO);
        FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
        fscBankCheckFileItemPO.setBankCheckId(reqBO.getBankCheckId());
        fscBankCheckFileItemPO.setSysTenantId(reqBO.getSysTenantId());
        fscBankCheckFileItemPO = this.fscBankCheckFileItemMapper.getModelBy(fscBankCheckFileItemPO);
        if (ObjectUtil.isEmpty((Object)fscBankCheckFileItemPO)) {
            throw new ZTBusinessException("\u89e3\u7ed1\u5931\u8d25:\u672a\u67e5\u8be2\u5230\u94f6\u884c\u6d41\u6c34\u4fe1\u606f");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (ObjectUtil.isEmpty((Object)fscOrderPO)) {
            throw new ZTBusinessException("\u89e3\u7ed1\u5931\u8d25:\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u4fe1\u606f");
        }
        BigDecimal bankAmount = fscBankCheckFileItemPO.getTradeAmt();
        BigDecimal allAmount = reqBO.getAllAmount();
        BigDecimal orderAmount = fscOrderPO.getTotalCharge();
        if (bankAmount.compareTo(orderAmount) == 0 || allAmount.compareTo(orderAmount) == 0) {
            FscBankCheckFileItemPO bankSetPO = new FscBankCheckFileItemPO();
            bankSetPO.setWriteOffFlag("0");
            FscBankCheckFileItemPO bankWherePO = new FscBankCheckFileItemPO();
            bankWherePO.setBankCheckId(reqBO.getBankCheckId());
            bankWherePO.setSysTenantId(reqBO.getSysTenantId());
            this.fscBankCheckFileItemMapper.updateBy(bankSetPO, bankWherePO);
            orderSetPO = new FscOrderPO();
            orderSetPO.setOrderState(Integer.valueOf(1007));
            FscOrderPO orderWherePO = new FscOrderPO();
            orderWherePO.setFscOrderId(reqBO.getFscOrderId());
            orderWherePO.setSysTenantId(reqBO.getSysTenantId());
            this.fscOrderMapper.updateBy(orderSetPO, orderWherePO);
        } else if (bankAmount.compareTo(orderAmount) > 0) {
            FscOrderPO orderSetPO2 = new FscOrderPO();
            orderSetPO2.setOrderState(Integer.valueOf(1007));
            FscOrderPO orderWherePO = new FscOrderPO();
            orderWherePO.setFscOrderId(reqBO.getFscOrderId());
            orderWherePO.setSysTenantId(reqBO.getSysTenantId());
            this.fscOrderMapper.updateBy(orderSetPO2, orderWherePO);
        } else {
            FscWriteOffItemPO fscWriteOffItemPO = new FscWriteOffItemPO();
            fscWriteOffItemPO.setFscOrderId(reqBO.getFscOrderId());
            fscWriteOffItemPO.setSysTenantId(reqBO.getSysTenantId());
            List fscWriteOffItemPOS = this.fscWriteOffItemMapper.getList(fscWriteOffItemPO);
            if (fscWriteOffItemPOS.size() <= 1) {
                orderSetPO = new FscOrderPO();
                orderSetPO.setOrderState(Integer.valueOf(1007));
                FscOrderPO orderWherePO = new FscOrderPO();
                orderWherePO.setFscOrderId(reqBO.getFscOrderId());
                orderWherePO.setSysTenantId(reqBO.getSysTenantId());
                this.fscOrderMapper.updateBy(orderSetPO, orderWherePO);
            }
            FscBankCheckFileItemPO bankSetPO = new FscBankCheckFileItemPO();
            bankSetPO.setWriteOffFlag("0");
            FscBankCheckFileItemPO bankWherePO = new FscBankCheckFileItemPO();
            bankWherePO.setBankCheckId(reqBO.getBankCheckId());
            bankWherePO.setSysTenantId(reqBO.getSysTenantId());
            this.fscBankCheckFileItemMapper.updateBy(bankSetPO, bankWherePO);
        }
        FscWriteOffItemPO deleteItemPO = new FscWriteOffItemPO();
        deleteItemPO.setFscOrderId(reqBO.getFscOrderId());
        deleteItemPO.setBankCheckId(reqBO.getBankCheckId());
        deleteItemPO.setSysTenantId(reqBO.getSysTenantId());
        this.fscWriteOffItemMapper.deleteByFscOrderIdAndBankCheckId(deleteItemPO);
        FscBalancePO deleteBalancePO = new FscBalancePO();
        deleteBalancePO.setBankCheckId(reqBO.getBankCheckId());
        deleteBalancePO.setSysTenantId(reqBO.getSysTenantId());
        this.fscBalanceMapper.deleteByBankCheckId(deleteBalancePO);
        FscBankFileItemRollbackLogPO fscBankFileItemRollbackLogPO = new FscBankFileItemRollbackLogPO();
        fscBankFileItemRollbackLogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        fscBankFileItemRollbackLogPO.setBankCheckId(reqBO.getBankCheckId());
        fscBankFileItemRollbackLogPO.setFscOrderId(reqBO.getFscOrderId());
        fscBankFileItemRollbackLogPO.setRollbackOperUserId(reqBO.getUserId());
        fscBankFileItemRollbackLogPO.setRollbackOperUserName(reqBO.getUserName());
        fscBankFileItemRollbackLogPO.setRollbackOrgId(reqBO.getOrgId());
        fscBankFileItemRollbackLogPO.setRollbackOrgName(reqBO.getOrgName());
        fscBankFileItemRollbackLogPO.setRollbackDate(new Date());
        fscBankFileItemRollbackLogPO.setSysTenantId(reqBO.getSysTenantId());
        fscBankFileItemRollbackLogPO.setSysTenantName(reqBO.getSysTenantName());
        this.fscBankFileItemRollbackLogMapper.insert(fscBankFileItemRollbackLogPO);
        this.syncOrderStatus(reqBO.getFscOrderId(), reqBO.getSysTenantId());
        return rspBO;
    }

    private void val(FscRollbackBankCheckFileItemBusiReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getBankCheckId())) {
            throw new ZTBusinessException("\u94f6\u884c\u6d41\u6c34id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getFscOrderId())) {
            throw new ZTBusinessException("\u4ed8\u6b3e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void syncOrderStatus(Long fscPayOrderId, Long sysTenantId) {
        List fscShouldPayPOList = this.fscShouldPayMapper.getByFscOrderId(fscPayOrderId, sysTenantId);
        Map<Long, FscShouldPayPO> fscShouldPayPOMap = fscShouldPayPOList.stream().collect(Collectors.toMap(FscShouldPayPO::getObjectId, FscShouldPayPO2 -> FscShouldPayPO2));
        if (CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            return;
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderIds(fscShouldPayPOList.stream().map(FscShouldPayPO::getObjectId).collect(Collectors.toList()));
        fscOrderPo.setSysTenantId(sysTenantId);
        List orderList = this.fscOrderMapper.getList(fscOrderPo);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return;
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderIds(orderList.stream().map(FscOrderPO::getFscOrderId).collect(Collectors.toList()));
        fscOrderRelationPo.setSysTenantId(sysTenantId);
        List fscOrderRelationPOs = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        if (!CollectionUtils.isEmpty((Collection)fscShouldPayPOList)) {
            FscUocProOrderPaymentCallbackAbilityReqBO fscUocProOrderPaymentCallbackAbilityReqBO = new FscUocProOrderPaymentCallbackAbilityReqBO();
            fscUocProOrderPaymentCallbackAbilityReqBO.setUocPaymentCallbackBOS(fscOrderRelationPOs.stream().map(fscPaySuccessCallBackOrderBO -> {
                FscUocProOrderPaymentCallbackAbilityBO fscUocProOrderPaymentCallbackAbilityBO = new FscUocProOrderPaymentCallbackAbilityBO();
                fscUocProOrderPaymentCallbackAbilityBO.setSaleOrderId(fscPaySuccessCallBackOrderBO.getOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setObjectId(fscPaySuccessCallBackOrderBO.getAcceptOrderId());
                fscUocProOrderPaymentCallbackAbilityBO.setPayerType(FscConstants.FscOrderReceiveType.PURCHASE.equals(((FscOrderPO)orderList.get(0)).getReceiveType()) ? "pur" : "pro");
                fscUocProOrderPaymentCallbackAbilityBO.setPayMod(Integer.valueOf(30));
                fscUocProOrderPaymentCallbackAbilityBO.setPayResult(Boolean.valueOf(true));
                fscUocProOrderPaymentCallbackAbilityBO.setShouldPayMoney(fscPaySuccessCallBackOrderBO.getOrderTotalCharge());
                fscUocProOrderPaymentCallbackAbilityBO.setFscShouldPayId(((FscShouldPayPO)fscShouldPayPOMap.get(fscPaySuccessCallBackOrderBO.getFscOrderId())).getShouldPayId());
                return fscUocProOrderPaymentCallbackAbilityBO;
            }).collect(Collectors.toList()));
            fscUocProOrderPaymentCallbackAbilityReqBO.setSysTenantId(sysTenantId);
            this.fscUocProOrderPaymentCallbackAbilityService.dealOrderPaymentCallback(fscUocProOrderPaymentCallbackAbilityReqBO);
        }
    }
}

