/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bo.FscCandidatesBO;
import com.tydic.fsc.bo.FscFinishTaskInfoBO;
import com.tydic.fsc.bo.FscTaskInfoBO;
import com.tydic.fsc.common.atom.api.FscComOrderApprovalAtomService;
import com.tydic.fsc.common.atom.bo.FscComOrderApprovalAtomReqBO;
import com.tydic.fsc.common.busi.api.FscTaskDealBusiService;
import com.tydic.fsc.common.busi.bo.FscTaskDealBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscTaskDealBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.UocAuditOrderMapper;
import com.tydic.fsc.dao.UocOrderTaskDealMapper;
import com.tydic.fsc.dao.UocOrderTaskInstLogMapper;
import com.tydic.fsc.dao.UocOrderTaskInstMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.UocAuditOrderPo;
import com.tydic.fsc.po.UocOrderTaskDealPo;
import com.tydic.fsc.po.UocOrderTaskInstLogPo;
import com.tydic.fsc.po.UocOrderTaskInstPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscTaskDealBusiServiceImpl
implements FscTaskDealBusiService {
    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;
    @Autowired
    private UocOrderTaskInstLogMapper uocOrderTaskInstLogMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderApprovalAtomService fscComOrderApprovalAtomService;
    @Autowired
    private UocAuditOrderMapper uocAuditOrderMapper;

    @Override
    public FscTaskDealBusiRspBO dealTask(FscTaskDealBusiReqBO reqBO) {
        UocOrderTaskInstPo UocOrderTaskInst;
        List<FscTaskInfoBO> nextTaskInfos;
        ArrayList<FscFinishTaskInfoBO> finishTaskInfoBos = new ArrayList<FscFinishTaskInfoBO>();
        if (!CollectionUtils.isEmpty(reqBO.getCompleteTaskInfos())) {
            reqBO.getCompleteTaskInfos().forEach(completeTaskBo -> {
                UocOrderTaskInstPo uocOrderTaskInstPo = new UocOrderTaskInstPo();
                uocOrderTaskInstPo.setOrderId(reqBO.getOrderId());
                uocOrderTaskInstPo.setTaskInstId(completeTaskBo.getTaskId());
                List uocOrderTaskInsts = this.uocOrderTaskInstMapper.getList(uocOrderTaskInstPo);
                if (CollectionUtils.isEmpty((Collection)uocOrderTaskInsts)) {
                    throw new FscBusinessException("0000", "\u4efb\u52a1\u5b9e\u4f8bid(" + completeTaskBo.getTaskId() + ")\u4e0d\u5b58\u5728");
                }
                if (FscConstants.PROC_TASK_FINISHED.FINISHED.equals(((UocOrderTaskInstPo)uocOrderTaskInsts.get(0)).getFinishTag())) {
                    throw new FscBusinessException("198888", "\u4efb\u52a1\u5b9e\u4f8bid(" + completeTaskBo.getTaskId() + ")\u5df2\u5b8c\u7ed3");
                }
                completeTaskBo.setBusiObjType(((UocOrderTaskInstPo)uocOrderTaskInsts.get(0)).getObjType());
                completeTaskBo.setBusiObjId(((UocOrderTaskInstPo)uocOrderTaskInsts.get(0)).getObjId());
                UocOrderTaskInstPo updateSetPo = new UocOrderTaskInstPo();
                updateSetPo.setFinishTag(FscConstants.PROC_TASK_FINISHED.FINISHED);
                updateSetPo.setFinishTime(new Date());
                updateSetPo.setDealOperId(reqBO.getUserId() + "");
                updateSetPo.setDealOperName(reqBO.getName());
                updateSetPo.setDealResult(completeTaskBo.getDealResult());
                updateSetPo.setDealRemark(completeTaskBo.getDealRemark());
                UocOrderTaskInstPo updateWherePo = new UocOrderTaskInstPo();
                updateWherePo.setOrderId(reqBO.getOrderId());
                updateWherePo.setTaskInstId(completeTaskBo.getTaskId());
                this.uocOrderTaskInstMapper.updateBy(updateSetPo, updateWherePo);
                FscFinishTaskInfoBO bo = (FscFinishTaskInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)completeTaskBo), FscFinishTaskInfoBO.class);
                bo.setDealOperId(reqBO.getUserId() + "");
                bo.setDealOperName(reqBO.getUserName());
                bo.setCenter("FSC");
                finishTaskInfoBos.add(bo);
                if (completeTaskBo.getAuditStepFinish() != null && completeTaskBo.getAuditStepFinish().booleanValue()) {
                    UocOrderTaskInstPo UocOrderTaskInst = new UocOrderTaskInstPo();
                    UocOrderTaskInst.setOrderId(reqBO.getOrderId());
                    UocOrderTaskInst.setProcState(((UocOrderTaskInstPo)uocOrderTaskInsts.get(0)).getProcState());
                    UocOrderTaskInst.setFinishTag(FscConstants.PROC_TASK_FINISHED.NO_FINISHED);
                    this.deleteProcTaskInst(UocOrderTaskInst, finishTaskInfoBos);
                }
                if (completeTaskBo.getFinish() != null && completeTaskBo.getFinish().booleanValue() && completeTaskBo.getBusiObjType().equals(FscConstants.OBJ_TYPE.APPROVE)) {
                    FscComOrderApprovalAtomReqBO fscComOrderApprovalAtomReqBO = (FscComOrderApprovalAtomReqBO)((Object)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscComOrderApprovalAtomReqBO.class)));
                    fscComOrderApprovalAtomReqBO.setAuditResult(completeTaskBo.getDealResult());
                    fscComOrderApprovalAtomReqBO.setAuditAdvice(completeTaskBo.getDealRemark());
                    fscComOrderApprovalAtomReqBO.setSysTenantId(reqBO.getSysTenantId());
                    this.fscComOrderApprovalAtomService.dealOrderApproval(fscComOrderApprovalAtomReqBO);
                    UocAuditOrderPo set = new UocAuditOrderPo();
                    if (FscConstants.AuditResultFlagKey.PASS.equals(completeTaskBo.getDealResult())) {
                        set.setAuditOrderStatus(FscConstants.AuditStatus.AUDIT_PASS.toString());
                    } else {
                        set.setAuditOrderStatus(FscConstants.AuditStatus.AUDIT_REJECT.toString());
                    }
                    set.setUpdateTime(new Date());
                    set.setUpdateOperId(reqBO.getUserId() + "");
                    UocAuditOrderPo where = new UocAuditOrderPo();
                    where.setOrderId(reqBO.getOrderId());
                    where.setAuditOrderId(completeTaskBo.getBusiObjId());
                    this.uocAuditOrderMapper.updateBy(set, where);
                }
            });
        }
        if (!CollectionUtils.isEmpty(nextTaskInfos = reqBO.getNextTaskInfos())) {
            ArrayList<UocOrderTaskDealPo> saveDealList = new ArrayList<UocOrderTaskDealPo>();
            ArrayList<UocOrderTaskInstPo> saveList = new ArrayList<UocOrderTaskInstPo>();
            for (FscTaskInfoBO nextTaskInfo : nextTaskInfos) {
                UocOrderTaskInstPo taskBo = new UocOrderTaskInstPo();
                taskBo.setId(Long.valueOf(Sequence.getInstance().nextId()));
                taskBo.setOrderId(reqBO.getOrderId());
                taskBo.setTaskInstId(nextTaskInfo.getTaskId());
                taskBo.setObjId(nextTaskInfo.getBusiObjId());
                taskBo.setObjType(nextTaskInfo.getBusiObjType());
                taskBo.setProcState(nextTaskInfo.getStepId());
                taskBo.setFinishTag(FscConstants.PROC_TASK_FINISHED.NO_FINISHED);
                taskBo.setFormUrl(nextTaskInfo.getFormUrl());
                taskBo.setProcDefId(nextTaskInfo.getProcDefId());
                taskBo.setProcInstId(nextTaskInfo.getProcInstId());
                taskBo.setTaskSignTag(nextTaskInfo.getTaskSignTag());
                taskBo.setCreateTime(new Date());
                taskBo.setSysTenantId(reqBO.getSysTenantId());
                taskBo.setSysTenantName(reqBO.getSysTenantName());
                if (taskBo.getTaskSignTag() == null) {
                    taskBo.setTaskSignTag(FscConstants.TASK_SING_TAG.TACHE_TASK);
                }
                saveList.add(taskBo);
                String assignee = nextTaskInfo.getAssignee();
                List candidates = nextTaskInfo.getCandidates();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)assignee)) {
                    UocOrderTaskDealPo deal = new UocOrderTaskDealPo();
                    deal.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    deal.setTaskInstId(nextTaskInfo.getTaskId());
                    deal.setOrderId(reqBO.getOrderId());
                    deal.setObjId(nextTaskInfo.getBusiObjId());
                    deal.setObjType(nextTaskInfo.getBusiObjType());
                    deal.setDealId(assignee);
                    deal.setDealClass("1");
                    saveDealList.add(deal);
                }
                if (CollectionUtils.isEmpty((Collection)candidates)) continue;
                for (FscCandidatesBO candidate : candidates) {
                    UocOrderTaskDealPo deal = new UocOrderTaskDealPo();
                    deal.setId(Long.valueOf(Sequence.getInstance().nextId()));
                    deal.setTaskInstId(nextTaskInfo.getTaskId());
                    deal.setOrderId(reqBO.getOrderId());
                    deal.setObjId(nextTaskInfo.getBusiObjId());
                    deal.setObjType(nextTaskInfo.getBusiObjType());
                    deal.setDealId(candidate.getCandidateId());
                    deal.setDealName(candidate.getCandidateName());
                    deal.setDealClass("2");
                    deal.setSysTenantId(reqBO.getSysTenantId());
                    deal.setSysTenantName(reqBO.getSysTenantName());
                    saveDealList.add(deal);
                }
            }
            if (!CollectionUtils.isEmpty(saveDealList)) {
                this.uocOrderTaskDealMapper.insertBatch(saveDealList);
            }
            this.uocOrderTaskInstMapper.insertBatch(saveList);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getPreTaskId())) {
            UocOrderTaskInst = new UocOrderTaskInstPo();
            UocOrderTaskInst.setOrderId(reqBO.getOrderId());
            UocOrderTaskInst.setTaskInstId(reqBO.getPreTaskId());
            UocOrderTaskInst.setFinishTag(FscConstants.PROC_TASK_FINISHED.NO_FINISHED);
            this.deleteProcTaskInst(UocOrderTaskInst, finishTaskInfoBos);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)reqBO.getReturnTaskId())) {
            UocOrderTaskInst = new UocOrderTaskInstPo();
            UocOrderTaskInst.setOrderId(reqBO.getOrderId());
            UocOrderTaskInst.setTaskInstId(reqBO.getReturnTaskId());
            UocOrderTaskInst.setFinishTag(FscConstants.PROC_TASK_FINISHED.NO_FINISHED);
            this.deleteProcTaskInst(UocOrderTaskInst, finishTaskInfoBos);
        }
        if (reqBO.getUpdateTaskCandidate() != null && StringUtils.hasText((String)reqBO.getUpdateTaskCandidate().getTaskId())) {
            FscCandidatesBO FscCandidatesBO2 = (FscCandidatesBO)reqBO.getUpdateTaskCandidate().getCandidates().get(0);
            UocOrderTaskDealPo set = new UocOrderTaskDealPo();
            set.setDealId(FscCandidatesBO2.getCandidateId());
            set.setDealName(FscCandidatesBO2.getCandidateName());
            UocOrderTaskDealPo where = new UocOrderTaskDealPo();
            where.setTaskInstId(reqBO.getUpdateTaskCandidate().getTaskId());
            this.uocOrderTaskDealMapper.updateBy(set, where);
        }
        FscTaskDealBusiRspBO rspBO = new FscTaskDealBusiRspBO();
        rspBO.setFinishTaskInfoBO(finishTaskInfoBos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4efb\u52a1\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private void deleteProcTaskInst(UocOrderTaskInstPo UocOrderTaskInst, List<FscFinishTaskInfoBO> finishTaskInfoBos) {
        List taskInsts = this.uocOrderTaskInstMapper.getList(UocOrderTaskInst);
        if (!CollectionUtils.isEmpty((Collection)taskInsts)) {
            List uocOrderTaskInstLogPos = JSON.parseArray((String)JSON.toJSONString((Object)taskInsts), UocOrderTaskInstLogPo.class);
            this.uocOrderTaskInstLogMapper.insertBatch(uocOrderTaskInstLogPos);
            ArrayList ids = new ArrayList();
            taskInsts.forEach(uocOrderTaskInst -> ids.add(uocOrderTaskInst.getId()));
            UocOrderTaskInstPo where = new UocOrderTaskInstPo();
            where.setOrderId(UocOrderTaskInst.getOrderId());
            where.setIds(ids);
            this.uocOrderTaskInstMapper.deleteProcTaskInstByIds(where);
            UocOrderTaskDealPo where1 = new UocOrderTaskDealPo();
            ArrayList taskIds = new ArrayList();
            taskInsts.forEach(uocOrderTaskInst -> taskIds.add(uocOrderTaskInst.getTaskInstId()));
            where1.setOrderId(UocOrderTaskInst.getOrderId());
            where1.setTaskInstIds(taskIds);
            this.uocOrderTaskDealMapper.deleteProcTaskInstByIds(where1);
            taskInsts.forEach(uocOrderTaskInst1 -> {
                FscFinishTaskInfoBO bo = new FscFinishTaskInfoBO();
                bo.setProcInstId(uocOrderTaskInst1.getProcInstId());
                bo.setTaskId(uocOrderTaskInst1.getTaskInstId());
                bo.setBusiObjId(uocOrderTaskInst1.getObjId());
                bo.setBusiObjType(uocOrderTaskInst1.getObjType());
                bo.setDealResult(uocOrderTaskInst1.getDealResult());
                bo.setDealRemark(uocOrderTaskInst1.getDealRemark());
                bo.setDealOperId(uocOrderTaskInst1.getDealOperId());
                bo.setDealOperName(uocOrderTaskInst1.getDealOperName());
                bo.setCenter("FSC");
                finishTaskInfoBos.add(bo);
            });
        }
    }
}

