/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.config;

import com.tydic.fsc.exception.FscBusinessException;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FscElasticsearchConfiguration
implements FactoryBean<RestHighLevelClient>,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(FscElasticsearchConfiguration.class);
    @Value(value="${es.cluster.address}")
    private String clusterNodes;
    @Value(value="${es.source}")
    private String esSource;
    @Value(value="${ali.es.username}")
    private String userName;
    @Value(value="${ali.es.password}")
    private String password;
    private RestHighLevelClient restHighLevelClient;

    public RestHighLevelClient getObject() throws Exception {
        return this.restHighLevelClient;
    }

    public Class<?> getObjectType() {
        return RestHighLevelClient.class;
    }

    public void destroy() {
        try {
            if (this.restHighLevelClient != null) {
                this.restHighLevelClient.close();
            }
        }
        catch (Exception e) {
            log.error("Error closing ElasticSearch client: ", (Throwable)e);
        }
    }

    public boolean isSingleton() {
        return false;
    }

    public void afterPropertiesSet() {
        this.restHighLevelClient = this.buildClient();
    }

    private RestHighLevelClient buildClient() {
        if ("AliYunEs".equals(this.esSource)) {
            if (this.clusterNodes.contains(",")) {
                throw new FscBusinessException("198888", "\u963f\u91ccES\u4e0d\u80fd\u6709\u591a\u4e2a\u94fe\u63a5\u8282\u70b9");
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
            this.restHighLevelClient = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.clusterNodes.split(":")[0], Integer.parseInt(this.clusterNodes.split(":")[1]))}).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                final /* synthetic */ CredentialsProvider val$credentialsProvider;
                {
                    this.val$credentialsProvider = credentialsProvider;
                }

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                    return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                }
            }));
        } else {
            try {
                String[] clusterNodeMap = this.clusterNodes.split(",");
                HttpHost[] his = new HttpHost[clusterNodeMap.length];
                for (int i = 0; i < clusterNodeMap.length; ++i) {
                    HttpHost httpHost;
                    his[i] = httpHost = new HttpHost(clusterNodeMap[i].split(":")[0], Integer.parseInt(clusterNodeMap[i].split(":")[1]), "http");
                }
                this.restHighLevelClient = new RestHighLevelClient(RestClient.builder((HttpHost[])his));
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
        return this.restHighLevelClient;
    }
}

