/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.busibase.atom.api.FscBankCheckItemSyncEsAtomService;
import com.tydic.fsc.busibase.atom.bo.FscBankCheckItemSyncEsAtomReqBO;
import com.tydic.fsc.common.ability.api.FscBillRefundBankFileAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillRefundBankFileAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscBillRefundBankFileAbilityRspBO;
import com.tydic.fsc.common.busi.api.FscBillRefundBankFileBusiService;
import com.tydic.fsc.common.busi.bo.FscBillRefundBankFileBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscBillRefundBankFileBusiRspBO;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.dao.FscWriteOffApprovalOrderMapper;
import com.tydic.fsc.dao.FscWriteOffApprovalRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.po.FscWriteOffApprovalOrderPO;
import com.tydic.fsc.po.FscWriteOffApprovalRelationPO;
import com.tydic.fsc.util.FscRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscBillRefundBankFileAbilityService"})
public class FscBillRefundBankFileAbilityServiceImpl
implements FscBillRefundBankFileAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillRefundBankFileAbilityServiceImpl.class);
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscBillRefundBankFileBusiService fscBillRefundBankFileBusiService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscWriteOffApprovalOrderMapper fscWriteOffApprovalOrderMapper;
    @Autowired
    private FscWriteOffApprovalRelationMapper fscWriteOffApprovalRelationMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscBankCheckItemSyncEsAtomService fscBankCheckItemSyncEsAtomService;

    @PostMapping(value={"refundBankFile"})
    public FscBillRefundBankFileAbilityRspBO refundBankFile(@RequestBody FscBillRefundBankFileAbilityReqBO req) {
        this.val(req);
        log.info("\u9000\u6b3e\u64cd\u4f5c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)req));
        FscBillRefundBankFileBusiReqBO fscBillRefundBankFileBusiReqBO = (FscBillRefundBankFileBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)req), FscBillRefundBankFileBusiReqBO.class));
        FscBillRefundBankFileBusiRspBO fscBillRefundBankFileBusiRspBO = this.fscBillRefundBankFileBusiService.refundBankFile(fscBillRefundBankFileBusiReqBO);
        if (!"0000".equals(fscBillRefundBankFileBusiRspBO.getRespCode())) {
            this.insertWriteOffApproval(req, fscBillRefundBankFileBusiRspBO.getRespDesc(), FscConstants.BANK_APPROVAL_STATUS.FAIL);
            throw new FscBusinessException("190000", fscBillRefundBankFileBusiRspBO.getRespDesc());
        }
        if (ObjectUtil.isNotEmpty((Object)req.getBankCheckId())) {
            this.fscBankCheckItemSyncEsAtomService.bankCheckItemSyncEs((FscBankCheckItemSyncEsAtomReqBO)FscRu.js((Object)req, FscBankCheckItemSyncEsAtomReqBO.class));
        }
        this.insertWriteOffApproval(req, "", FscConstants.BANK_APPROVAL_STATUS.SUCC);
        return (FscBillRefundBankFileAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)fscBillRefundBankFileBusiRspBO)), FscBillRefundBankFileAbilityRspBO.class);
    }

    private void val(FscBillRefundBankFileAbilityReqBO req) {
        if (ObjectUtil.isEmpty((Object)req.getBankCheckId())) {
            throw new FscBusinessException("190000", "\u94f6\u884c\u5bf9\u8d26\u6587\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)req.getRefundAmt())) {
            throw new FscBusinessException("190000", "\u9000\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (req.getSourceType().equals("1")) {
            FscBalancePO fscBalancePO = new FscBalancePO();
            fscBalancePO.setBankCheckId(req.getBankCheckId());
            fscBalancePO.setSysTenantId(req.getSysTenantId());
            FscBalancePO balance = this.fscBalanceMapper.getModelById(fscBalancePO);
            if (!ObjectUtil.isEmpty((Object)balance) && balance.getUsedAmount().compareTo(BigDecimal.ZERO) > 0) {
                throw new FscBusinessException("190000", "\u94f6\u884c\u6d41\u6c34\u5df2\u7ecf\u63d0\u73b0,\u4e0d\u5141\u8bb8\u8fdb\u884c\u9000\u6b3e\u64cd\u4f5c");
            }
            if (!ObjectUtil.isEmpty((Object)balance)) {
                if (balance.getUsableAmount().compareTo(balance.getPayAmount()) != 0) {
                    throw new FscBusinessException("190000", "\u94f6\u884c\u6d41\u6c34\u53ef\u63d0\u73b0\u91d1\u989d\u4e0e\u4ed8\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4,\u4e0d\u5141\u8bb8\u8fdb\u884c\u9000\u6b3e\u64cd\u4f5c");
                }
                req.setBalanceId(balance.getBalanceId());
            }
            FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
            fscBankCheckFileItemPO.setBankCheckId(req.getBankCheckId());
            fscBankCheckFileItemPO.setTradeAmt(req.getRefundAmt());
            fscBankCheckFileItemPO.setSysTenantId(req.getSysTenantId());
            fscBankCheckFileItemPO = this.fscBankCheckFileItemMapper.getModelBy(fscBankCheckFileItemPO);
            if (ObjectUtil.isEmpty((Object)fscBankCheckFileItemPO)) {
                throw new FscBusinessException("190000", "\u94f6\u884c\u6d41\u6c34\u4e0e\u9000\u6b3e\u91d1\u989d\u4e0d\u4e00\u81f4");
            }
            req.setWriteOffFlag(Integer.valueOf(Integer.parseInt(fscBankCheckFileItemPO.getWriteOffFlag())));
        } else {
            req.setWriteOffFlag(Integer.valueOf(0));
        }
    }

    private void insertWriteOffApproval(FscBillRefundBankFileAbilityReqBO reqBO, String failReason, Integer type) {
        FscWriteOffApprovalOrderPO approval = new FscWriteOffApprovalOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)approval);
        approval.setWriteOffApprovalId(Long.valueOf(Sequence.getInstance().nextId()));
        approval.setWriteOffApprovalNo(this.getSerial(reqBO.getSysTenantId()));
        approval.setWriteOffType(reqBO.getWriteOffType());
        approval.setApprvovalStatus(type);
        approval.setFailReason(failReason);
        approval.setCreateOrgId(reqBO.getOrgId());
        approval.setCreateUserId(reqBO.getUserId());
        approval.setCreateOrgName(reqBO.getOrgName());
        approval.setCreateUserName(reqBO.getUserName());
        approval.setCreateUserLdapName(reqBO.getName());
        approval.setCreateTime(new Date());
        approval.setUpdateTime(new Date());
        approval.setBankAmount(reqBO.getRefundAmt());
        approval.setSupplierId(reqBO.getPayeeId());
        approval.setSupplierName(reqBO.getPayeeName());
        approval.setPayeeBankAccount(reqBO.getPayeeBankAccount());
        approval.setPayeeBankName(reqBO.getPayeeBankName());
        approval.setTransferOutAccountName(reqBO.getOutAccountName());
        this.fscWriteOffApprovalOrderMapper.insert(approval);
        ArrayList<FscWriteOffApprovalRelationPO> fscWriteOffApprovalRelationPOList = new ArrayList<FscWriteOffApprovalRelationPO>();
        FscWriteOffApprovalRelationPO approvalRelation = new FscWriteOffApprovalRelationPO();
        approvalRelation.setId(Long.valueOf(Sequence.getInstance().nextId()));
        approvalRelation.setWriteOffApprovalId(approval.getWriteOffApprovalId());
        approvalRelation.setRelationOrderId(reqBO.getBankCheckId());
        approvalRelation.setRelationOrderType(FscConstants.BANK_APPROVAL_RELAITON_TYPE.REFUND);
        approvalRelation.setWriteOffApprovalStatus(FscConstants.BANK_APPROVAL_STATUS.SUCC);
        approvalRelation.setCreateUserId(reqBO.getUserId());
        approvalRelation.setCreateUserName(reqBO.getUserName());
        approvalRelation.setCreateTime(new Date());
        approvalRelation.setSysTenantId(reqBO.getSysTenantId());
        approvalRelation.setSysTenantName(reqBO.getSysTenantName());
        fscWriteOffApprovalRelationPOList.add(approvalRelation);
        if (!ObjectUtil.isEmpty(fscWriteOffApprovalRelationPOList)) {
            this.fscWriteOffApprovalRelationMapper.insertBatch(fscWriteOffApprovalRelationPOList);
        }
        if (!ObjectUtil.isEmpty((Object)reqBO.getPayUrl())) {
            FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
            fscAttachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAttachmentPO.setAttachmentUrl(reqBO.getPayUrl());
            fscAttachmentPO.setFscOrderId(approval.getWriteOffApprovalId());
            fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.PAY_FILE);
            fscAttachmentPO.setObjId(Long.valueOf(Sequence.getInstance().nextId()));
            fscAttachmentPO.setAttachmentName(reqBO.getPayFileName());
            fscAttachmentPO.setSysTenantId(reqBO.getSysTenantId());
            fscAttachmentPO.setSysTenantName(reqBO.getSysTenantName());
            this.fscAttachmentMapper.insert(fscAttachmentPO);
        }
    }

    private String getSerial(Long sysTenantId) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.getInstance((String)"127").getDesc());
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setSysTenantId(sysTenantId);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return (String)encodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }
}

