/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.busibase.atom.api.FscBankCheckItemListEsQryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscBankCheckItemListEsQryReqBO;
import com.tydic.fsc.busibase.atom.bo.FscBankCheckItemListEsQryRspBO;
import com.tydic.fsc.common.ability.api.FscBillWithdrawalCheckImportAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillWithdrawalCheckImportAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscBillWithdrawalCheckImportAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscWithdrawalFileDetailBO;
import com.tydic.fsc.common.busi.api.FscBillWithdrawalCheckImportBusiService;
import com.tydic.fsc.common.busi.bo.FscBillWithdrawalCheckImportBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscBillWithdrawalCheckImportBusiRspBO;
import com.tydic.fsc.dao.FscBalanceMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscBalancePO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.ExcelUtils;
import com.tydic.fsc.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscBillWithdrawalCheckImportAbilityService"})
public class FscBillWithdrawalCheckImportAbilityServiceImpl
implements FscBillWithdrawalCheckImportAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillWithdrawalCheckImportAbilityServiceImpl.class);
    @Autowired
    private FscBillWithdrawalCheckImportBusiService fscBillWithdrawalCheckImportBusiService;
    @Autowired
    private FscBalanceMapper fscBalanceMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Value(value="${crc.sys.tenant.id:305775845729763327}")
    private Long crcSysTenantId;
    @Autowired
    private FscBankCheckItemListEsQryAtomService fscBankCheckItemListEsQryAtomService;

    @PostMapping(value={"withdrawalCheckImport"})
    public FscBillWithdrawalCheckImportAbilityRspBO withdrawalCheckImport(@RequestBody FscBillWithdrawalCheckImportAbilityReqBO reqBO) {
        List excelData;
        File file = FileUtils.getExcelFileByUrl((String)reqBO.getFileUrl());
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile("excel" + file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            excelData = ExcelUtils.getExcelDataImport((MultipartFile)multipartFile, (Integer)1);
            if (log.isDebugEnabled()) {
                log.debug("\u8bfb\u53d6\u7684excel\u6570\u636e:{}", (Object)JSON.toJSONString((Object)excelData));
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new FscBusinessException("191025", "\u83b7\u53d6\u6587\u4ef6\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)excelData)) {
            throw new FscBusinessException("191025", "\u4f20\u5165\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01\u8bf7\u4ed4\u7ec6\u6838\u5bf9\u540e\u91cd\u65b0\u4e0a\u4f20\u3002");
        }
        ArrayList<FscWithdrawalFileDetailBO> busiBankItemBos = new ArrayList<FscWithdrawalFileDetailBO>();
        int size = excelData.size();
        log.info("size========={}", (Object)size);
        for (int i = 0; i < size; ++i) {
            List excelDatum = (List)excelData.get(i);
            this.val(excelDatum);
            if ("".equals(excelDatum.get(0))) continue;
            FscWithdrawalFileDetailBO bankItemBo = new FscWithdrawalFileDetailBO();
            bankItemBo.setBankWitnessSeq((String)excelDatum.get(0));
            if (excelDatum.size() >= 2) {
                bankItemBo.setTradeAmt(new BigDecimal(ObjectUtil.isNotEmpty(excelDatum.get(1)) ? (String)excelDatum.get(1) : "0"));
            }
            if (excelDatum.size() >= 3) {
                bankItemBo.setPayerName(ObjectUtil.isNotEmpty(excelDatum.get(2)) ? (String)excelDatum.get(2) : null);
            }
            if (excelDatum.size() >= 4) {
                bankItemBo.setPayeeAccountNo(ObjectUtil.isNotEmpty(excelDatum.get(3)) ? (String)excelDatum.get(3) : null);
            }
            if (excelDatum.size() >= 5) {
                bankItemBo.setPayeeName(ObjectUtil.isNotEmpty(excelDatum.get(4)) ? (String)excelDatum.get(4) : null);
            }
            busiBankItemBos.add(bankItemBo);
        }
        if (CollectionUtils.isEmpty(busiBankItemBos)) {
            throw new FscBusinessException("191025", "\u4f20\u5165\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff01\u8bf7\u4ed4\u7ec6\u6838\u5bf9\u540e\u91cd\u65b0\u4e0a\u4f20\u3002");
        }
        List bankWitnessSeqList = busiBankItemBos.stream().map(FscWithdrawalFileDetailBO::getBankWitnessSeq).distinct().collect(Collectors.toList());
        FscBankCheckItemListEsQryReqBO queryEsBankItemBO = new FscBankCheckItemListEsQryReqBO();
        queryEsBankItemBO.setBankWitnessSeqList(bankWitnessSeqList);
        queryEsBankItemBO.setPayeeId(String.valueOf(reqBO.getOrgId()));
        queryEsBankItemBO.setPageSize(Integer.valueOf(bankWitnessSeqList.size()));
        queryEsBankItemBO.setPageNo(Integer.valueOf(1));
        FscBankCheckItemListEsQryRspBO fscBankCheckItemListEsQryRspBO = this.fscBankCheckItemListEsQryAtomService.qryBankCheckItemList(queryEsBankItemBO);
        log.info("es\u67e5\u8be2\u94f6\u884c\u6d41\u6c34\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)fscBankCheckItemListEsQryRspBO));
        ArrayList<FscBankCheckFileItemPO> fscBankCheckFileItemPOList = ObjectUtil.isEmpty((Object)fscBankCheckItemListEsQryRspBO.getRows()) ? new ArrayList<FscBankCheckFileItemPO>() : JSON.parseArray((String)JSON.toJSONString((Object)fscBankCheckItemListEsQryRspBO.getRows()), FscBankCheckFileItemPO.class);
        log.info("\u8f6c\u6362\u51fa\u53c2:{}", (Object)JSON.toJSONString(fscBankCheckFileItemPOList));
        Map<Long, FscBalancePO> fscBalancePOMap = new HashMap<Long, FscBalancePO>();
        if (!ObjectUtil.isEmpty(fscBankCheckFileItemPOList)) {
            List bankCheckIds = fscBankCheckFileItemPOList.stream().map(FscBankCheckFileItemPO::getBankCheckId).distinct().collect(Collectors.toList());
            FscBalancePO fscBalancePO = new FscBalancePO();
            fscBalancePO.setBankCheckIds(bankCheckIds);
            Calendar now = Calendar.getInstance();
            now.add(5, -1);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateStr = DateUtil.getCurrentMaxDate((String)DateUtil.dateToStr((Date)now.getTime(), (String)"yyyy-MM-dd"));
            Date createTime = new Date();
            try {
                createTime = sdf.parse(dateStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            fscBalancePO.setCreateTime(createTime);
            fscBalancePO.setSysTenantId(this.crcSysTenantId);
            List fscBalancePOList = this.fscBalanceMapper.getList(fscBalancePO);
            fscBalancePOMap = fscBalancePOList.stream().collect(Collectors.toMap(FscBalancePO::getBankCheckId, a -> a));
        }
        FscBillWithdrawalCheckImportBusiReqBO fscBillWithdrawalCheckImportBusiReqBO = (FscBillWithdrawalCheckImportBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillWithdrawalCheckImportBusiReqBO.class));
        fscBillWithdrawalCheckImportBusiReqBO.setFscWithdrawalFileDetailBOList(busiBankItemBos);
        fscBillWithdrawalCheckImportBusiReqBO.setFscBalancePOMap(fscBalancePOMap);
        fscBillWithdrawalCheckImportBusiReqBO.setFscBankCheckFileItemPOList(fscBankCheckFileItemPOList);
        FscBillWithdrawalCheckImportBusiRspBO fscBillWithdrawalCheckImportBusiRspBO = this.fscBillWithdrawalCheckImportBusiService.withdrawalCheckImport(fscBillWithdrawalCheckImportBusiReqBO);
        return (FscBillWithdrawalCheckImportAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)fscBillWithdrawalCheckImportBusiRspBO)), FscBillWithdrawalCheckImportAbilityRspBO.class);
    }

    private void val(List<String> cells) {
        try {
            String bankNo;
            if (StringUtils.isBlank((String)cells.get(0))) {
                throw new FscBusinessException("191025", "[\u94f6\u884c\u89c1\u8bc1\u6d41\u6c34\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String regex = "\\d+";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(bankNo = cells.get(0).replace("_", ""));
            if (!matcher.matches()) {
                throw new FscBusinessException("191025", "[\u94f6\u884c\u89c1\u8bc1\u6d41\u6c34\u53f7]\u683c\u5f0f\u4e0d\u6b63\u786e");
            }
        }
        catch (FscBusinessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FscBusinessException("191025", "\u4e0a\u4f20\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\u6216\u91d1\u989d\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u7684\u6587\u4ef6\u6a21\u677f");
        }
    }
}

