/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.commodity.base.constant.PesappCommonConstant;
import com.tydic.fsc.busibase.atom.api.FscSendInvoiceMessageAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendMessageAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.SendMessageBO;
import com.tydic.fsc.busibase.atom.bo.SendMessageReceiverBO;
import com.tydic.fsc.common.ability.api.FscCancelOrderNoticeTaskAbilityService;
import com.tydic.fsc.common.ability.bo.FscCancelOrderNoticeBO;
import com.tydic.fsc.common.ability.bo.FscCancelOrderNoticeTaskAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCancelOrderNoticeTaskAbilityRspBO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.poi.Excel;
import com.tydic.fsc.util.poi.Excels;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscCancelOrderNoticeTaskAbilityService"})
public class FscCancelOrderNoticeTaskAbilityServiceImpl
implements FscCancelOrderNoticeTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscCancelOrderNoticeTaskAbilityServiceImpl.class);
    private static final Integer ROW_ACCESS_WINDOW_SIZE = 65535;
    @Value(value="${export.maxRows}")
    private Integer maxRows;
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common/";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${oss.accessUrl}")
    private String accessUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;
    @Autowired
    private FscSendInvoiceMessageAtomService fscSendInvoiceMessageAtomService;
    @Value(value="#{'${cancelOrder.receiverInfo}'.split(',')}")
    private List<String> cancelOrderReceiverInfo;

    @PostMapping(value={"cancelOrderNoticeTask"})
    public FscCancelOrderNoticeTaskAbilityRspBO cancelOrderNoticeTask(@RequestBody FscCancelOrderNoticeTaskAbilityReqBO reqBO) {
        FscCancelOrderNoticeTaskAbilityRspBO rspBO = new FscCancelOrderNoticeTaskAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        LocalDateTime startOfDay = LocalDateTime.now().minusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        LocalDateTime endOfDay = startOfDay.withHour(23).withMinute(59).withSecond(59).withNano(999999999);
        ZoneId zone = ZoneId.of("Asia/Shanghai");
        Date endDate = ObjectUtil.isEmpty((Object)reqBO.getEndDate()) ? Date.from(endOfDay.atZone(zone).toInstant()) : DateUtil.strToDate((String)reqBO.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss");
        List fscCancelOrderNoticeBOAllList = reqBO.getFscCancelOrderNoticeBOAllList();
        if (!ObjectUtil.isEmpty((Object)fscCancelOrderNoticeBOAllList)) {
            String fileName = this.exportExcel(fscCancelOrderNoticeBOAllList, FscCancelOrderNoticeBO.class.getName(), endDate);
            String url = this.uploadFile(fileName);
            FscSendMessageAtomReqBO fscSendMessageAtomReqBO = new FscSendMessageAtomReqBO();
            ArrayList<SendMessageBO> sendMessageBOList = new ArrayList<SendMessageBO>();
            SendMessageBO sendMessageBO = new SendMessageBO();
            sendMessageBO.setTaskCode("FSC_ORDER_CANCEL_NOTICE");
            sendMessageBO.setBeforeDate(DateUtil.dateToStr((Date)endDate, (String)"yyyy-MM-dd"));
            sendMessageBO.setCancelOrderFileUrl(url);
            sendMessageBO.setSendId("1");
            sendMessageBO.setSendName("\u7cfb\u7edf\u7ba1\u7406\u5458");
            ArrayList<SendMessageReceiverBO> sendMessageReceiverBOList = new ArrayList<SendMessageReceiverBO>();
            log.info("\u53d1\u9001\u4eba\u4fe1\u606f:{}", (Object)JSON.toJSONString(this.cancelOrderReceiverInfo));
            for (String s : this.cancelOrderReceiverInfo) {
                String[] info = s.split("-");
                SendMessageReceiverBO sendMessageReceiverBO = new SendMessageReceiverBO();
                sendMessageReceiverBO.setReceiverId(info[0]);
                sendMessageReceiverBO.setReceiverName(info[1]);
                sendMessageReceiverBO.setEMail(info[2]);
                sendMessageReceiverBOList.add(sendMessageReceiverBO);
                sendMessageBO.setReceiverBOList(sendMessageReceiverBOList);
            }
            sendMessageBOList.add(sendMessageBO);
            fscSendMessageAtomReqBO.setSendMessageBOList(sendMessageBOList);
            log.info("\u53d1\u9001\u7ad9\u5185\u4fe1\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)fscSendMessageAtomReqBO));
            this.fscSendInvoiceMessageAtomService.sendMessageAtomService(fscSendMessageAtomReqBO);
        }
        return rspBO;
    }

    public String exportExcel(List<FscCancelOrderNoticeBO> list, String className, Date endDate) {
        String string;
        log.info("\u914d\u7f6e\u884c\u6570:{}", (Object)this.maxRows);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        List<Object> fields = this.getFields(clazz);
        fields = fields.stream().sorted(Comparator.comparing(objects -> ((Excel)objects[1]).sort())).collect(Collectors.toList());
        int rowNum = 0;
        SXSSFWorkbook wb = new SXSSFWorkbook(ROW_ACCESS_WINDOW_SIZE.intValue());
        Sheet sheet = wb.createSheet();
        FileOutputStream out = null;
        try {
            int sheetNo = Math.max(1, (int)Math.ceil((double)list.size() * 1.0 / 2000.0));
            for (int index = 0; index < sheetNo; ++index) {
                if (sheetNo > 1 && index > 0) {
                    sheet = wb.createSheet();
                    wb.setSheetName(index, "sheet" + index);
                }
                Row row = sheet.createRow(rowNum);
                int column = 0;
                for (Object[] objectArray : fields) {
                    Excel excel = (Excel)objectArray[1];
                    Cell cell = row.createCell(column);
                    cell.setCellValue(excel.name());
                    ++column;
                }
                int startNo = index * this.maxRows;
                int n = Math.min(startNo + this.maxRows, list.size());
                for (int i = startNo; i < n; ++i) {
                    row = sheet.createRow(i + 1 + rowNum - startNo);
                    int columns = 0;
                    FscCancelOrderNoticeBO fscCancelOrderNoticeBO = list.get(i);
                    Object[] itemFields = fscCancelOrderNoticeBO.getClass().getDeclaredFields();
                    log.info("Field[] ============== {}", itemFields);
                    int firstIndex = 1;
                    for (Object field : itemFields) {
                        if (firstIndex <= 1) {
                            ++firstIndex;
                            continue;
                        }
                        ((Field)field).setAccessible(true);
                        String value = "";
                        value = ObjectUtil.isEmpty((Object)((Field)field).get(fscCancelOrderNoticeBO)) ? "" : ((Field)field).get(fscCancelOrderNoticeBO).toString();
                        log.info("value=============={}", (Object)value);
                        Cell cell = null;
                        try {
                            cell = row.createCell(columns++);
                            cell.setCellValue(ObjectUtil.isEmpty((Object)value) ? "" : value);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            String filename = DateUtil.dateToStr((Date)endDate, (String)"yyyy-MM-dd") + "\u9500\u552e\u7ed3\u7b97\u5355\u53d6\u6d88\u6570\u636e.xlsx";
            log.info("filename:{}", (Object)filename);
            String downloadPath = filename;
            out = new FileOutputStream(downloadPath);
            wb.write((OutputStream)out);
            string = filename;
        }
        catch (Exception e) {
            try {
                log.info(e.getMessage());
                throw new ZTBusinessException("\u5bfc\u51faExcel\u5931\u8d25\uff01");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Closeable)wb);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)wb);
        IOUtils.closeQuietly((Closeable)out);
        return string;
    }

    public List<Object[]> getFields(Class clazz) {
        ArrayList<Object[]> fields = new ArrayList<Object[]>();
        ArrayList<Field> tempFields = new ArrayList<Field>();
        tempFields.addAll(Arrays.asList(clazz.getSuperclass().getDeclaredFields()));
        tempFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        for (Field field : tempFields) {
            Excel[] excels;
            Excel attr;
            if (field.isAnnotationPresent(Excel.class) && (attr = field.getAnnotation(Excel.class)) != null && attr.type() == Excel.Type.ALL) {
                field.setAccessible(true);
                fields.add(new Object[]{field, attr});
            }
            if (!field.isAnnotationPresent(Excels.class)) continue;
            Excels attrs = field.getAnnotation(Excels.class);
            for (Excel attr2 : excels = attrs.value()) {
                if (attr2 == null || attr2.type() != Excel.Type.ALL) continue;
                field.setAccessible(true);
                fields.add(new Object[]{field, attr2});
            }
        }
        return fields;
    }

    private String uploadFile(String fileName) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(fileName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
        log.info("pdf\u4e0a\u4f20\u8def\u5f84:{}", (Object)path);
        String fileUrl = null;
        String innerFileUrl = null;
        if (PesappCommonConstant.FileService.FILE_TYPE_OSS.equals(this.fileType)) {
            innerFileUrl = this.accessUrl + path;
            fileUrl = this.ossFileUrl + path;
        } else if (PesappCommonConstant.FileService.FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            innerFileUrl = "http://" + this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":")) + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        log.info("innerFileUrl:{}", (Object)innerFileUrl);
        log.info("fileUrl:{}", (Object)fileUrl);
        return fileUrl;
    }
}

