/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.common.ability.api.FscCheckBankItemToEsTaskChangeDataSourceAbilityService;
import com.tydic.fsc.common.ability.api.FscComBankItemSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscCheckBankItemToEsTaskAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCheckBankItemToEsTaskAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.dao.FscBankAuditLogMapper;
import com.tydic.fsc.dao.FscBankCheckFileItemMapper;
import com.tydic.fsc.po.FscBankAuditLogPO;
import com.tydic.fsc.po.FscBankCheckFileItemPO;
import com.tydic.fsc.util.DateUtil;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscCheckBankItemToEsTaskChangeDataSourceAbilityService"})
public class FscCheckBankItemToEsTaskChangeDataSourceAbilityServiceImpl
implements FscCheckBankItemToEsTaskChangeDataSourceAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscCheckBankItemToEsTaskChangeDataSourceAbilityServiceImpl.class);
    @Autowired
    private FscBankAuditLogMapper fscBankAuditLogMapper;
    @Autowired
    private FscBankCheckFileItemMapper fscBankCheckFileItemMapper;
    @Autowired
    private FscComBankItemSyncAbilityService fscComBankItemSyncAbilityService;

    @PostMapping(value={"checkBankItemToEsTask"})
    public FscCheckBankItemToEsTaskAbilityRspBO checkBankItemToEsTask(@RequestBody FscCheckBankItemToEsTaskAbilityReqBO reqBO) {
        FscCheckBankItemToEsTaskAbilityRspBO rspBO = new FscCheckBankItemToEsTaskAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        LocalDateTime startOfDay = LocalDateTime.now().minusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        LocalDateTime endOfDay = startOfDay.withHour(23).withMinute(59).withSecond(59).withNano(999999999);
        ZoneId zone = ZoneId.of("Asia/Shanghai");
        Date startDate = ObjectUtil.isEmpty((Object)reqBO.getStartDate()) ? Date.from(startOfDay.atZone(zone).toInstant()) : DateUtil.strToDate((String)reqBO.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss");
        Date endDate = ObjectUtil.isEmpty((Object)reqBO.getEndDate()) ? Date.from(endOfDay.atZone(zone).toInstant()) : DateUtil.strToDate((String)reqBO.getEndDate(), (String)"yyyy-MM-dd HH:mm:ss");
        FscBankAuditLogPO fscBankAuditLogPO = new FscBankAuditLogPO();
        fscBankAuditLogPO.setOperateTimeStart(startDate);
        fscBankAuditLogPO.setOperateTimeEnd(endDate);
        fscBankAuditLogPO.setSysTenantId(reqBO.getSysTenantId());
        int pageSize = 100;
        int pageNo = 1;
        while (pageSize >= 100) {
            Page page = new Page(pageNo, 100);
            List fscBankAuditLogPOList = this.fscBankAuditLogMapper.getListPage(fscBankAuditLogPO, page);
            log.info("\u5f53\u524d\u79df\u6237id:{},\u67e5\u8be2\u6570\u636e\u51fa\u53c2:{}", (Object)reqBO.getSysTenantId(), (Object)JSON.toJSONString((Object)fscBankAuditLogPOList));
            pageSize = ObjectUtil.isEmpty((Object)fscBankAuditLogPOList) ? 0 : fscBankAuditLogPOList.size();
            ++pageNo;
            if (ObjectUtil.isEmpty((Object)fscBankAuditLogPOList)) continue;
            List bankCheckIds = fscBankAuditLogPOList.stream().map(FscBankAuditLogPO::getBankCheckId).collect(Collectors.toList());
            FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
            fscComOrderListSyncAbilityReqBO.setBankCheckIdList(bankCheckIds);
            fscComOrderListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
            this.fscComBankItemSyncAbilityService.dealBankCheckItemSyncEs(fscComOrderListSyncAbilityReqBO);
        }
        if (reqBO.getSyncAll().equals("1")) {
            int bankPageSize = 1000;
            int bankPageNo = 1;
            FscBankCheckFileItemPO fscBankCheckFileItemPO = new FscBankCheckFileItemPO();
            fscBankCheckFileItemPO.setSysTenantId(reqBO.getSysTenantId());
            while (bankPageSize >= 1000) {
                Page page = new Page(bankPageNo, 1000);
                List fscBankCheckFileItemPOList = this.fscBankCheckFileItemMapper.getBankCheckIdListPage(fscBankCheckFileItemPO, page);
                bankPageSize = ObjectUtil.isEmpty((Object)fscBankCheckFileItemPOList) ? 0 : fscBankCheckFileItemPOList.size();
                ++bankPageNo;
                if (ObjectUtil.isEmpty((Object)fscBankCheckFileItemPOList)) continue;
                List bankCheckIds = fscBankCheckFileItemPOList.stream().map(FscBankCheckFileItemPO::getBankCheckId).collect(Collectors.toList());
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setBankCheckIdList(bankCheckIds);
                fscComOrderListSyncAbilityReqBO.setSysTenantId(reqBO.getSysTenantId());
                this.fscComBankItemSyncAbilityService.dealBankCheckItemSyncEs(fscComOrderListSyncAbilityReqBO);
            }
        }
        return rspBO;
    }
}

