/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.InvoiceBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscComAdjustInvoiceListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComAdjustInvoiceListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscGoodsDeductionAdjustMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePostMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscGoodsDeductionAdjustPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoicePostPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComAdjustInvoiceListQueryAbilityService"})
public class FscComAdjustInvoiceListQueryAbilityServiceImpl
implements FscComAdjustInvoiceListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComAdjustInvoiceListQueryAbilityServiceImpl.class);
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscInvoicePostMapper fscInvoicePostMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscGoodsDeductionAdjustMapper fscGoodsDeductionAdjustMapper;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryAdjustInvoiceList"})
    public FscComInvoiceListQueryAbilityRspBO qryAdjustInvoiceList(@RequestBody FscComAdjustInvoiceListQueryAbilityReqBO reqBO) {
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        String orderBy = "bill_date desc";
        FscInvoicePO fscInvoicePo = new FscInvoicePO();
        fscInvoicePo.setOrderBy(orderBy);
        fscInvoicePo.setFscOrderId(reqBO.getFscAdjustId());
        fscInvoicePo.setInvoiceId(reqBO.getInvoiceId());
        fscInvoicePo.setInvoiceIds(reqBO.getInvoiceIds());
        fscInvoicePo.setFscOrderIds(reqBO.getFscAdjustIds());
        fscInvoicePo.setInvType(Integer.valueOf(0));
        fscInvoicePo.setRedInvoiceStatus(Integer.valueOf(0));
        fscInvoicePo.setSysTenantId(reqBO.getSysTenantId());
        List fscInvoicePos = this.fscInvoiceMapper.getListPage(fscInvoicePo, page);
        FscComInvoiceListQueryAbilityRspBO busiRspBO = new FscComInvoiceListQueryAbilityRspBO();
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePos)) {
            ArrayList<InvoiceBO> invoiceBos = new ArrayList<InvoiceBO>();
            Map invoiceTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_TYPE", reqBO.getSysTenantId());
            Map invoiceCategoryMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_INVOICE_CATEGORY", reqBO.getSysTenantId());
            FscGoodsDeductionAdjustPO fscGoodsDeductionAdjustPo = new FscGoodsDeductionAdjustPO();
            fscGoodsDeductionAdjustPo.setFscAdjustId(reqBO.getFscAdjustId());
            fscGoodsDeductionAdjustPo.setSysTenantId(reqBO.getSysTenantId());
            fscGoodsDeductionAdjustPo = this.fscGoodsDeductionAdjustMapper.getModelBy(fscGoodsDeductionAdjustPo);
            List invoiceIdList = fscInvoicePos.stream().map(FscInvoicePO::getInvoiceId).collect(Collectors.toList());
            FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
            fscAttachmentPo.setObjType(FscConstants.AttachmentType.INVOICE);
            fscAttachmentPo.setObjIds(invoiceIdList);
            fscAttachmentPo.setSysTenantId(reqBO.getSysTenantId());
            List attachmentPoList = this.fscAttachmentMapper.getList(fscAttachmentPo);
            List mailIdList = fscInvoicePos.stream().map(FscInvoicePO::getMailId).collect(Collectors.toList());
            FscInvoicePostPO fscInvoicePostPo = new FscInvoicePostPO();
            fscInvoicePostPo.setIds(mailIdList);
            fscInvoicePostPo.setSysTenantId(reqBO.getSysTenantId());
            List invoicePostList = this.fscInvoicePostMapper.getList(fscInvoicePostPo);
            Map<Long, FscInvoicePostPO> invoicePostPoMap = invoicePostList.stream().collect(Collectors.toMap(FscInvoicePostPO::getId, v -> v));
            List fscOrderIdList = fscInvoicePos.stream().map(FscInvoicePO::getFscOrderId).distinct().collect(Collectors.toList());
            FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
            fscOrderRelationPo.setFscOrderIds(fscOrderIdList);
            fscOrderRelationPo.setSysTenantId(reqBO.getSysTenantId());
            List fscOrderRelationPoList = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
            FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
            fscOrderInvoicePo.setFscOrderIdList(fscOrderIdList);
            fscOrderInvoicePo.setSysTenantId(reqBO.getSysTenantId());
            List fscOrderInvoicePoList = this.fscOrderInvoiceMapper.getList(fscOrderInvoicePo);
            Map<Long, FscOrderInvoicePO> fscOrderInvoicePoMap = fscOrderInvoicePoList.stream().collect(Collectors.toMap(FscOrderInvoicePO::getFscOrderId, v -> v));
            for (FscInvoicePO invoicePo : fscInvoicePos) {
                List invoiceAttachment = attachmentPoList.stream().filter(fscAttachment -> invoicePo.getInvoiceId().equals(fscAttachment.getObjId())).collect(Collectors.toList());
                List orderNoList = fscOrderRelationPoList.stream().filter(fscOrderRelation -> invoicePo.getFscOrderId().equals(fscOrderRelation.getFscOrderId())).map(FscOrderRelationPO::getOrderNo).collect(Collectors.toList());
                List bos = JSON.parseArray((String)JSON.toJSONString(invoiceAttachment), AttachmentBO.class);
                block13: for (AttachmentBO item : bos) {
                    switch (item.getAttachmentType()) {
                        case 1: {
                            item.setAttachmentTypeStr("PDF");
                            continue block13;
                        }
                        case 70: {
                            item.setAttachmentTypeStr("OFD");
                            continue block13;
                        }
                        case 80: {
                            item.setAttachmentTypeStr("XML");
                            continue block13;
                        }
                        case 90: {
                            String[] fileUrlList = item.getAttachmentUrl().split("/");
                            String fileName = fileUrlList[item.getAttachmentUrl().split("/").length - 1];
                            if (fileName.indexOf(".") != -1) {
                                item.setAttachmentTypeStr(fileName.split("\\.")[1].toUpperCase());
                                continue block13;
                            }
                            item.setAttachmentTypeStr("");
                            continue block13;
                        }
                    }
                    item.setAttachmentTypeStr("PDF");
                }
                InvoiceBO invoiceBo = new InvoiceBO();
                BeanUtils.copyProperties((Object)invoicePo, (Object)invoiceBo);
                invoiceBo.setOrderNos(orderNoList);
                invoiceBo.setInvoiceCategoryStr((String)invoiceCategoryMap.get(String.valueOf(invoiceBo.getInvoiceCategory())));
                invoiceBo.setInvoiceTypeStr((String)invoiceTypeMap.get(invoiceBo.getInvoiceType()));
                invoiceBo.setInvoiceStateStr(ObjectUtil.isEmpty((Object)invoiceBo.getPayStatus()) ? "\u672a\u652f\u4ed8" : (invoiceBo.getPayStatus().equals(0) ? "\u672a\u652f\u4ed8" : "\u5df2\u652f\u4ed8"));
                invoiceBo.setAttachmentList(bos);
                if (!CollectionUtils.isEmpty(fscOrderInvoicePoMap)) {
                    invoiceBo.setBillTime(fscOrderInvoicePoMap.get(invoicePo.getFscOrderId()).getBillTime());
                }
                if (!CollectionUtils.isEmpty(invoicePostPoMap)) {
                    invoiceBo.setSignTime(invoicePostPoMap.get(invoicePo.getMailId()).getSignTime());
                    invoiceBo.setMailDesc(this.assembly(invoicePostPoMap.get(invoicePo.getMailId())));
                    invoiceBo.setSignOperId(invoicePostPoMap.get(invoicePo.getMailId()).getSignOperId());
                    invoiceBo.setSignOperName(invoicePostPoMap.get(invoicePo.getMailId()).getSignOperName());
                    invoiceBo.setIsMaintain(FscConstants.MAINTAIN_TYPE.YES);
                } else {
                    invoiceBo.setIsMaintain(FscConstants.MAINTAIN_TYPE.NO);
                }
                invoiceBo.setReceiveName(fscGoodsDeductionAdjustPo.getPurchaseName());
                ArrayList orderNos = new ArrayList();
                orderNos.addAll(orderNoList);
                invoiceBo.setOrderNos(orderNos);
                if (!ObjectUtil.isEmpty((Object)fscGoodsDeductionAdjustPo.getCreateDate())) {
                    invoiceBo.setCreateTime(fscGoodsDeductionAdjustPo.getCreateDate());
                }
                invoiceBo.setInvTypeStr(invoiceBo.getInvType() == 0 ? "\u84dd\u7968" : "\u7ea2\u7968");
                switch (invoiceBo.getRedInvoiceStatus()) {
                    case 0: {
                        invoiceBo.setRedInvoiceStatusStr("\u672a\u53d1\u8d77");
                        break;
                    }
                    case 1: {
                        invoiceBo.setRedInvoiceStatusStr("\u5df2\u53d1\u8d77");
                        break;
                    }
                    case 2: {
                        invoiceBo.setRedInvoiceStatusStr("\u5df2\u786e\u8ba4");
                        break;
                    }
                    case 3: {
                        invoiceBo.setRedInvoiceStatusStr("\u5df2\u5f00\u5177");
                    }
                }
                invoiceBos.add(invoiceBo);
            }
            busiRspBO.setRows(invoiceBos);
            busiRspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            busiRspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            busiRspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private String assembly(FscInvoicePostPO fscInvoicePostPO) {
        if (StringUtils.isNotBlank((CharSequence)fscInvoicePostPO.getSendCompany()) && StringUtils.isNotBlank((CharSequence)fscInvoicePostPO.getSendOrder())) {
            StringBuffer sb = new StringBuffer();
            sb.append("\u5feb\u9012\u516c\u53f8\uff1a").append(fscInvoicePostPO.getSendCompany()).append("\n").append("\u5feb\u9012\u5355\u53f7\uff1a").append(fscInvoicePostPO.getSendOrder());
            return sb.toString();
        }
        return "";
    }
}

