/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.consumer.bo.FscSyncReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComOrderSyncAbilityServiceImpl
implements FscComOrderSyncAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderSyncAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Resource(name="fscSyncOrderListMqServiceProvider")
    private ProxyMessageProducer fscSyncOrderListMqServiceProvider;
    @Resource(name="fscSyncOrderListCopyMqServiceProvider")
    private ProxyMessageProducer fscSyncOrderListCopyMqServiceProvider;
    @Value(value="${es.FSC_SYNC_TOPIC}")
    private String topic;
    @Value(value="${es.FSC_SYNC_COPY_TOPIC:FSC_SYNC_COPY_TOPIC}")
    private String topicCopy;
    @Value(value="${es.FSC_SYNC_TAG}")
    private String tag;
    @Value(value="${es.FSC_SYNC_COPY_TAG:FSC_SYNC_COPY_TAG}")
    private String tagCopy;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    public void dealComOrderSyncEs(FscComOrderListSyncAbilityReqBO reqBO) {
        if (null != reqBO.getFscOrderId()) {
            FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
            fscSyncReqBO.setFscOrderId(reqBO.getFscOrderId());
            fscSyncReqBO.setSysTenantId(reqBO.getSysTenantId());
            ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
            if (!"SEND_OK".equals(proxySendResult.getStatus())) {
                this.writeFailLog(reqBO, JSONObject.toJSONString((Object)proxySendResult));
            }
        } else if (!CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIdS())) {
            for (Long fscOrderId : reqBO.getFscOrderIdS()) {
                FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
                fscSyncReqBO.setFscOrderId(fscOrderId);
                fscSyncReqBO.setSysTenantId(reqBO.getSysTenantId());
                ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
                if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
                this.writeFailLog(reqBO, JSONObject.toJSONString((Object)proxySendResult));
            }
        }
    }

    public void dealComOrderCopySyncEs(FscComOrderListSyncAbilityReqBO reqBO) {
        if (null != reqBO.getFscOrderId()) {
            FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
            fscSyncReqBO.setFscOrderId(reqBO.getFscOrderId());
            fscSyncReqBO.setSysTenantId(reqBO.getSysTenantId());
            ProxySendResult proxySendResult = this.fscSyncOrderListCopyMqServiceProvider.send(new ProxyMessage(this.topicCopy, this.tagCopy, JSONObject.toJSONString((Object)fscSyncReqBO)));
            if (!"SEND_OK".equals(proxySendResult.getStatus())) {
                this.writeFailLog(reqBO, JSONObject.toJSONString((Object)proxySendResult));
            }
        } else if (!CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIdS())) {
            for (Long fscOrderId : reqBO.getFscOrderIdS()) {
                FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
                fscSyncReqBO.setFscOrderId(fscOrderId);
                fscSyncReqBO.setSysTenantId(reqBO.getSysTenantId());
                ProxySendResult proxySendResult = this.fscSyncOrderListCopyMqServiceProvider.send(new ProxyMessage(this.topicCopy, this.tagCopy, JSONObject.toJSONString((Object)fscSyncReqBO)));
                if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
                this.writeFailLog(reqBO, JSONObject.toJSONString((Object)proxySendResult));
            }
        }
    }

    private void writeFailLog(FscComOrderListSyncAbilityReqBO reqBO, String errDesc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(reqBO.getFscOrderId());
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(errDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_SYNC_ES);
        fscOrderFailLogUpdateBusiReqBO.setSysTenantId(reqBO.getSysTenantId());
        fscOrderFailLogUpdateBusiReqBO.setSysTenantName(reqBO.getSysTenantName());
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    public void syncAllComOrderList() {
        FscOrderPO fscOrderPO = new FscOrderPO();
        List fscOrderList = this.fscOrderMapper.getList(fscOrderPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderList)) {
            for (FscOrderPO orderPO : fscOrderList) {
                FscSyncReqBO fscSyncReqBO = new FscSyncReqBO();
                fscSyncReqBO.setFscOrderId(orderPO.getFscOrderId());
                fscSyncReqBO.setSysTenantId(orderPO.getSysTenantId());
                fscSyncReqBO.setSysTenantName(orderPO.getSysTenantName());
                ProxySendResult proxySendResult = this.fscSyncOrderListMqServiceProvider.send(new ProxyMessage(this.topic, this.tag, JSONObject.toJSONString((Object)fscSyncReqBO)));
                if ("SEND_OK".equals(proxySendResult.getStatus())) continue;
                FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
                fscComOrderListSyncAbilityReqBO.setFscOrderId(orderPO.getFscOrderId());
                this.writeFailLog(fscComOrderListSyncAbilityReqBO, JSON.toJSONString((Object)proxySendResult));
            }
        }
    }
}

